/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.rest;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.commonjava.freeki.infra.render.RenderingEngine;
import org.commonjava.freeki.infra.render.RenderingException;
import org.commonjava.freeki.infra.route.Method;
import org.commonjava.freeki.infra.route.RouteHandler;
import org.commonjava.freeki.infra.route.anno.Route;
import org.commonjava.freeki.infra.route.anno.Routes;
import org.commonjava.freeki.model.Group;
import org.commonjava.freeki.rest.PathParameter;
import org.commonjava.freeki.store.FreekiStore;
import org.commonjava.freeki.util.ContentType;
import org.commonjava.mimeparse.MIMEParse;
import org.commonjava.util.logging.Logger;
import org.vertx.java.core.http.HttpServerRequest;

public class GroupContentHandler
implements RouteHandler {
    private static final Set<String> DIR_ACCEPT = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(ContentType.TEXT_HTML.value());
            this.add(ContentType.TEXT_PLAIN.value());
            this.add(ContentType.APPLICATION_JSON.value());
        }
    };
    private final FreekiStore store;
    private final RenderingEngine engine;
    private final Logger logger = new Logger(this.getClass());

    public GroupContentHandler(FreekiStore store, RenderingEngine engine) {
        this.store = store;
        this.engine = engine;
    }

    @Routes(value={@Route(path="/api/group/:dir=(.+)", method=Method.DELETE)})
    public void delete(HttpServerRequest req) throws Exception {
        String dir = req.params().get(PathParameter.DIR.param());
        if (dir == null) {
            dir = "/";
        }
        if (!this.store.hasGroup(dir)) {
            req.response().setStatusCode(404).setStatusMessage("Not found");
            return;
        }
        boolean success = this.store.deleteGroup(dir);
        if (success) {
            req.response().setStatusCode(200).setStatusMessage("Deleted").end();
        } else {
            req.response().setStatusCode(417).setStatusMessage("Delete failed").end();
        }
    }

    @Routes(value={@Route(path="/api/group/:dir=(.+)", method=Method.PUT), @Route(path="/api/group/:dir=(.+)", method=Method.POST)})
    public void store(HttpServerRequest req) throws Exception {
        String dir = req.params().get(PathParameter.DIR.param());
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (this.store.storeGroup(new Group(dir))) {
            req.response().putHeader("Location", "/wiki/" + dir + "/").setStatusCode(201).setStatusMessage("Created: " + dir).end();
        } else {
            req.response().setStatusCode(400).setStatusMessage("Could not create: " + dir).end();
        }
    }

    @Routes(value={@Route(path="/wiki/:dir=(.+)/", method=Method.GET), @Route(path="/wiki/", method=Method.GET), @Route(path="/wiki", method=Method.GET), @Route(path="/api/group/:dir=(.+)", method=Method.GET)})
    public void get(HttpServerRequest req) throws Exception {
        String acceptHeader = req.headers().get("Accept");
        req.response().setChunked(true);
        req.response().setStatusCode(200);
        String dir = req.params().get(PathParameter.DIR.param());
        if (dir == null) {
            dir = "/";
        } else if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        String mimeAccept = MIMEParse.bestMatch(DIR_ACCEPT, acceptHeader);
        ContentType type = ContentType.find(mimeAccept);
        try {
            Group group = this.store.getGroup(dir);
            this.logger.info("Got group with %d children:\n\n  %s\n\n", group.getChildren().size(), StringUtils.join(group.getChildren(), "\n  "));
            String rendered = this.engine.render(group, type);
            req.response().end(rendered);
        }
        catch (IOException | RenderingException e) {
            this.logger.error("Failed to retrieve group: %s. Reason: %s", e, dir, e.getMessage());
            throw e;
        }
    }
}

