/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.jmx.AbstractMBean;
import com.hazelcast.jmx.JMXAttribute;
import com.hazelcast.jmx.JMXDescription;
import com.hazelcast.jmx.JMXOperation;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.jmx.MemberMBean;
import com.hazelcast.jmx.ObjectNameSpec;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JMXDescription(value="Hazelcast cluster")
public class ClusterMBean
extends AbstractMBean<HazelcastInstance> {
    private ObjectNameSpec clusterObjectNames;
    private MembershipListener membershipListener;
    private final Config config;
    private final Cluster cluster;
    private final String name;

    public ClusterMBean(ManagementService service, String name) {
        super(service.getInstance(), service);
        this.name = name;
        this.config = service.getInstance().getConfig();
        this.cluster = service.getInstance().getCluster();
        this.clusterObjectNames = new ObjectNameSpec(name);
    }

    @Override
    public ObjectNameSpec getNameSpec() {
        return new ObjectNameSpec("Cluster", this.name);
    }

    public ObjectNameSpec getRootName() {
        return this.clusterObjectNames;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (!registrationDone.booleanValue()) {
            return;
        }
        try {
            this.membershipListener = new MembershipListener(){

                public void memberAdded(MembershipEvent event) {
                    ClusterMBean.this.registerMember(event.getMember());
                }

                public void memberRemoved(MembershipEvent event) {
                    ClusterMBean.this.unregisterMember(event.getMember());
                }
            };
            this.cluster.addMembershipListener(this.membershipListener);
            for (Member m : this.cluster.getMembers()) {
                this.registerMember(m);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to start JMX member listener MBeans", e);
        }
    }

    @Override
    public void preDeregister() throws Exception {
        this.cluster.removeMembershipListener(this.membershipListener);
        super.preDeregister();
    }

    private void registerMember(Member member) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            MemberMBean mbean = new MemberMBean(member, this.managementService);
            mbean.setParentName(this.clusterObjectNames);
            if (!mbs.isRegistered(mbean.getObjectName())) {
                mbs.registerMBean(mbean, mbean.getObjectName());
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Unable to register Member MBeans", e);
        }
    }

    private void unregisterMember(Member member) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            MemberMBean mbean = new MemberMBean(member, this.managementService);
            mbean.setParentName(this.clusterObjectNames);
            if (mbs.isRegistered(mbean.getObjectName())) {
                mbs.unregisterMBean(mbean.getObjectName());
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Unable to unregister Member MBeans", e);
        }
    }

    @JMXAttribute(value="Config")
    @JMXDescription(value="Config.toString() result")
    public String getConfig() {
        return this.config.toString();
    }

    @JMXAttribute(value="InstanceName")
    @JMXDescription(value="Name of intance")
    public String getInstanceName() {
        return ((HazelcastInstance)this.getManagedObject()).getName();
    }

    @JMXAttribute(value="ConfigSource")
    @JMXDescription(value="The source of the cluster instance configuration")
    public String getConfigFileURL() {
        File configurationFile = this.config.getConfigurationFile();
        if (configurationFile != null) {
            return configurationFile.getAbsolutePath();
        }
        URL configurationUrl = this.config.getConfigurationUrl();
        if (configurationUrl != null) {
            return configurationUrl.toString();
        }
        return null;
    }

    @JMXAttribute(value="GroupName")
    @JMXDescription(value="The current group name")
    public String getGroupName() {
        return this.config.getGroupConfig().getName();
    }

    @JMXAttribute(value="Port")
    @JMXDescription(value="The network port used by multicast")
    public int getPort() {
        return this.config.getNetworkConfig().getPort();
    }

    @JMXAttribute(value="PortAutoIncrement")
    @JMXDescription(value="The network port is autoincremented if already in use")
    public boolean isPortAutoIncrement() {
        return this.config.getNetworkConfig().isPortAutoIncrement();
    }

    @JMXAttribute(value="ClusterTime")
    @JMXDescription(value="Current cluster time")
    public long getClusterTime() {
        return this.cluster.getClusterTime();
    }

    @JMXAttribute(value="MemberCount")
    @JMXDescription(value="Current size of the cluster")
    public int getMemberCount() {
        Set<Member> members = this.cluster.getMembers();
        return members.size();
    }

    @JMXAttribute(value="Members")
    @JMXDescription(value="List of member currently in the cluster")
    public List<String> getMembers() {
        Set<Member> members = this.cluster.getMembers();
        ArrayList<String> result = new ArrayList<String>();
        for (Member m : members) {
            InetSocketAddress socketAddress = m.getInetSocketAddress();
            result.add(socketAddress.getHostName() + ':' + socketAddress.getPort());
        }
        return result;
    }

    @JMXAttribute(value="Running")
    @JMXDescription(value="Node's running state")
    public boolean isRunning() {
        LifecycleService lifecycleService = ((HazelcastInstance)this.getManagedObject()).getLifecycleService();
        return lifecycleService.isRunning();
    }

    @JMXOperation(value="restart")
    @JMXDescription(value="Restart node")
    public void restart() {
        LifecycleService lifecycleService = ((HazelcastInstance)this.getManagedObject()).getLifecycleService();
        lifecycleService.restart();
    }

    @JMXOperation(value="shutdown")
    @JMXDescription(value="Shutdown node")
    public void shutdown() {
        LifecycleService lifecycleService = ((HazelcastInstance)this.getManagedObject()).getLifecycleService();
        lifecycleService.shutdown();
    }
}

