/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.store;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.model.ChildRef;
import org.commonjava.freeki.model.Group;
import org.commonjava.freeki.model.Page;
import org.commonjava.util.logging.Logger;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class FreekiStore {
    private static final CharSequence README = "This is a marker file for a freeki content group. You can add pages to this group through the UI.";
    private final Logger logger = new Logger(this.getClass());
    private final FreekiConfig config;
    private Git git;
    private int basepathLength;
    private String username;
    private String email;

    public FreekiStore(FreekiConfig config) throws IOException {
        this.config = config;
        this.setupGit();
    }

    @PostConstruct
    public void setupGit() throws IOException {
        this.basepathLength = this.config.getStorageDir().getPath().length() + 1;
        File gitDir = new File(this.config.getStorageDir(), ".git");
        boolean create = !gitDir.isDirectory();
        FileRepositoryBuilder builder = (FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).readEnvironment();
        FileRepository repo = builder.build();
        this.username = repo.getConfig().getString("user", null, "name");
        this.email = repo.getConfig().getString("user", null, "email");
        if (create) {
            repo.create();
        }
        this.git = new Git(repo);
    }

    public boolean hasGroup(String group) {
        File root = this.config.getStorageDir();
        File d = new File(root, group);
        return d.isDirectory();
    }

    public boolean hasPage(String group, String title) {
        File file = this.getFile(group, title);
        return file.isFile();
    }

    public SortedSet<ChildRef> listPages(String group) {
        SortedSet<ChildRef> refs = this.listChildren(group);
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            ChildRef ref = (ChildRef)it.next();
            if (ChildRef.ChildType.GROUP != ref.getType()) continue;
            it.remove();
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ChildRef> listChildren(String group) {
        File root = this.config.getStorageDir();
        File d = new File(root, group);
        TreeSet<ChildRef> result = new TreeSet<ChildRef>();
        if (d.isDirectory()) {
            File[] files;
            this.logger.info("Listing children in directory: %s\n", d);
            for (File file : files = d.listFiles()) {
                String name = file.getName();
                this.logger.info(name, new Object[0]);
                if (name.startsWith(".")) {
                    this.logger.info("Skipping: %s\n", name);
                    continue;
                }
                if (file.isDirectory()) {
                    result.add(new ChildRef(ChildRef.ChildType.GROUP, name, name));
                    continue;
                }
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(file));
                    String title = Page.readTitle(br);
                    this.logger.info("Page %s has title: %s\n", file, title);
                    if (title == null && (title = file.getName()).endsWith(".md")) {
                        title = title.substring(0, title.length() - 3);
                    }
                    result.add(new ChildRef(ChildRef.ChildType.PAGE, title, Page.idFor(title)));
                }
                catch (IOException e) {
                    try {
                        this.logger.error("Cannot read: '%s'. Reason: %s", e, file, e.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(br);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(br);
                    continue;
                }
                IOUtils.closeQuietly(br);
            }
        }
        return result;
    }

    public boolean storeGroup(Group group) throws IOException {
        File groupDir = this.getFile(group.getName(), null);
        if (!groupDir.exists()) {
            groupDir.mkdirs();
            File readme = new File(groupDir, "README.txt");
            FileUtils.write(readme, README);
            this.addAndCommit(readme, "Adding new group: " + group.getName());
            return true;
        }
        return false;
    }

    public boolean storePage(Page page) throws IOException {
        page.repair();
        File pageFile = this.getFile(page.getGroup(), page.getTitle());
        File dir = pageFile.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory structure for page: " + dir.getAbsolutePath());
        }
        boolean update = pageFile.exists();
        FileUtils.write(pageFile, page.render());
        this.addAndCommit(pageFile, (update ? "Updating" : "Creating") + " page: " + page.getTitle() + " in group: " + page.getGroup());
        return !update;
    }

    private File getFile(String group, String title) {
        return this.getFileById(group, title == null ? null : Page.idFor(title));
    }

    private File getFileById(String group, String id) {
        File root = this.config.getStorageDir();
        File groupDir = new File(root, group);
        return id == null ? groupDir : new File(groupDir, id + ".md");
    }

    public Page getPage(String group, String id) throws IOException {
        System.out.printf("Looking for page: %s in group: %s\n", id, group);
        File file = this.getFileById(group, id);
        if (!file.exists()) {
            System.out.printf("Not a page: %s\n", file);
            return null;
        }
        System.out.printf("Reading page from: %s\n", file);
        String content = FileUtils.readFileToString(file);
        System.out.printf("Page content:\n\n%s\n\n", content);
        return new Page(group, id, content, file.lastModified());
    }

    public boolean deleteGroup(String group) throws IOException {
        return this.doDelete(group, null);
    }

    public boolean deletePage(String group, String id) throws IOException {
        return this.doDelete(group, id);
    }

    private boolean doDelete(String group, String id) throws IOException {
        File file = this.getFileById(group, id);
        if (file == null) {
            file = new File(this.config.getStorageDir(), group);
        }
        HashSet<File> deleted = new HashSet<File>();
        if (file.isDirectory()) {
            FileUtils.forceDelete(file);
            deleted.add(file);
            file = file.getParentFile();
        } else if (file.exists()) {
            file.delete();
            deleted.add(file);
            file = file.getParentFile();
        }
        while (file.isDirectory() && !this.config.getStorageDir().equals(file) && file.list().length < 1) {
            file.delete();
            deleted.add(file);
            file = file.getParentFile();
        }
        if (!deleted.isEmpty()) {
            this.deleteAndCommit(deleted, "Removing page: " + id + " from group: " + group + ", and pruning empty directories.");
            return true;
        }
        return false;
    }

    private void addAndCommit(File file, String message) throws IOException {
        try {
            String filepath = file.getPath().substring(this.basepathLength);
            this.git.add().addFilepattern(filepath).call();
            this.git.commit().setOnly(filepath).setMessage(message).setAuthor(this.username, this.email).call();
        }
        catch (NoFilepatternException e) {
            throw new IOException("Cannot add to git: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new IOException("Cannot add to git: " + e.getMessage(), e);
        }
    }

    private void deleteAndCommit(Set<File> deleted, String message) throws IOException {
        try {
            RmCommand rm = this.git.rm();
            CommitCommand commit = this.git.commit();
            for (File file : deleted) {
                String filepath = file.getPath().substring(this.basepathLength);
                rm = rm.addFilepattern(filepath);
                commit = commit.setOnly(filepath);
            }
            rm.call();
            commit.setMessage(message).setAuthor(this.username, this.email).call();
        }
        catch (NoFilepatternException e) {
            throw new IOException("Cannot remove from git: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new IOException("Cannot remove from git: " + e.getMessage(), e);
        }
    }

    public SortedSet<Group> listGroups(String subgroup) throws IOException {
        File root;
        File dir = root = this.config.getStorageDir();
        if (subgroup != null) {
            dir = new File(dir, subgroup);
        }
        String[] names = dir.isDirectory() ? dir.list() : new String[]{};
        TreeSet<Group> groups = new TreeSet<Group>();
        for (String name : names) {
            File f = new File(dir, name);
            if (!f.isDirectory()) continue;
            String groupName = Group.nameFor(subgroup, name);
            SortedSet<ChildRef> pages = this.listChildren(groupName);
            groups.add(new Group(groupName, pages));
        }
        return groups;
    }

    public Group getGroup(String groupName) throws IOException {
        if (groupName == null || groupName.trim().length() < 1) {
            return null;
        }
        File groupDir = new File(this.config.getStorageDir(), groupName);
        if (!groupDir.isDirectory()) {
            return null;
        }
        SortedSet<ChildRef> pages = this.listChildren(groupName);
        return new Group(groupName, pages);
    }
}

