/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.infra.render;

import java.util.HashMap;
import java.util.Map;
import org.commonjava.freeki.infra.render.ContentRenderer;
import org.commonjava.freeki.infra.render.RenderingException;
import org.commonjava.freeki.util.ContentType;

public class RenderingEngine {
    private final Map<ContentType, ContentRenderer> renderers = new HashMap<ContentType, ContentRenderer>();

    public RenderingEngine() {
    }

    public RenderingEngine(Iterable<ContentRenderer> renderers) {
        this.mapRenderers(renderers);
    }

    private void mapRenderers(Iterable<ContentRenderer> rs) {
        for (ContentRenderer r : rs) {
            for (ContentType t : r.getContentTypes()) {
                this.renderers.put(t, r);
            }
        }
    }

    public String render(Object data, ContentType type) throws RenderingException {
        if (data == null) {
            return null;
        }
        ContentRenderer renderer = this.renderers.get(type);
        if (renderer != null) {
            return renderer.render(data);
        }
        throw new RenderingException("Cannot find renderer for content type: %s", type);
    }
}

