/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.cli;

import groovy.text.GStringTemplateEngine;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ServiceLoader;
import org.commonjava.freeki.cli.CliOptions;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.conf.GTemplateConfig;
import org.commonjava.freeki.infra.render.ContentRenderer;
import org.commonjava.freeki.infra.render.RenderingEngine;
import org.commonjava.freeki.infra.render.json.JsonRenderer;
import org.commonjava.freeki.infra.render.tmpl.GTHtmlRenderer;
import org.commonjava.freeki.infra.render.tmpl.GTTextRenderer;
import org.commonjava.freeki.infra.route.ApplicationRouter;
import org.commonjava.freeki.infra.route.RouteCollection;
import org.commonjava.freeki.infra.route.RouteHandler;
import org.commonjava.freeki.rest.GroupContentHandler;
import org.commonjava.freeki.rest.OopsHandler;
import org.commonjava.freeki.rest.PageContentHandler;
import org.commonjava.freeki.rest.StaticContentHandler;
import org.commonjava.freeki.store.FreekiStore;
import org.commonjava.freeki.util.ContentType;
import org.commonjava.web.json.ser.JsonSerializer;
import org.commonjava.web.json.ser.WebSerializationAdapter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.pegdown.PegDownProcessor;
import org.vertx.java.core.impl.DefaultVertx;
import org.vertx.java.platform.Verticle;

public class Main
extends Verticle {
    private final PegDownProcessor proc;
    private final GStringTemplateEngine templates;
    private boolean canStart = false;
    private final CliOptions opts = new CliOptions();

    public static void main(String[] args) throws IOException {
        new Main(args).run();
    }

    public Main(String[] args) {
        CmdLineParser parser = new CmdLineParser(this.opts);
        try {
            parser.parseArgument(args);
            this.canStart = true;
        }
        catch (CmdLineException e) {
            System.out.printf("ERROR: %s", e.getMessage());
            Main.printUsage(parser, e);
        }
        if (this.opts.isHelp()) {
            Main.printUsage(parser, null);
            this.canStart = false;
        }
        if (this.canStart) {
            this.proc = new PegDownProcessor();
            this.templates = new GStringTemplateEngine();
        } else {
            this.proc = null;
            this.templates = null;
        }
    }

    private static void printUsage(CmdLineParser parser, Exception error) {
        if (error != null) {
            System.err.println("Invalid option(s): " + error.getMessage());
            System.err.println();
        }
        System.err.println("Usage: $0 [OPTIONS] [<target-path>]");
        System.err.println();
        System.err.println();
        parser.setUsageWidth(System.getenv("COLUMNS") == null ? 100 : Integer.valueOf(System.getenv("COLUMNS")));
        parser.printUsage(System.err);
        System.err.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        if (!this.canStart) {
            return;
        }
        this.start();
        DefaultVertx v = new DefaultVertx();
        this.setVertx(v);
        final FreekiConfig mainConf = this.opts.getContentDir() == null ? new FreekiConfig() : new FreekiConfig(this.opts.getContentDir());
        final FreekiStore store = new FreekiStore(mainConf);
        HashMap<String, String> rawTemplateConf = new HashMap<String, String>();
        rawTemplateConf.put("group@" + ContentType.TEXT_HTML.value(), "groovy/html/group.groovy");
        rawTemplateConf.put("page@" + ContentType.TEXT_HTML.value(), "groovy/html/page.groovy");
        rawTemplateConf.put("group@" + ContentType.TEXT_PLAIN.value(), "groovy/plain/group.groovy");
        rawTemplateConf.put("page@" + ContentType.TEXT_PLAIN.value(), "groovy/plain/page.groovy");
        GTemplateConfig templateConfig = new GTemplateConfig(rawTemplateConf, mainConf.getBrandingDir());
        HashSet<ContentRenderer> renderers = new HashSet<ContentRenderer>();
        renderers.add(new GTHtmlRenderer(this.templates, this.proc, templateConfig));
        renderers.add(new GTTextRenderer(this.templates, templateConfig));
        renderers.add(new JsonRenderer(new JsonSerializer(new WebSerializationAdapter[0])));
        final RenderingEngine engine = new RenderingEngine(renderers);
        HashSet<RouteHandler> handlers = new HashSet<RouteHandler>(){
            private static final long serialVersionUID = 1L;
            {
                this.add(new GroupContentHandler(store, engine));
                this.add(new PageContentHandler(store, engine));
                this.add(new StaticContentHandler(mainConf));
            }
        };
        ServiceLoader<RouteCollection> collections = ServiceLoader.load(RouteCollection.class);
        ApplicationRouter router = new ApplicationRouter((Collection<RouteHandler>)handlers, collections);
        router.noMatch(new OopsHandler(this.proc));
        String listen = this.opts.getListen();
        this.vertx.createHttpServer().requestHandler(router).listen(this.opts.getPort(), listen);
        System.out.printf("Listening for requests on %s:%s\n\n", this.opts.getListen(), this.opts.getPort());
        Main main = this;
        synchronized (main) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

