/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.server;

import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebSocketTransport<S>
extends HttpTransport {
    public static final String NAME = "websocket";
    public static final String PREFIX = "ws";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String MESSAGES_PER_FRAME_OPTION = "messagesPerFrame";
    public static final String MAX_MESSAGE_SIZE_OPTION = "maxMessageSize";
    public static final String IDLE_TIMEOUT_OPTION = "idleTimeout";
    public static final String THREAD_POOL_MAX_SIZE = "threadPoolMaxSize";
    private static final ServerMessage[] EMPTY_MESSAGES = new ServerMessage[0];
    private final ThreadLocal<BayeuxContext> _bayeuxContext = new ThreadLocal();
    private Executor _executor;
    private ScheduledExecutorService _scheduler;
    private String _protocol;
    private int _messagesPerFrame;

    protected AbstractWebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    protected void init() {
        super.init();
        this._executor = this.newExecutor();
        this._scheduler = this.newScheduledExecutor();
        this._protocol = this.getOption(PROTOCOL_OPTION, null);
        this._messagesPerFrame = this.getOption(MESSAGES_PER_FRAME_OPTION, 1);
    }

    protected void destroy() {
        this._scheduler.shutdownNow();
        Executor threadPool = this._executor;
        if (threadPool instanceof ExecutorService) {
            ((ExecutorService)threadPool).shutdown();
        }
        super.destroy();
    }

    protected Executor newExecutor() {
        int size = this.getOption(THREAD_POOL_MAX_SIZE, 64);
        return Executors.newFixedThreadPool(size);
    }

    protected ScheduledExecutorService newScheduledExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    public Executor getExecutor() {
        return this._executor;
    }

    public ScheduledExecutorService getScheduler() {
        return this._scheduler;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public int getMessagesPerFrame() {
        return this._messagesPerFrame;
    }

    public boolean accept(HttpServletRequest request) {
        return "WebSocket".equalsIgnoreCase(request.getHeader("Upgrade"));
    }

    public BayeuxContext getContext() {
        return this._bayeuxContext.get();
    }

    protected void handleJSONParseException(S wsSession, ServerSession session, String json, Throwable exception) {
        this._logger.warn("Error parsing JSON: " + json, exception);
    }

    protected void handleException(S wsSession, ServerSession session, Throwable exception) {
        this._logger.debug("", exception);
    }

    protected abstract void send(S var1, ServerSession var2, String var3);

    protected void onClose(int code, String reason) {
    }

    static /* synthetic */ void access$1000(AbstractWebSocketTransport x0, String x1, Object[] x2) {
        x0.debug(x1, x2);
    }

    static /* synthetic */ void access$1100(AbstractWebSocketTransport x0, String x1, Object[] x2) {
        x0.debug(x1, x2);
    }

    static /* synthetic */ void access$1200(AbstractWebSocketTransport x0, String x1, Object[] x2) {
        x0.debug(x1, x2);
    }

    static /* synthetic */ ServerMessage[] access$1300() {
        return EMPTY_MESSAGES;
    }

    static /* synthetic */ Logger access$1400(AbstractWebSocketTransport x0) {
        return x0._logger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractWebSocketScheduler
    implements AbstractServerTransport.Scheduler,
    Runnable {
        private final AtomicBoolean _scheduling = new AtomicBoolean();
        private final BayeuxContext _context;
        private volatile ServerSessionImpl _session;
        private ServerMessage.Mutable _connectReply;
        private ScheduledFuture<?> _connectTask;

        protected AbstractWebSocketScheduler(BayeuxContext context) {
            this._context = context;
        }

        protected void send(S wsSession, List<ServerMessage> messages) {
            int count = messages.size();
            int messagesPerFrame = AbstractWebSocketTransport.this.getMessagesPerFrame();
            int batchSize = messagesPerFrame > 0 ? Math.min(messagesPerFrame, count) : count;
            this.send(wsSession, messages, batchSize);
        }

        protected void send(S wsSession, List<ServerMessage> messages, int batchSize) {
            int batch;
            if (messages.isEmpty()) {
                return;
            }
            int count = messages.size();
            int capacity = batchSize * 4 * 32;
            StringBuilder builder = new StringBuilder(capacity);
            for (int index = 0; index < count; index += batch) {
                builder.setLength(0);
                builder.append("[");
                batch = Math.min(batchSize, count - index);
                boolean comma = false;
                for (int b = 0; b < batch; ++b) {
                    ServerMessage serverMessage = messages.get(index + b);
                    if (serverMessage == null) continue;
                    if (comma) {
                        builder.append(",");
                    }
                    comma = true;
                    builder.append(serverMessage.getJSON());
                }
                builder.append("]");
                AbstractWebSocketTransport.this.send(wsSession, (ServerSession)this._session, builder.toString());
            }
        }

        protected void onClose(int code, String reason) {
            ServerSessionImpl session = this._session;
            if (session != null) {
                this._session = null;
                session.startIntervalTimeout(AbstractWebSocketTransport.this.getInterval());
                this.cancelMetaConnectTask(session);
            }
            AbstractWebSocketTransport.this.debug("Closing {}/{} - {}", new Object[]{code, reason, session});
            AbstractWebSocketTransport.this.onClose(code, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean cancelMetaConnectTask(ServerSessionImpl session) {
            ScheduledFuture<?> connectTask;
            Object object = session.getLock();
            synchronized (object) {
                connectTask = this._connectTask;
                this._connectTask = null;
            }
            if (connectTask == null) {
                return false;
            }
            AbstractWebSocketTransport.this.debug("Cancelling meta connect task {}", new Object[]{connectTask});
            connectTask.cancel(false);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onMessage(S wsSession, String data) {
            AbstractWebSocketTransport.this._bayeuxContext.set(this._context);
            AbstractWebSocketTransport.this.getBayeux().setCurrentTransport((AbstractServerTransport)AbstractWebSocketTransport.this);
            try {
                ServerMessage.Mutable[] messages = AbstractWebSocketTransport.this.parseMessages(data);
                AbstractWebSocketTransport.this.debug("Received {}", new Object[]{data});
                this.processMessages(wsSession, messages);
            }
            catch (ParseException x) {
                this.close(1011, x.toString());
                AbstractWebSocketTransport.this.handleJSONParseException(wsSession, (ServerSession)this._session, data, x);
            }
            catch (Exception x) {
                this.close(1011, x.toString());
                AbstractWebSocketTransport.this.handleException(wsSession, (ServerSession)this._session, x);
            }
            finally {
                AbstractWebSocketTransport.this._bayeuxContext.set(null);
                AbstractWebSocketTransport.this.getBayeux().setCurrentTransport(null);
            }
        }

        private void processMessages(S wsSession, ServerMessage.Mutable[] messages) throws IOException {
            ServerSessionImpl session = this._session;
            boolean startInterval = false;
            boolean send = true;
            List queue = null;
            for (int i = 0; i < messages.length; ++i) {
                ServerMessage.Mutable reply;
                String channelName;
                ServerMessage.Mutable message = messages[i];
                AbstractWebSocketTransport.this._logger.debug("Processing {}", (Object)message);
                String clientId = message.getClientId();
                if (session == null || !session.getId().equals(clientId)) {
                    this._session = session = (ServerSessionImpl)AbstractWebSocketTransport.this.getBayeux().getSession(message.getClientId());
                }
                if (session != null && !session.isHandshook()) {
                    session = null;
                    this._session = null;
                }
                if ((channelName = message.getChannel()).equals("/meta/handshake")) {
                    if (messages.length > 1) {
                        throw new IOException();
                    }
                    reply = this.processMetaHandshake(session, message);
                    if (reply != null) {
                        session = (ServerSessionImpl)AbstractWebSocketTransport.this.getBayeux().getSession(reply.getClientId());
                    }
                    messages[i] = this.processReply(session, reply);
                    continue;
                }
                if (channelName.equals("/meta/connect")) {
                    if (messages.length > 1) {
                        throw new IOException();
                    }
                    reply = this.processMetaConnect(session, message);
                    messages[i] = this.processReply(session, reply);
                    startInterval = reply != null;
                    send = startInterval;
                    if (!send || session == null || !AbstractWebSocketTransport.this.isMetaConnectDeliveryOnly() && !session.isMetaConnectDeliveryOnly()) continue;
                    queue = session.takeQueue();
                    continue;
                }
                reply = AbstractWebSocketTransport.this.getBayeux().handle(session, message);
                messages[i] = this.processReply(session, reply);
            }
            if (send) {
                this.flush(wsSession, session, startInterval, queue, (ServerMessage[])messages);
            }
        }

        private ServerMessage.Mutable processMetaHandshake(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = AbstractWebSocketTransport.this.getBayeux().handle(session, message);
            if (reply != null && reply.isSuccessful() && (session = (ServerSessionImpl)AbstractWebSocketTransport.this.getBayeux().getSession(reply.getClientId())) != null) {
                session.setScheduler((AbstractServerTransport.Scheduler)this);
            }
            return reply;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServerMessage.Mutable processMetaConnect(ServerSessionImpl session, ServerMessage.Mutable message) {
            boolean wasConnected = session != null && session.isConnected();
            ServerMessage.Mutable reply = AbstractWebSocketTransport.this.getBayeux().handle(session, message);
            if (reply != null && session != null) {
                if (reply.isSuccessful() && session.isConnected()) {
                    boolean replyToMetaConnect;
                    session.setScheduler((AbstractServerTransport.Scheduler)this);
                    boolean metaConnectDelivery = AbstractWebSocketTransport.this.isMetaConnectDeliveryOnly() || session.isMetaConnectDeliveryOnly();
                    boolean hasMessages = session.hasNonLazyMessages();
                    boolean bl = replyToMetaConnect = hasMessages && metaConnectDelivery;
                    if (!replyToMetaConnect) {
                        boolean holdMetaConnect;
                        long timeout = session.calculateTimeout(AbstractWebSocketTransport.this.getTimeout());
                        boolean bl2 = holdMetaConnect = timeout > 0L && wasConnected;
                        if (holdMetaConnect) {
                            Object object = session.getLock();
                            synchronized (object) {
                                if (!session.hasNonLazyMessages()) {
                                    if (this.cancelMetaConnectTask(session)) {
                                        AbstractWebSocketTransport.this._logger.debug("Cancelled unresponded meta connect {}", (Object)this._connectReply);
                                    }
                                    this._connectReply = reply;
                                    long expiration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + timeout;
                                    this._connectTask = AbstractWebSocketTransport.this.getScheduler().schedule(new MetaConnectReplyTask(reply, expiration), timeout, TimeUnit.MILLISECONDS);
                                    AbstractWebSocketTransport.this._logger.debug("Scheduled meta connect {}", this._connectTask);
                                    reply = null;
                                }
                            }
                        }
                    }
                }
                if (reply != null && session.isDisconnected()) {
                    reply.getAdvice(true).put("reconnect", "none");
                }
            }
            return reply;
        }

        private ServerMessage.Mutable processReply(ServerSessionImpl session, ServerMessage.Mutable reply) {
            if (reply != null && (reply = AbstractWebSocketTransport.this.getBayeux().extendReply(session, session, reply)) != null) {
                AbstractWebSocketTransport.this.getBayeux().freeze(reply);
            }
            return reply;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush(S wsSession, ServerSessionImpl session, boolean startInterval, List<ServerMessage> queue, ServerMessage[] replies) {
            try {
                if (queue != null) {
                    this.send(wsSession, queue);
                }
            }
            finally {
                if (startInterval && session != null && session.isConnected()) {
                    session.startIntervalTimeout(AbstractWebSocketTransport.this.getInterval());
                }
            }
            this.send(wsSession, Arrays.asList(replies), replies.length);
        }

        protected abstract void close(int var1, String var2);

        public void cancel() {
            ServerSessionImpl session = this._session;
            if (session != null && this.cancelMetaConnectTask(session)) {
                this.close(1000, "Cancel");
            }
        }

        public void schedule() {
            if (this._scheduling.compareAndSet(false, true)) {
                AbstractWebSocketTransport.this._executor.execute(this);
            }
        }

        @Override
        public void run() {
            this.schedule(false, null);
        }

        protected abstract void schedule(boolean var1, ServerMessage.Mutable var2);

        /*
         * Exception decompiling
         */
        protected void schedule(S wsSession, boolean timeout, ServerMessage.Mutable expiredConnectReply) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private class MetaConnectReplyTask
        implements Runnable {
            private final ServerMessage.Mutable _connectReply;
            private final long _connectExpiration;

            private MetaConnectReplyTask(ServerMessage.Mutable connectReply, long connectExpiration) {
                this._connectReply = connectReply;
                this._connectExpiration = connectExpiration;
            }

            public void run() {
                long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                long delay = now - this._connectExpiration;
                if (delay > 5000L) {
                    AbstractWebSocketTransport.this.debug("/meta/connect {} expired {} ms too late", new Object[]{this._connectReply, delay});
                }
                AbstractWebSocketScheduler.this.schedule(true, this._connectReply);
            }
        }
    }
}

