/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketTransport
extends HttpTransport
implements WebSocketFactory.Acceptor {
    public static final String PREFIX = "ws";
    public static final String NAME = "websocket";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String MESSAGES_PER_FRAME_OPTION = "messagesPerFrame";
    public static final String BUFFER_SIZE_OPTION = "bufferSize";
    public static final String MAX_MESSAGE_SIZE_OPTION = "maxMessageSize";
    public static final String IDLE_TIMEOUT_OPTION = "idleTimeout";
    public static final String THREAD_POOL_MAX_SIZE = "threadPoolMaxSize";
    private final WebSocketFactory _factory = new WebSocketFactory((WebSocketFactory.Acceptor)this);
    private final ThreadLocal<WebSocketContext> _handshake = new ThreadLocal();
    private String _protocol;
    private Executor _executor;
    private ScheduledExecutorService _scheduler;
    private int _messagesPerFrame = 1;

    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    public void init() {
        super.init();
        this._protocol = this.getOption(PROTOCOL_OPTION, this._protocol);
        this._messagesPerFrame = this.getOption(MESSAGES_PER_FRAME_OPTION, this._messagesPerFrame);
        int bufferSize = this.getOption(BUFFER_SIZE_OPTION, this._factory.getBufferSize());
        this._factory.setBufferSize(bufferSize);
        int maxMessageSize = this.getOption(MAX_MESSAGE_SIZE_OPTION, bufferSize - 16);
        this._factory.setMaxTextMessageSize(maxMessageSize);
        long idleTimeout = this.getOption(IDLE_TIMEOUT_OPTION, this._factory.getMaxIdleTime());
        this._factory.setMaxIdleTime((int)idleTimeout);
        this._executor = this.newExecutor();
        this._scheduler = this.newScheduledExecutor();
        try {
            this._factory.start();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected void destroy() {
        try {
            this._factory.stop();
        }
        catch (Exception x) {
            this._logger.trace("", (Throwable)x);
        }
        this._scheduler.shutdown();
        Executor threadPool = this._executor;
        if (threadPool instanceof ExecutorService) {
            ((ExecutorService)threadPool).shutdown();
        } else if (threadPool instanceof LifeCycle) {
            try {
                ((LifeCycle)threadPool).stop();
            }
            catch (Exception x) {
                this._logger.trace("", (Throwable)x);
            }
        }
        super.destroy();
    }

    protected Executor newExecutor() {
        int size = this.getOption(THREAD_POOL_MAX_SIZE, 64);
        return Executors.newFixedThreadPool(size);
    }

    protected ScheduledExecutorService newScheduledExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    public boolean accept(HttpServletRequest request) {
        return "WebSocket".equalsIgnoreCase(request.getHeader("Upgrade"));
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this._factory.acceptWebSocket(request, response)) {
            this._logger.warn("Websocket not accepted");
            response.setHeader("Connection", "close");
            response.sendError(500);
        }
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        boolean sameProtocol;
        boolean bl = sameProtocol = this._protocol == null && protocol == null || this._protocol != null && this._protocol.equals(protocol);
        if (sameProtocol) {
            WebSocketContext handshake = new WebSocketContext(request);
            return new WebSocketScheduler(handshake, request.getHeader("User-Agent"));
        }
        return null;
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        return true;
    }

    protected void handleJSONParseException(WebSocket.Connection connection, String json, Throwable exception) {
        this._logger.warn("Error parsing JSON: " + json, exception);
    }

    protected void handleException(WebSocket.Connection connection, Throwable exception) {
        this._logger.warn("", exception);
    }

    public BayeuxContext getContext() {
        return this._handshake.get();
    }

    protected void send(WebSocket.Connection connection, List<ServerMessage> messages) throws IOException {
        int batch;
        if (messages.isEmpty()) {
            return;
        }
        int count = messages.size();
        int batchSize = this._messagesPerFrame > 0 ? Math.min(this._messagesPerFrame, count) : count;
        int capacity = batchSize * 4 * 32;
        StringBuilder builder = new StringBuilder(capacity);
        for (int index = 0; index < count; index += batch) {
            builder.setLength(0);
            builder.append("[");
            batch = Math.min(batchSize, count - index);
            for (int b = 0; b < batch; ++b) {
                if (b > 0) {
                    builder.append(",");
                }
                ServerMessage serverMessage = messages.get(index + b);
                builder.append(serverMessage.getJSON());
            }
            builder.append("]");
            this.send(connection, builder.toString());
        }
    }

    protected void send(WebSocket.Connection connection, ServerMessage message) throws IOException {
        StringBuilder builder = new StringBuilder(message.size() * 32);
        builder.append("[").append(message.getJSON()).append("]");
        this.send(connection, builder.toString());
    }

    protected void send(WebSocket.Connection connection, String data) throws IOException {
        this.debug("Sending {}", new Object[]{data});
        connection.sendMessage(data);
    }

    protected void onClose(int code, String message) {
    }

    static /* synthetic */ void access$800(WebSocketTransport x0, String x1, Object[] x2) {
        x0.debug(x1, x2);
    }

    static /* synthetic */ void access$900(WebSocketTransport x0, String x1, Object[] x2) {
        x0.debug(x1, x2);
    }

    static /* synthetic */ void access$1000(WebSocketTransport x0, String x1, Object[] x2) {
        x0.debug(x1, x2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WebSocketContext
    implements BayeuxContext {
        private final Principal _principal;
        private final InetSocketAddress _local;
        private final InetSocketAddress _remote;
        private final Map<String, List<String>> _headers = new HashMap<String, List<String>>();
        private final Map<String, List<String>> _parameters = new HashMap<String, List<String>>();
        private final Map<String, Object> _attributes = new HashMap<String, Object>();
        private final Map<String, String> _cookies = new HashMap<String, String>();
        private final HttpSession _session;
        private final ServletContext _context;
        private final String _url;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WebSocketContext(HttpServletRequest request) {
            this._local = new InetSocketAddress(request.getLocalAddr(), request.getLocalPort());
            this._remote = new InetSocketAddress(request.getRemoteAddr(), request.getRemotePort());
            for (String name : Collections.list(request.getHeaderNames())) {
                this._headers.put(name, Collections.unmodifiableList(Collections.list(request.getHeaders(name))));
            }
            for (String name : Collections.list(request.getParameterNames())) {
                this._parameters.put(name, Collections.unmodifiableList(Arrays.asList(request.getParameterValues(name))));
            }
            for (String name : Collections.list(request.getAttributeNames())) {
                this._attributes.put(name, request.getAttribute(name));
            }
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    this._cookies.put(c.getName(), c.getValue());
                }
            }
            this._principal = request.getUserPrincipal();
            this._session = request.getSession(false);
            if (this._session != null) {
                this._context = this._session.getServletContext();
            } else {
                ServletContext context = null;
                try {
                    HttpSession s = request.getSession(true);
                    context = s.getServletContext();
                    s.invalidate();
                }
                catch (IllegalStateException x) {
                    WebSocketTransport.this._logger.trace("", (Throwable)x);
                }
                finally {
                    this._context = context;
                }
            }
            StringBuffer url = request.getRequestURL();
            String query = request.getQueryString();
            if (query != null) {
                url.append("?").append(query);
            }
            this._url = url.toString();
        }

        public Principal getUserPrincipal() {
            return this._principal;
        }

        public boolean isUserInRole(String role) {
            HttpServletRequest request = WebSocketTransport.this.getCurrentRequest();
            return request != null && request.isUserInRole(role);
        }

        public InetSocketAddress getRemoteAddress() {
            return this._remote;
        }

        public InetSocketAddress getLocalAddress() {
            return this._local;
        }

        public String getHeader(String name) {
            List<String> headers = this._headers.get(name);
            return headers != null && headers.size() > 0 ? headers.get(0) : null;
        }

        public List<String> getHeaderValues(String name) {
            return this._headers.get(name);
        }

        public String getParameter(String name) {
            List<String> params = this._parameters.get(name);
            return params != null && params.size() > 0 ? params.get(0) : null;
        }

        public List<String> getParameterValues(String name) {
            return this._parameters.get(name);
        }

        public String getCookie(String name) {
            return this._cookies.get(name);
        }

        public String getHttpSessionId() {
            return this._session == null ? null : this._session.getId();
        }

        public Object getHttpSessionAttribute(String name) {
            return this._session == null ? null : this._session.getAttribute(name);
        }

        public void setHttpSessionAttribute(String name, Object value) {
            if (this._session == null) {
                throw new IllegalStateException("!session");
            }
            this._session.setAttribute(name, value);
        }

        public void invalidateHttpSession() {
            if (this._session != null) {
                this._session.invalidate();
            }
        }

        public Object getRequestAttribute(String name) {
            return this._attributes.get(name);
        }

        public Object getContextAttribute(String name) {
            return this._context.getAttribute(name);
        }

        public String getContextInitParameter(String name) {
            return this._context.getInitParameter(name);
        }

        public String getURL() {
            return this._url;
        }
    }

    protected class WebSocketScheduler
    implements WebSocket.OnTextMessage,
    AbstractServerTransport.Scheduler,
    Runnable {
        private final AtomicBoolean _scheduling = new AtomicBoolean();
        private final WebSocketContext _context;
        private final String _userAgent;
        private volatile ServerSessionImpl _session;
        private volatile WebSocket.Connection _connection;
        private ServerMessage.Mutable _connectReply;
        private ScheduledFuture _connectTask;

        public WebSocketScheduler(WebSocketContext context, String userAgent) {
            this._context = context;
            this._userAgent = userAgent;
        }

        public void onOpen(WebSocket.Connection connection) {
            this._connection = connection;
        }

        public void onClose(int code, String reason) {
            ServerSessionImpl session = this._session;
            if (session != null) {
                this._session = null;
                session.startIntervalTimeout(WebSocketTransport.this.getInterval());
                this.cancelMetaConnectTask(session);
            }
            WebSocketTransport.this.debug("Closing {}/{}", new Object[]{code, reason});
            WebSocketTransport.this.onClose(code, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cancelMetaConnectTask(ServerSessionImpl session) {
            ScheduledFuture connectTask;
            Object object = session.getLock();
            synchronized (object) {
                connectTask = this._connectTask;
                this._connectTask = null;
            }
            if (connectTask == null) {
                return false;
            }
            connectTask.cancel(false);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(String data) {
            WebSocketTransport.this._handshake.set(this._context);
            WebSocketTransport.this.getBayeux().setCurrentTransport((AbstractServerTransport)WebSocketTransport.this);
            try {
                ServerMessage.Mutable[] messages = WebSocketTransport.this.parseMessages(data);
                WebSocketTransport.this.debug("Received messages {}", new Object[]{data});
                for (ServerMessage.Mutable message : messages) {
                    this.onMessage(message);
                }
            }
            catch (ParseException x) {
                WebSocketTransport.this.handleJSONParseException(this._connection, data, x);
            }
            catch (Exception x) {
                WebSocketTransport.this.handleException(this._connection, x);
            }
            finally {
                WebSocketTransport.this._handshake.set(null);
                WebSocketTransport.this.getBayeux().setCurrentTransport(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onMessage(ServerMessage.Mutable message) throws IOException {
            boolean connect = "/meta/connect".equals(message.getChannel());
            ServerSessionImpl session = this._session;
            String clientId = message.getClientId();
            if (session == null || !session.getId().equals(clientId)) {
                this._session = session = (ServerSessionImpl)WebSocketTransport.this.getBayeux().getSession(message.getClientId());
            }
            if (session != null && !session.isHandshook()) {
                this._session = session = null;
            }
            boolean wasConnected = session != null && session.isConnected();
            ServerMessage.Mutable reply = WebSocketTransport.this.getBayeux().handle(session, message);
            if (reply != null) {
                if (session == null && (session = (ServerSessionImpl)WebSocketTransport.this.getBayeux().getSession(reply.getClientId())) != null) {
                    session.setUserAgent(this._userAgent);
                    session.setScheduler((AbstractServerTransport.Scheduler)this);
                }
                List queue = null;
                if (connect && reply.isSuccessful() && session != null && session.isConnected()) {
                    boolean replyToMetaConnect;
                    session.setScheduler((AbstractServerTransport.Scheduler)this);
                    boolean metaConnectDelivery = WebSocketTransport.this.isMetaConnectDeliveryOnly() || session.isMetaConnectDeliveryOnly();
                    boolean hasMessages = session.hasNonLazyMessages();
                    boolean bl = replyToMetaConnect = hasMessages && metaConnectDelivery;
                    if (replyToMetaConnect) {
                        queue = session.takeQueue();
                    } else {
                        boolean holdMetaConnect;
                        long timeout = session.calculateTimeout(WebSocketTransport.this.getTimeout());
                        boolean bl2 = holdMetaConnect = timeout > 0L && wasConnected;
                        if (holdMetaConnect) {
                            Object object = session.getLock();
                            synchronized (object) {
                                if (!session.hasNonLazyMessages()) {
                                    if (this.cancelMetaConnectTask(session)) {
                                        WebSocketTransport.this.debug("Cancelled unresponded meta connect {}", new Object[]{this._connectReply});
                                    }
                                    this._connectReply = reply;
                                    long expiration = System.currentTimeMillis() + timeout;
                                    this._connectTask = WebSocketTransport.this._scheduler.schedule(new MetaConnectReplyTask(reply, expiration), timeout, TimeUnit.MILLISECONDS);
                                    reply = null;
                                }
                            }
                            if (reply != null) {
                                queue = session.takeQueue();
                            }
                        }
                    }
                }
                if (reply != null) {
                    try {
                        if (queue != null) {
                            WebSocketTransport.this.send(this._connection, queue);
                        }
                    }
                    finally {
                        if (connect && session != null) {
                            if (session.isConnected()) {
                                session.startIntervalTimeout(WebSocketTransport.this.getInterval());
                            } else if (session.isDisconnected()) {
                                reply.getAdvice(true).put("reconnect", "none");
                            }
                        }
                    }
                    reply = WebSocketTransport.this.getBayeux().extendReply(session, session, reply);
                    if (reply != null) {
                        WebSocketTransport.this.getBayeux().freeze(reply);
                        WebSocketTransport.this.send(this._connection, (ServerMessage)reply);
                    }
                }
            }
        }

        public void cancel() {
            ServerSessionImpl session = this._session;
            if (session != null) {
                this.cancelMetaConnectTask(session);
            }
        }

        public void schedule() {
            if (this._scheduling.compareAndSet(false, true)) {
                WebSocketTransport.this._executor.execute(this);
            }
        }

        public void run() {
            this.schedule(false, null);
        }

        /*
         * Exception decompiling
         */
        private void schedule(boolean timeout, ServerMessage.Mutable expiredConnectReply) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private class MetaConnectReplyTask
        implements Runnable {
            private final ServerMessage.Mutable _connectReply;
            private final long _connectExpiration;

            private MetaConnectReplyTask(ServerMessage.Mutable connectReply, long connectExpiration) {
                this._connectReply = connectReply;
                this._connectExpiration = connectExpiration;
            }

            public void run() {
                long now = System.currentTimeMillis();
                long delay = now - this._connectExpiration;
                if (delay > 5000L) {
                    WebSocketTransport.this.debug("/meta/connect timeout expired {} ms too late", new Object[]{delay});
                }
                WebSocketScheduler.this.schedule(true, this._connectReply);
            }
        }
    }
}

