/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.transport;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.AbstractHttpTransport;

public abstract class AbstractStreamHttpTransport
extends AbstractHttpTransport {
    private static final String SCHEDULER_ATTRIBUTE = "org.cometd.scheduler";

    protected AbstractStreamHttpTransport(BayeuxServerImpl bayeux, String name) {
        super(bayeux, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.getBayeux().setCurrentTransport(this);
        this.setCurrentRequest(request);
        try {
            this.process(request, response);
        }
        finally {
            this.setCurrentRequest(null);
            this.getBayeux().setCurrentTransport(null);
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        AbstractHttpTransport.LongPollScheduler scheduler = (AbstractHttpTransport.LongPollScheduler)request.getAttribute(SCHEDULER_ATTRIBUTE);
        if (scheduler == null) {
            try {
                ServerMessage.Mutable[] messages = this.parseMessages(request);
                this.processMessages(request, response, messages);
            }
            catch (ParseException x) {
                this.handleJSONParseException(request, response, x.getMessage(), x.getCause());
            }
        } else {
            this.resume(request.getAsyncContext(), scheduler.getServerSession(), scheduler.getMetaConnectReply());
        }
    }

    @Override
    protected AbstractHttpTransport.HttpScheduler suspend(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, ServerMessage.Mutable reply, String browserId, long timeout) {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout(0L);
        AbstractHttpTransport.HttpScheduler scheduler = this.newHttpScheduler(asyncContext, session, reply, browserId, timeout);
        request.setAttribute(SCHEDULER_ATTRIBUTE, (Object)scheduler);
        return scheduler;
    }

    protected AbstractHttpTransport.HttpScheduler newHttpScheduler(AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, String browserId, long timeout) {
        return new DispatchingLongPollScheduler(asyncContext, session, reply, browserId, timeout);
    }

    protected abstract ServerMessage.Mutable[] parseMessages(HttpServletRequest var1) throws IOException, ParseException;

    protected ServerMessage.Mutable[] parseMessages(String[] requestParameters) throws IOException, ParseException {
        if (requestParameters == null || requestParameters.length == 0) {
            throw new IOException("Missing 'message' request parameter");
        }
        if (requestParameters.length == 1) {
            return this.parseMessages(requestParameters[0]);
        }
        ArrayList<ServerMessage.Mutable> messages = new ArrayList<ServerMessage.Mutable>();
        for (String batch : requestParameters) {
            if (batch == null) continue;
            messages.addAll(Arrays.asList(this.parseMessages(batch)));
        }
        return messages.toArray(new ServerMessage.Mutable[messages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(HttpServletRequest request, HttpServletResponse response, ServerSessionImpl session, boolean startInterval, List<ServerMessage> messages, ServerMessage.Mutable[] replies) {
        try {
            ServletOutputStream output;
            try {
                output = this.beginWrite(request, response);
                for (int i = 0; i < messages.size(); ++i) {
                    ServerMessage message = messages.get(i);
                    if (i > 0) {
                        output.write(44);
                    }
                    this.writeMessage(output, session, message);
                }
            }
            finally {
                if (startInterval && session != null && session.isConnected()) {
                    session.startIntervalTimeout(this.getInterval());
                }
            }
            boolean needsComma = !messages.isEmpty();
            for (int i = 0; i < replies.length; ++i) {
                ServerMessage.Mutable reply = replies[i];
                if (reply == null) continue;
                if (needsComma) {
                    output.write(44);
                }
                needsComma = true;
                this.writeMessage(output, session, (ServerMessage)reply);
            }
            this.endWrite(output);
        }
        catch (Exception x) {
            this.error(response, 500);
        }
    }

    protected void writeMessage(ServletOutputStream output, ServerSessionImpl session, ServerMessage message) throws IOException {
        output.print(message.getJSON());
    }

    private void error(HttpServletResponse response, int responseCode) {
        this.error(null, response, responseCode);
    }

    protected abstract ServletOutputStream beginWrite(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected abstract void endWrite(ServletOutputStream var1) throws IOException;

    protected class DispatchingLongPollScheduler
    extends AbstractHttpTransport.LongPollScheduler {
        public DispatchingLongPollScheduler(AsyncContext asyncContext, ServerSessionImpl session, ServerMessage.Mutable reply, String browserId, long timeout) {
            super(asyncContext, session, reply, browserId, timeout);
        }

        @Override
        protected void dispatch() {
            this.getAsyncContext().dispatch();
        }

        @Override
        protected void error(int code) {
            HttpServletResponse response = (HttpServletResponse)this.getAsyncContext().getResponse();
            AbstractStreamHttpTransport.this.error(response, code);
        }
    }
}

