/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.filter;

import java.util.Arrays;
import java.util.List;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.filter.DataFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFilterMessageListener
implements ServerChannel.MessageListener {
    private final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private final List<DataFilter> _filters;

    public DataFilterMessageListener(DataFilter ... filters) {
        this((BayeuxServer)null, filters);
    }

    public DataFilterMessageListener(BayeuxServer bayeux, DataFilter ... filters) {
        this._filters = Arrays.asList(filters);
    }

    public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
        try {
            Object data;
            Object orig = data = message.getData();
            for (DataFilter filter : this._filters) {
                data = filter.filter(from, channel, data);
                if (data != null) continue;
                return false;
            }
            if (data != orig) {
                message.setData(data);
            }
            return true;
        }
        catch (DataFilter.Abort a) {
            this._logger.debug("", (Throwable)a);
            return false;
        }
    }
}

