/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.lang.reflect.Constructor;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.SecurityPolicy;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.JSONContext;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.DefaultSecurityPolicy;
import org.cometd.server.JettyJSONContextServer;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.AbstractHttpTransport;
import org.cometd.server.transport.AsyncJSONTransport;
import org.cometd.server.transport.JSONPTransport;
import org.cometd.server.transport.JSONTransport;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="The CometD server")
public class BayeuxServerImpl
extends AbstractLifeCycle
implements BayeuxServer {
    private static final boolean[] VALID;
    public static final String ALLOWED_TRANSPORTS_OPTION = "allowedTransports";
    public static final String SWEEP_PERIOD_OPTION = "sweepPeriod";
    public static final String TRANSPORTS_OPTION = "transports";
    private final Logger _logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Integer.toHexString(System.identityHashCode((Object)this))));
    private final SecureRandom _random = new SecureRandom();
    private final List<BayeuxServer.BayeuxServerListener> _listeners = new CopyOnWriteArrayList<BayeuxServer.BayeuxServerListener>();
    private final List<BayeuxServer.Extension> _extensions = new CopyOnWriteArrayList<BayeuxServer.Extension>();
    private final ConcurrentMap<String, ServerSessionImpl> _sessions = new ConcurrentHashMap<String, ServerSessionImpl>();
    private final ConcurrentMap<String, ServerChannelImpl> _channels = new ConcurrentHashMap<String, ServerChannelImpl>();
    private final Map<String, ServerTransport> _transports = new LinkedHashMap<String, ServerTransport>();
    private final List<String> _allowedTransports = new ArrayList<String>();
    private final ThreadLocal<AbstractServerTransport> _currentTransport = new ThreadLocal();
    private final Map<String, Object> _options = new TreeMap<String, Object>();
    private final Scheduler _scheduler = new ScheduledExecutorScheduler("BayeuxServer" + ((Object)((Object)this)).hashCode() + " Scheduler", false);
    private SecurityPolicy _policy = new DefaultSecurityPolicy();
    private JSONContext.Server _jsonContext;
    private boolean _validation;

    protected void doStart() throws Exception {
        super.doStart();
        this.initializeMetaChannels();
        this.initializeJSONContext();
        this.initializeServerTransports();
        this._scheduler.start();
        long defaultSweepPeriod = 997L;
        long sweepPeriodOption = this.getOption(SWEEP_PERIOD_OPTION, defaultSweepPeriod);
        if (sweepPeriodOption < 0L) {
            sweepPeriodOption = defaultSweepPeriod;
        }
        final long sweepPeriod = sweepPeriodOption;
        this._scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                BayeuxServerImpl.this.sweep();
                BayeuxServerImpl.this._scheduler.schedule((Runnable)this, sweepPeriod, TimeUnit.MILLISECONDS);
            }
        }, sweepPeriod, TimeUnit.MILLISECONDS);
        this._validation = this.getOption("validateMessageFields", true);
    }

    protected void doStop() throws Exception {
        super.doStop();
        for (String allowedTransportName : this.getAllowedTransports()) {
            ServerTransport transport = this.getTransport(allowedTransportName);
            if (!(transport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)transport).destroy();
        }
        this._listeners.clear();
        this._extensions.clear();
        this._sessions.clear();
        this._channels.clear();
        this._transports.clear();
        this._allowedTransports.clear();
        this._options.clear();
        this._scheduler.stop();
    }

    protected void initializeMetaChannels() {
        ((ServerChannel)this.createChannelIfAbsent("/meta/handshake", new ConfigurableServerChannel.Initializer[0]).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)new HandshakeHandler());
        ((ServerChannel)this.createChannelIfAbsent("/meta/connect", new ConfigurableServerChannel.Initializer[0]).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)new ConnectHandler());
        ((ServerChannel)this.createChannelIfAbsent("/meta/subscribe", new ConfigurableServerChannel.Initializer[0]).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)new SubscribeHandler());
        ((ServerChannel)this.createChannelIfAbsent("/meta/unsubscribe", new ConfigurableServerChannel.Initializer[0]).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)new UnsubscribeHandler());
        ((ServerChannel)this.createChannelIfAbsent("/meta/disconnect", new ConfigurableServerChannel.Initializer[0]).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)new DisconnectHandler());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeJSONContext() throws Exception {
        Object option = this.getOption("jsonContext");
        if (option == null) {
            this._jsonContext = new JettyJSONContextServer();
        } else if (option instanceof String) {
            Class<?> jsonContextClass = Thread.currentThread().getContextClassLoader().loadClass((String)option);
            if (!JSONContext.Server.class.isAssignableFrom(jsonContextClass)) throw new IllegalArgumentException("Invalid " + JSONContext.Server.class.getName() + " implementation class");
            this._jsonContext = (JSONContext.Server)jsonContextClass.newInstance();
        } else {
            if (!(option instanceof JSONContext.Server)) throw new IllegalArgumentException("Invalid " + JSONContext.Server.class.getName() + " implementation class");
            this._jsonContext = (JSONContext.Server)option;
        }
        this._options.put("jsonContext", this._jsonContext);
    }

    protected void initializeServerTransports() {
        String option;
        if (this._transports.isEmpty()) {
            option = (String)this.getOption(TRANSPORTS_OPTION);
            if (option == null) {
                ServerTransport transport = this.newWebSocketTransport();
                if (transport != null) {
                    this.addTransport(transport);
                }
                this.addTransport(this.newJSONTransport());
                this.addTransport(new JSONPTransport(this));
            } else {
                for (String className : option.split(",")) {
                    ServerTransport transport = this.newServerTransport(className.trim());
                    if (transport == null) continue;
                    this.addTransport(transport);
                }
                if (this._transports.isEmpty()) {
                    throw new IllegalArgumentException("Option 'transports' does not contain a valid list of server transport class names");
                }
            }
        }
        if (this._allowedTransports.isEmpty()) {
            option = (String)this.getOption(ALLOWED_TRANSPORTS_OPTION);
            if (option == null) {
                this._allowedTransports.addAll(this._transports.keySet());
            } else {
                for (String transportName : option.split(",")) {
                    if (!this._transports.containsKey(transportName)) continue;
                    this._allowedTransports.add(transportName);
                }
                if (this._allowedTransports.isEmpty()) {
                    throw new IllegalArgumentException("Option 'allowedTransports' does not contain at least one configured server transport name");
                }
            }
        }
        ArrayList<String> activeTransports = new ArrayList<String>();
        for (String transportName : this._allowedTransports) {
            ServerTransport serverTransport = this.getTransport(transportName);
            if (!(serverTransport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)serverTransport).init();
            activeTransports.add(serverTransport.getName());
        }
        this._logger.debug("Active transports: {}", activeTransports);
    }

    private ServerTransport newWebSocketTransport() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            loader.loadClass("javax.websocket.server.ServerContainer");
            String transportClass = "org.cometd.websocket.server.WebSocketTransport";
            ServerTransport transport = this.newServerTransport(transportClass);
            if (transport == null) {
                this._logger.info("JSR 356 WebSocket classes available, but " + transportClass + " unavailable: JSR 356 WebSocket transport disabled");
            }
            return transport;
        }
        catch (Exception x) {
            return null;
        }
    }

    private ServerTransport newJSONTransport() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            loader.loadClass("javax.servlet.ReadListener");
            return new AsyncJSONTransport(this);
        }
        catch (Exception x) {
            return new JSONTransport(this);
        }
    }

    private ServerTransport newServerTransport(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> klass = loader.loadClass(className);
            Constructor<?> constructor = klass.getConstructor(BayeuxServerImpl.class);
            return (ServerTransport)constructor.newInstance(new Object[]{this});
        }
        catch (Exception x) {
            return null;
        }
    }

    public Scheduler.Task schedule(Runnable task, long delay) {
        return this._scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public ChannelId newChannelId(String id) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(id);
        if (channel != null) {
            return channel.getChannelId();
        }
        return new ChannelId(id);
    }

    public Map<String, Object> getOptions() {
        return this._options;
    }

    @ManagedOperation(value="The value of the given configuration option", impact="INFO")
    public Object getOption(@Name(value="optionName") String qualifiedName) {
        return this._options.get(qualifiedName);
    }

    protected long getOption(String name, long dft) {
        Object val = this.getOption(name);
        if (val == null) {
            return dft;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return Long.parseLong(val.toString());
    }

    protected boolean getOption(String name, boolean dft) {
        Object value = this.getOption(name);
        if (value == null) {
            return dft;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public Set<String> getOptionNames() {
        return this._options.keySet();
    }

    public void setOption(String qualifiedName, Object value) {
        this._options.put(qualifiedName, value);
    }

    public void setOptions(Map<String, Object> options) {
        this._options.putAll(options);
    }

    public long randomLong() {
        return this._random.nextLong();
    }

    public void setCurrentTransport(AbstractServerTransport transport) {
        this._currentTransport.set(transport);
    }

    public ServerTransport getCurrentTransport() {
        return this._currentTransport.get();
    }

    public BayeuxContext getContext() {
        ServerTransport transport = this._currentTransport.get();
        return transport == null ? null : transport.getContext();
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkedReference<ServerChannel> createChannelIfAbsent(String channelName, ConfigurableServerChannel.Initializer ... initializers) {
        boolean initialized = false;
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(channelName);
        if (channel == null) {
            ChannelId channelId = new ChannelId(channelName);
            ServerChannelImpl candidate = new ServerChannelImpl(this, channelId);
            channel = this._channels.putIfAbsent(channelName, candidate);
            if (channel == null) {
                channel = candidate;
                this._logger.debug("Added channel {}", (Object)channel);
                try {
                    for (ConfigurableServerChannel.Initializer initializer : initializers) {
                        this.notifyConfigureChannel(initializer, channel);
                    }
                    for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                        if (!(listener instanceof ConfigurableServerChannel.Initializer)) continue;
                        this.notifyConfigureChannel((ConfigurableServerChannel.Initializer)listener, channel);
                    }
                }
                finally {
                    channel.initialized();
                }
                for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                    if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                    this.notifyChannelAdded((BayeuxServer.ChannelListener)listener, channel);
                }
                initialized = true;
            }
        } else {
            channel.resetSweeperPasses();
            this._channels.putIfAbsent(channelName, channel);
        }
        channel.waitForInitialized();
        return new MarkedReference((Object)channel, initialized);
    }

    private void notifyConfigureChannel(ConfigurableServerChannel.Initializer listener, ServerChannel channel) {
        try {
            listener.configureChannel((ConfigurableServerChannel)channel);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    private void notifyChannelAdded(BayeuxServer.ChannelListener listener, ServerChannel channel) {
        try {
            listener.channelAdded(channel);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public List<ServerSession> getSessions() {
        return Collections.unmodifiableList(new ArrayList(this._sessions.values()));
    }

    public ServerSession getSession(String clientId) {
        if (clientId == null) {
            return null;
        }
        return (ServerSession)this._sessions.get(clientId);
    }

    protected void addServerSession(ServerSessionImpl session, ServerMessage message) {
        this._sessions.put(session.getId(), session);
        for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
            if (!(listener instanceof BayeuxServer.SessionListener)) continue;
            this.notifySessionAdded((BayeuxServer.SessionListener)listener, session, message);
        }
    }

    private void notifySessionAdded(BayeuxServer.SessionListener listener, ServerSession session, ServerMessage message) {
        try {
            listener.sessionAdded(session, message);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public boolean removeServerSession(ServerSession session, boolean timedOut) {
        this._logger.debug("Removing session {}, timed out: {}", (Object)session, (Object)timedOut);
        ServerSessionImpl removed = (ServerSessionImpl)this._sessions.remove(session.getId());
        if (removed != session) {
            return false;
        }
        for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
            if (!(listener instanceof BayeuxServer.SessionListener)) continue;
            this.notifySessionRemoved((BayeuxServer.SessionListener)listener, session, timedOut);
        }
        return removed.removed(timedOut);
    }

    private void notifySessionRemoved(BayeuxServer.SessionListener listener, ServerSession session, boolean timedout) {
        try {
            listener.sessionRemoved(session, timedout);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    protected ServerSessionImpl newServerSession() {
        return new ServerSessionImpl(this);
    }

    public LocalSession newLocalSession(String idHint) {
        return new LocalSessionImpl(this, idHint);
    }

    public ServerMessage.Mutable newMessage() {
        return new ServerMessageImpl();
    }

    public ServerMessage.Mutable newMessage(ServerMessage tocopy) {
        ServerMessage.Mutable mutable = this.newMessage();
        for (String key : tocopy.keySet()) {
            mutable.put((Object)key, tocopy.get((Object)key));
        }
        return mutable;
    }

    public void setSecurityPolicy(SecurityPolicy securityPolicy) {
        this._policy = securityPolicy;
    }

    public void addExtension(BayeuxServer.Extension extension) {
        this._extensions.add(extension);
    }

    public void removeExtension(BayeuxServer.Extension extension) {
        this._extensions.remove(extension);
    }

    public List<BayeuxServer.Extension> getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    public void addListener(BayeuxServer.BayeuxServerListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this._listeners.add(listener);
    }

    public ServerChannel getChannel(String channelId) {
        return this.getServerChannel(channelId);
    }

    private ServerChannelImpl getServerChannel(String channelId) {
        ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(channelId);
        if (channel != null) {
            channel.waitForInitialized();
        }
        return channel;
    }

    public List<ServerChannel> getChannels() {
        ArrayList<ServerChannel> result = new ArrayList<ServerChannel>();
        for (ServerChannelImpl channel : this._channels.values()) {
            channel.waitForInitialized();
            result.add(channel);
        }
        return result;
    }

    public void removeListener(BayeuxServer.BayeuxServerListener listener) {
        this._listeners.remove(listener);
    }

    public ServerMessage.Mutable handle(ServerSessionImpl session, ServerMessage.Mutable message) {
        this._logger.debug(">  {} {}", (Object)message, (Object)session);
        if (this._validation) {
            this.validateMessage(message);
        }
        ServerMessage.Mutable reply = this.createReply(message);
        if (!this.extendRecv(session, message) || session != null && !session.extendRecv(message)) {
            this.error(reply, "404::message deleted");
        } else {
            this._logger.debug(">> {}", (Object)message);
            String channelName = message.getChannel();
            if (channelName == null) {
                this.error(reply, "400::channel missing");
            } else {
                String denyReason;
                ServerChannelImpl channel = this.getServerChannel(channelName);
                if (channel == null) {
                    if (session == null) {
                        this.unknownSession(reply);
                    } else {
                        Authorizer.Result creationResult = this.isCreationAuthorized(session, (ServerMessage)message, channelName);
                        if (creationResult instanceof Authorizer.Result.Denied) {
                            denyReason = ((Authorizer.Result.Denied)creationResult).getReason();
                            this.error(reply, "403:" + denyReason + ":create denied");
                        } else {
                            channel = (ServerChannelImpl)this.createChannelIfAbsent(channelName, new ConfigurableServerChannel.Initializer[0]).getReference();
                        }
                    }
                }
                if (channel != null) {
                    if (channel.isMeta()) {
                        if (session == null && !"/meta/handshake".equals(channelName)) {
                            this.unknownSession(reply);
                        } else {
                            this.doPublish(session, channel, message);
                        }
                    } else if (session == null) {
                        this.unknownSession(reply);
                    } else {
                        Authorizer.Result publishResult = this.isPublishAuthorized(channel, session, (ServerMessage)message);
                        if (publishResult instanceof Authorizer.Result.Denied) {
                            denyReason = ((Authorizer.Result.Denied)publishResult).getReason();
                            this.error(reply, "403:" + denyReason + ":publish denied");
                        } else {
                            channel.publish((Session)session, message);
                            reply.setSuccessful(true);
                        }
                    }
                }
            }
        }
        this._logger.debug("<< {}", (Object)reply);
        return reply;
    }

    protected void validateMessage(ServerMessage.Mutable message) {
        String channel = message.getChannel();
        if (!this.validate(channel)) {
            throw new IllegalArgumentException("Invalid message channel: " + channel);
        }
        String id = message.getId();
        if (id != null && !this.validate(id)) {
            throw new IllegalArgumentException("Invalid message id: " + id);
        }
    }

    private boolean validate(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c <= '\u007f' && VALID[c]) continue;
            return false;
        }
        return true;
    }

    private Authorizer.Result isPublishAuthorized(ServerChannel channel, ServerSession session, ServerMessage message) {
        if (this._policy != null && !this._policy.canPublish((BayeuxServer)this, session, channel, message)) {
            this._logger.warn("{} denied Publish@{} by {}", new Object[]{session, channel.getId(), this._policy});
            return Authorizer.Result.deny((String)"denied_by_security_policy");
        }
        return this.isOperationAuthorized(Authorizer.Operation.PUBLISH, session, message, channel.getChannelId());
    }

    private Authorizer.Result isSubscribeAuthorized(ServerChannel channel, ServerSession session, ServerMessage message) {
        if (this._policy != null && !this._policy.canSubscribe((BayeuxServer)this, session, channel, message)) {
            this._logger.warn("{} denied Subscribe@{} by {}", new Object[]{session, channel, this._policy});
            return Authorizer.Result.deny((String)"denied_by_security_policy");
        }
        return this.isOperationAuthorized(Authorizer.Operation.SUBSCRIBE, session, message, channel.getChannelId());
    }

    private Authorizer.Result isCreationAuthorized(ServerSession session, ServerMessage message, String channel) {
        if (this._policy != null && !this._policy.canCreate((BayeuxServer)this, session, channel, message)) {
            this._logger.warn("{} denied Create@{} by {}", new Object[]{session, message.getChannel(), this._policy});
            return Authorizer.Result.deny((String)"denied_by_security_policy");
        }
        return this.isOperationAuthorized(Authorizer.Operation.CREATE, session, message, new ChannelId(channel));
    }

    private Authorizer.Result isOperationAuthorized(Authorizer.Operation operation, ServerSession session, ServerMessage message, ChannelId channelId) {
        ArrayList<ServerChannelImpl> channels = new ArrayList<ServerChannelImpl>();
        for (String wildName : channelId.getWilds()) {
            ServerChannelImpl channel = (ServerChannelImpl)this._channels.get(wildName);
            if (channel == null) continue;
            channels.add(channel);
        }
        ServerChannelImpl candidate = (ServerChannelImpl)this._channels.get(channelId.toString());
        if (candidate != null) {
            channels.add(candidate);
        }
        boolean called = false;
        Authorizer.Result result = Authorizer.Result.ignore();
        block1: for (ServerChannelImpl channel : channels) {
            List<Authorizer> authorizers = channel.authorizers();
            if (authorizers.isEmpty()) continue;
            for (Authorizer authorizer : authorizers) {
                called = true;
                Authorizer.Result authorization = authorizer.authorize(operation, channelId, session, message);
                this._logger.debug("Authorizer {} on channel {} {} {} for channel {}", new Object[]{authorizer, channel, authorization, operation, channelId});
                if (authorization instanceof Authorizer.Result.Denied) {
                    result = authorization;
                    continue block1;
                }
                if (!(authorization instanceof Authorizer.Result.Granted)) continue;
                result = authorization;
            }
        }
        if (!called) {
            result = Authorizer.Result.grant();
            this._logger.debug("No authorizers, {} for channel {} {}", new Object[]{operation, channelId, result});
        } else if (result instanceof Authorizer.Result.Ignored) {
            result = Authorizer.Result.deny((String)"denied_by_not_granting");
            this._logger.debug("No authorizer granted {} for channel {}, authorization {}", new Object[]{operation, channelId, result});
        } else if (result instanceof Authorizer.Result.Granted) {
            this._logger.debug("No authorizer denied {} for channel {}, authorization {}", new Object[]{operation, channelId, result});
        }
        assert (!(result instanceof Authorizer.Result.Ignored));
        return result;
    }

    protected void doPublish(ServerSessionImpl from, ServerChannelImpl to, ServerMessage.Mutable mutable) {
        Set<ServerSession> subscribers;
        if (to.isLazy()) {
            mutable.setLazy(true);
        }
        List wildChannelNames = to.getChannelId().getWilds();
        ServerChannelImpl[] wildChannels = new ServerChannelImpl[wildChannelNames.size()];
        int i = wildChannelNames.size();
        while (i-- > 0) {
            wildChannels[i] = (ServerChannelImpl)this._channels.get(wildChannelNames.get(i));
        }
        for (ServerChannelImpl wildChannel : wildChannels) {
            List<ConfigurableServerChannel.ServerChannelListener> listeners;
            if (wildChannel == null) continue;
            if (wildChannel.isLazy()) {
                mutable.setLazy(true);
            }
            if ((listeners = wildChannel.listeners()).isEmpty()) continue;
            for (ConfigurableServerChannel.ServerChannelListener listener : listeners) {
                if (!(listener instanceof ServerChannel.MessageListener) || this.notifyOnMessage((ServerChannel.MessageListener)listener, from, to, mutable)) continue;
                return;
            }
        }
        List<ConfigurableServerChannel.ServerChannelListener> listeners = to.listeners();
        if (!listeners.isEmpty()) {
            for (ConfigurableServerChannel.ServerChannelListener listener : listeners) {
                if (!(listener instanceof ServerChannel.MessageListener) || this.notifyOnMessage((ServerChannel.MessageListener)listener, from, to, mutable)) continue;
                return;
            }
        }
        this.freeze(mutable);
        HashSet<String> wildSubscribers = null;
        if (ChannelId.isBroadcast((String)mutable.getChannel())) {
            for (ServerChannelImpl wildChannel : wildChannels) {
                Set<ServerSession> subscribers2;
                if (wildChannel == null || (subscribers2 = wildChannel.subscribers()).isEmpty()) continue;
                for (ServerSession session : subscribers2) {
                    if (wildSubscribers == null) {
                        wildSubscribers = new HashSet<String>();
                    }
                    if (!wildSubscribers.add(session.getId())) continue;
                    ((ServerSessionImpl)session).doDeliver(from, mutable);
                }
            }
        }
        if (!(subscribers = to.subscribers()).isEmpty()) {
            for (ServerSession session : subscribers) {
                if (wildSubscribers != null && wildSubscribers.contains(session.getId())) continue;
                ((ServerSessionImpl)session).doDeliver(from, mutable);
            }
        }
        if (to.isMeta() && !(listeners = to.listeners()).isEmpty()) {
            for (ConfigurableServerChannel.ServerChannelListener listener : listeners) {
                if (!(listener instanceof HandlerListener)) continue;
                ((HandlerListener)listener).onMessage(from, mutable);
            }
        }
    }

    public void freeze(ServerMessage.Mutable mutable) {
        ServerMessageImpl message = (ServerMessageImpl)mutable;
        if (message.isFrozen()) {
            return;
        }
        String json = this._jsonContext.generate((Message.Mutable)message);
        message.freeze(json);
    }

    private boolean notifyOnMessage(ServerChannel.MessageListener listener, ServerSession from, ServerChannel to, ServerMessage.Mutable mutable) {
        try {
            return listener.onMessage(from, to, mutable);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
            return true;
        }
    }

    public ServerMessage.Mutable extendReply(ServerSessionImpl from, ServerSessionImpl to, ServerMessage.Mutable reply) {
        if (!this.extendSend(from, to, reply)) {
            return null;
        }
        if (to != null) {
            if (reply.isMeta()) {
                if (!to.extendSendMeta(reply)) {
                    return null;
                }
            } else {
                ServerMessage newReply = to.extendSendMessage((ServerMessage)reply);
                if (newReply == null) {
                    reply = null;
                } else if (newReply != reply) {
                    reply = newReply instanceof ServerMessage.Mutable ? (ServerMessage.Mutable)newReply : this.newMessage(newReply);
                }
            }
        }
        return reply;
    }

    protected boolean extendRecv(ServerSession from, ServerMessage.Mutable message) {
        if (message.isMeta()) {
            for (BayeuxServer.Extension extension : this._extensions) {
                if (this.notifyRcvMeta(extension, from, message)) continue;
                return false;
            }
        } else {
            for (BayeuxServer.Extension extension : this._extensions) {
                if (this.notifyRcv(extension, from, message)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean notifyRcvMeta(BayeuxServer.Extension extension, ServerSession from, ServerMessage.Mutable message) {
        try {
            return extension.rcvMeta(from, message);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    private boolean notifyRcv(BayeuxServer.Extension extension, ServerSession from, ServerMessage.Mutable message) {
        try {
            return extension.rcv(from, message);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    protected boolean extendSend(ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        if (message.isMeta()) {
            ListIterator<BayeuxServer.Extension> i = this._extensions.listIterator();
            while (i.hasNext()) {
                i.next();
            }
            while (i.hasPrevious()) {
                BayeuxServer.Extension extension = i.previous();
                if (this.notifySendMeta(extension, to, message)) continue;
                this._logger.debug("Extension {} interrupted message processing for {}", (Object)extension, (Object)message);
                return false;
            }
        } else {
            ListIterator<BayeuxServer.Extension> i = this._extensions.listIterator();
            while (i.hasNext()) {
                i.next();
            }
            while (i.hasPrevious()) {
                BayeuxServer.Extension extension = i.previous();
                if (this.notifySend(extension, from, to, message)) continue;
                this._logger.debug("Extension {} interrupted message processing for {}", (Object)extension, (Object)message);
                return false;
            }
        }
        this._logger.debug("<  {}", (Object)message);
        return true;
    }

    private boolean notifySendMeta(BayeuxServer.Extension extension, ServerSession to, ServerMessage.Mutable message) {
        try {
            return extension.sendMeta(to, message);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    private boolean notifySend(BayeuxServer.Extension extension, ServerSession from, ServerSession to, ServerMessage.Mutable message) {
        try {
            return extension.send(from, to, message);
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    protected boolean removeServerChannel(ServerChannelImpl channel) {
        if (this._channels.remove(channel.getId(), channel)) {
            this._logger.debug("Removed channel {}", (Object)channel);
            for (BayeuxServer.BayeuxServerListener listener : this._listeners) {
                if (!(listener instanceof BayeuxServer.ChannelListener)) continue;
                this.notifyChannelRemoved((BayeuxServer.ChannelListener)listener, channel);
            }
            return true;
        }
        return false;
    }

    private void notifyChannelRemoved(BayeuxServer.ChannelListener listener, ServerChannelImpl channel) {
        try {
            listener.channelRemoved(channel.getId());
        }
        catch (Throwable x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    protected List<BayeuxServer.BayeuxServerListener> getListeners() {
        return Collections.unmodifiableList(this._listeners);
    }

    public Set<String> getKnownTransportNames() {
        return this._transports.keySet();
    }

    public ServerTransport getTransport(String transport) {
        return this._transports.get(transport);
    }

    public ServerTransport addTransport(ServerTransport transport) {
        ServerTransport result = this._transports.put(transport.getName(), transport);
        this._logger.debug("Added transport {} from {}", (Object)transport.getName(), transport.getClass());
        return result;
    }

    public void setTransports(ServerTransport ... transports) {
        this.setTransports(Arrays.asList(transports));
    }

    public void setTransports(List<ServerTransport> transports) {
        this._transports.clear();
        for (ServerTransport transport : transports) {
            this.addTransport(transport);
        }
    }

    public List<ServerTransport> getTransports() {
        return new ArrayList<ServerTransport>(this._transports.values());
    }

    protected AbstractHttpTransport findHttpTransport(HttpServletRequest request) {
        for (int i = 0; i < this._allowedTransports.size(); ++i) {
            AbstractHttpTransport transport;
            String transportName = this._allowedTransports.get(i);
            ServerTransport serverTransport = this.getTransport(transportName);
            if (!(serverTransport instanceof AbstractHttpTransport) || !(transport = (AbstractHttpTransport)serverTransport).accept(request)) continue;
            return transport;
        }
        return null;
    }

    @ManagedAttribute(value="The transports allowed by this server", readonly=true)
    public List<String> getAllowedTransports() {
        return Collections.unmodifiableList(this._allowedTransports);
    }

    public void setAllowedTransports(String ... allowed) {
        this.setAllowedTransports(Arrays.asList(allowed));
    }

    public void setAllowedTransports(List<String> allowed) {
        this._logger.debug("setAllowedTransport {} of {}", allowed, this._transports);
        this._allowedTransports.clear();
        for (String transport : allowed) {
            if (!this._transports.containsKey(transport)) continue;
            this._allowedTransports.add(transport);
        }
        this._logger.debug("allowedTransports {}", this._allowedTransports);
    }

    protected void unknownSession(ServerMessage.Mutable reply) {
        this.error(reply, "402::Unknown client");
        if ("/meta/handshake".equals(reply.getChannel()) || "/meta/connect".equals(reply.getChannel())) {
            Map advice = reply.getAdvice(true);
            advice.put("reconnect", "handshake");
            advice.put("interval", 0L);
        }
    }

    protected void error(ServerMessage.Mutable reply, String error) {
        reply.put((Object)"error", (Object)error);
        reply.setSuccessful(false);
    }

    protected ServerMessage.Mutable createReply(ServerMessage.Mutable message) {
        ServerMessage.Mutable reply = this.newMessage();
        message.setAssociated(reply);
        reply.setAssociated(message);
        reply.setChannel(message.getChannel());
        String id = message.getId();
        if (id != null) {
            reply.setId(id);
        }
        return reply;
    }

    @ManagedOperation(value="Sweeps channels and sessions of this BayeuxServer", impact="ACTION")
    public void sweep() {
        for (ServerChannelImpl channel : this._channels.values()) {
            channel.sweep();
        }
        for (ServerTransport transport : this._transports.values()) {
            if (!(transport instanceof AbstractServerTransport)) continue;
            ((AbstractServerTransport)transport).sweep();
        }
        long now = System.currentTimeMillis();
        for (ServerSessionImpl session : this._sessions.values()) {
            session.sweep(now);
        }
    }

    @ManagedOperation(value="Dumps the BayeuxServer state", impact="INFO")
    public String dump() {
        StringBuilder b = new StringBuilder();
        ArrayList<Object> children = new ArrayList<Object>();
        if (this._policy != null) {
            children.add(this._policy);
        }
        for (ServerChannelImpl channel : this._channels.values()) {
            if (channel.getChannelId().depth() != 1) continue;
            children.add(channel);
        }
        int leaves = children.size();
        int i = 0;
        for (Object e : children) {
            b.append(" +-");
            if (e instanceof ServerChannelImpl) {
                ((ServerChannelImpl)e).dump(b, ++i == leaves ? "   " : " | ");
                continue;
            }
            b.append(e.toString()).append("\n");
        }
        return b.toString();
    }

    static {
        int i;
        VALID = new boolean[256];
        BayeuxServerImpl.VALID[32] = true;
        BayeuxServerImpl.VALID[33] = true;
        BayeuxServerImpl.VALID[35] = true;
        BayeuxServerImpl.VALID[36] = true;
        BayeuxServerImpl.VALID[40] = true;
        BayeuxServerImpl.VALID[41] = true;
        BayeuxServerImpl.VALID[42] = true;
        BayeuxServerImpl.VALID[43] = true;
        BayeuxServerImpl.VALID[45] = true;
        BayeuxServerImpl.VALID[46] = true;
        BayeuxServerImpl.VALID[47] = true;
        BayeuxServerImpl.VALID[64] = true;
        BayeuxServerImpl.VALID[95] = true;
        BayeuxServerImpl.VALID[126] = true;
        for (i = 48; i <= 57; ++i) {
            BayeuxServerImpl.VALID[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            BayeuxServerImpl.VALID[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            BayeuxServerImpl.VALID[i] = true;
        }
    }

    private class DisconnectHandler
    extends HandlerListener {
        private DisconnectHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = message.getAssociated();
            if (this.isSessionUnknown(session)) {
                BayeuxServerImpl.this.unknownSession(reply);
                return;
            }
            reply.setSuccessful(true);
            BayeuxServerImpl.this.removeServerSession(session, false);
            session.flush();
        }
    }

    private class UnsubscribeHandler
    extends HandlerListener {
        private UnsubscribeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl from, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = message.getAssociated();
            if (this.isSessionUnknown(from)) {
                BayeuxServerImpl.this.unknownSession(reply);
                return;
            }
            Object subscriptionField = message.get((Object)"subscription");
            if (subscriptionField == null) {
                BayeuxServerImpl.this.error(reply, "403::subscription_missing");
                return;
            }
            List<String> subscriptions = this.toChannelList(subscriptionField);
            if (subscriptions == null) {
                BayeuxServerImpl.this.error(reply, "403::subscription_invalid");
                return;
            }
            if (BayeuxServerImpl.this._validation) {
                for (int i = 0; i < subscriptions.size(); ++i) {
                    String subscription = subscriptions.get(i);
                    if (BayeuxServerImpl.this.validate(subscription)) continue;
                    throw new IllegalArgumentException("Invalid message subscription: " + subscription);
                }
            }
            reply.put((Object)"subscription", subscriptionField);
            for (String subscription : subscriptions) {
                ServerChannelImpl channel = BayeuxServerImpl.this.getServerChannel(subscription);
                if (channel == null) {
                    BayeuxServerImpl.this.error(reply, "400::channel_missing");
                    break;
                }
                if (channel.unsubscribe(from, (ServerMessage)message)) {
                    reply.setSuccessful(true);
                    continue;
                }
                BayeuxServerImpl.this.error(reply, "403::unsubscribe_failed");
                break;
            }
        }
    }

    private class SubscribeHandler
    extends HandlerListener {
        private SubscribeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl from, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = message.getAssociated();
            if (this.isSessionUnknown(from)) {
                BayeuxServerImpl.this.unknownSession(reply);
                return;
            }
            Object subscriptionField = message.get((Object)"subscription");
            if (subscriptionField == null) {
                BayeuxServerImpl.this.error(reply, "403::subscription_missing");
                return;
            }
            List<String> subscriptions = this.toChannelList(subscriptionField);
            if (subscriptions == null) {
                BayeuxServerImpl.this.error(reply, "403::subscription_invalid");
                return;
            }
            if (BayeuxServerImpl.this._validation) {
                for (int i = 0; i < subscriptions.size(); ++i) {
                    String subscription = subscriptions.get(i);
                    if (BayeuxServerImpl.this.validate(subscription)) continue;
                    throw new IllegalArgumentException("Invalid message subscription: " + subscription);
                }
            }
            reply.put((Object)"subscription", subscriptionField);
            for (String subscription : subscriptions) {
                ServerChannelImpl channel = BayeuxServerImpl.this.getServerChannel(subscription);
                if (channel == null) {
                    Authorizer.Result creationResult = BayeuxServerImpl.this.isCreationAuthorized(from, (ServerMessage)message, subscription);
                    if (creationResult instanceof Authorizer.Result.Denied) {
                        String denyReason = ((Authorizer.Result.Denied)creationResult).getReason();
                        BayeuxServerImpl.this.error(reply, "403:" + denyReason + ":create_denied");
                        break;
                    }
                    channel = (ServerChannelImpl)BayeuxServerImpl.this.createChannelIfAbsent(subscription, new ConfigurableServerChannel.Initializer[0]).getReference();
                }
                if (channel == null) continue;
                Authorizer.Result subscribeResult = BayeuxServerImpl.this.isSubscribeAuthorized(channel, from, (ServerMessage)message);
                if (subscribeResult instanceof Authorizer.Result.Denied) {
                    String denyReason = ((Authorizer.Result.Denied)subscribeResult).getReason();
                    BayeuxServerImpl.this.error(reply, "403:" + denyReason + ":subscribe_denied");
                    break;
                }
                if (!this.isSessionUnknown(from)) {
                    if (channel.subscribe(from, (ServerMessage)message)) {
                        reply.setSuccessful(true);
                        continue;
                    }
                    BayeuxServerImpl.this.error(reply, "403::subscribe_failed");
                    break;
                }
                BayeuxServerImpl.this.unknownSession(reply);
                break;
            }
        }
    }

    private class ConnectHandler
    extends HandlerListener {
        private ConnectHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            ServerMessage.Mutable reply = message.getAssociated();
            if (this.isSessionUnknown(session)) {
                BayeuxServerImpl.this.unknownSession(reply);
                return;
            }
            session.connected();
            Map adviceIn = message.getAdvice();
            if (adviceIn != null) {
                Number timeout = (Number)adviceIn.get("timeout");
                session.updateTransientTimeout(timeout == null ? -1L : timeout.longValue());
                Number interval = (Number)adviceIn.get("interval");
                session.updateTransientInterval(interval == null ? -1L : interval.longValue());
                session.reAdvise();
            } else {
                session.updateTransientTimeout(-1L);
                session.updateTransientInterval(-1L);
            }
            Map<String, Object> adviceOut = session.takeAdvice(BayeuxServerImpl.this.getCurrentTransport());
            if (adviceOut != null) {
                reply.put((Object)"advice", adviceOut);
            }
            reply.setSuccessful(true);
        }
    }

    private class HandshakeHandler
    extends HandlerListener {
        private HandshakeHandler() {
        }

        @Override
        public void onMessage(ServerSessionImpl session, ServerMessage.Mutable message) {
            BayeuxContext context;
            if (session == null) {
                session = BayeuxServerImpl.this.newServerSession();
            }
            if ((context = BayeuxServerImpl.this.getContext()) != null) {
                session.setUserAgent(context.getHeader("User-Agent"));
            }
            ServerMessage.Mutable reply = message.getAssociated();
            if (BayeuxServerImpl.this._policy != null && !BayeuxServerImpl.this._policy.canHandshake((BayeuxServer)BayeuxServerImpl.this, (ServerSession)session, (ServerMessage)message)) {
                BayeuxServerImpl.this.error(reply, "403::Handshake denied");
                Map advice = reply.getAdvice(true);
                if (!advice.containsKey("reconnect")) {
                    advice.put("reconnect", "none");
                }
                return;
            }
            session.handshake();
            BayeuxServerImpl.this.addServerSession(session, (ServerMessage)message);
            reply.setSuccessful(true);
            reply.put((Object)"clientId", (Object)session.getId());
            reply.put((Object)"version", (Object)"1.0");
            reply.put((Object)"minimumVersion", (Object)"1.0");
            reply.put((Object)"supportedConnectionTypes", BayeuxServerImpl.this.getAllowedTransports());
        }
    }

    abstract class HandlerListener
    implements ConfigurableServerChannel.ServerChannelListener {
        HandlerListener() {
        }

        protected boolean isSessionUnknown(ServerSession session) {
            return session == null || BayeuxServerImpl.this.getSession(session.getId()) == null;
        }

        protected List<String> toChannelList(Object channels) {
            if (channels instanceof String) {
                return Collections.singletonList((String)channels);
            }
            if (channels instanceof Object[]) {
                Object[] array = (Object[])channels;
                ArrayList<String> channelList = new ArrayList<String>();
                for (Object o : array) {
                    channelList.add(String.valueOf(o));
                }
                return channelList;
            }
            if (channels instanceof List) {
                List list = (List)channels;
                ArrayList<String> channelList = new ArrayList<String>();
                for (Object o : list) {
                    channelList.add(String.valueOf(o));
                }
                return channelList;
            }
            return null;
        }

        public abstract void onMessage(ServerSessionImpl var1, ServerMessage.Mutable var2);
    }
}

