/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class WhitespaceTokenizerFactory
extends AbstractTokenizerFactory {
    static final String MAX_TOKEN_LENGTH = "max_token_length";
    private Integer maxTokenLength;

    WhitespaceTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, settings);
        this.maxTokenLength = settings.getAsInt(MAX_TOKEN_LENGTH, Integer.valueOf(255));
    }

    public Tokenizer create() {
        return new WhitespaceTokenizer(TokenStream.DEFAULT_TOKEN_ATTRIBUTE_FACTORY, this.maxTokenLength.intValue());
    }
}

