/*
 * Decompiled with CFR 0.152.
 */
package org.codejive.properties;

import java.util.List;
import java.util.function.Predicate;
import org.codejive.properties.PropertiesParser;

public class Cursor {
    private final List<PropertiesParser.Token> tokens;
    private int index;

    public static Cursor index(List<PropertiesParser.Token> tokens, int index) {
        return new Cursor(tokens, index);
    }

    public static Cursor first(List<PropertiesParser.Token> tokens) {
        return new Cursor(tokens, tokens.isEmpty() ? -1 : 0);
    }

    public static Cursor last(List<PropertiesParser.Token> tokens) {
        return new Cursor(tokens, tokens.size() - 1);
    }

    private Cursor(List<PropertiesParser.Token> tokens, int index) {
        this.tokens = tokens;
        this.index = index;
    }

    public boolean atStart() {
        return this.index < 0;
    }

    public int position() {
        return this.index;
    }

    public boolean hasToken() {
        return this.index >= 0 && this.index < this.tokens.size();
    }

    public PropertiesParser.Token token() {
        return this.tokens.get(this.index);
    }

    public String raw() {
        return this.token().getRaw();
    }

    public String text() {
        return this.token().getText();
    }

    public PropertiesParser.Type type() {
        return this.token().getType();
    }

    public boolean isType(PropertiesParser.Type ... types) {
        if (this.index >= 0 && this.index < this.tokens.size()) {
            for (PropertiesParser.Type t : types) {
                if (t != this.tokens.get(this.index).getType()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isWhitespace() {
        return this.isType(PropertiesParser.Type.WHITESPACE) && !this.token().isEol();
    }

    public boolean isEol() {
        return this.isType(PropertiesParser.Type.WHITESPACE) && this.token().isEol();
    }

    public Cursor prev() {
        return this.skip(-1);
    }

    public Cursor next() {
        return this.skip(1);
    }

    public Cursor skip(int steps) {
        this.index += steps;
        if (this.index < -1) {
            this.index = -1;
        } else if (this.index > this.tokens.size()) {
            this.index = this.tokens.size();
        }
        return this;
    }

    public boolean nextIf(PropertiesParser.Type type) {
        return this.nextIf((PropertiesParser.Token t) -> t.getType() == type);
    }

    public boolean nextIf(Predicate<PropertiesParser.Token> accept) {
        if (this.hasToken() && accept.test(this.token())) {
            this.next();
            return true;
        }
        return false;
    }

    public Cursor nextWhile(Predicate<PropertiesParser.Token> accept) {
        while (this.nextIf(accept)) {
        }
        return this;
    }

    public int nextCount(Predicate<PropertiesParser.Token> accept) {
        int cnt = 0;
        while (this.nextIf(accept)) {
            ++cnt;
        }
        return cnt;
    }

    public boolean prevIf(PropertiesParser.Type type) {
        return this.prevIf((PropertiesParser.Token t) -> t.getType() == type);
    }

    public boolean prevIf(Predicate<PropertiesParser.Token> accept) {
        if (this.hasToken() && accept.test(this.token())) {
            this.prev();
            return true;
        }
        return false;
    }

    public Cursor prevWhile(Predicate<PropertiesParser.Token> accept) {
        while (this.prevIf(accept)) {
        }
        return this;
    }

    public int prevCount(Predicate<PropertiesParser.Token> accept) {
        int cnt = 0;
        while (this.prevIf(accept)) {
            ++cnt;
        }
        return cnt;
    }

    public Cursor add(PropertiesParser.Token token) {
        this.addToken(this.index++, token);
        return this;
    }

    public Cursor addEol() {
        return this.add(PropertiesParser.Token.EOL);
    }

    private void addToken(int index, PropertiesParser.Token token) {
        if (this.hasToken()) {
            this.tokens.add(index, token);
        } else {
            this.tokens.add(token);
        }
    }

    public Cursor replace(PropertiesParser.Token token) {
        this.tokens.set(this.index, token);
        return this;
    }

    public void remove() {
        this.tokens.remove(this.index);
    }

    public Cursor copy() {
        return Cursor.index(this.tokens, this.index);
    }

    public String toString() {
        return (this.hasToken() ? this.token() + " " : "") + "@" + this.position();
    }
}

