/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.query.BatchQuery;
import org.codejargon.fluentjdbc.api.query.Mapper;
import org.codejargon.fluentjdbc.api.query.SqlErrorHandler;
import org.codejargon.fluentjdbc.api.query.UpdateResult;
import org.codejargon.fluentjdbc.api.query.UpdateResultGenKeys;
import org.codejargon.fluentjdbc.internal.query.FetchGenKey;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.UpdateResultGenKeysInternal;
import org.codejargon.fluentjdbc.internal.query.UpdateResultInternal;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSqlFactory;
import org.codejargon.fluentjdbc.internal.query.namedparameter.SqlAndParamsForNamed;
import org.codejargon.fluentjdbc.internal.support.Ints;
import org.codejargon.fluentjdbc.internal.support.Iterables;
import org.codejargon.fluentjdbc.internal.support.Preconditions;
import org.codejargon.fluentjdbc.internal.support.Sneaky;

class BatchQueryInternal
implements BatchQuery {
    private static final String namedSet = "Named parameters are already set.";
    private static final String positionalSet = "Positional parameters are already set.";
    private final String sql;
    private final QueryInternal query;
    private Optional<Iterator<List<?>>> params = Optional.empty();
    private Optional<Iterator<Map<String, ?>>> namedParams = Optional.empty();
    private Optional<Integer> batchSize;
    private Supplier<SqlErrorHandler> sqlErrorHandler;

    public BatchQueryInternal(String string, QueryInternal queryInternal) {
        this.sql = string;
        this.query = queryInternal;
        this.batchSize = queryInternal.config.defaultBatchSize;
        this.sqlErrorHandler = queryInternal.config.defaultSqlErrorHandler;
    }

    @Override
    public BatchQuery params(Iterator<List<?>> iterator) {
        Preconditions.checkNotNull(iterator, "params");
        Preconditions.checkArgument(!this.params.isPresent(), positionalSet);
        Preconditions.checkArgument(!this.namedParams.isPresent(), namedSet);
        this.params = Optional.of(iterator);
        return this;
    }

    @Override
    public BatchQuery params(Iterable<List<?>> iterable) {
        return this.params(iterable.iterator());
    }

    @Override
    public BatchQuery params(Stream<List<?>> stream) {
        return this.params(stream.iterator());
    }

    @Override
    public BatchQuery namedParams(Iterator<Map<String, ?>> iterator) {
        Preconditions.checkNotNull(iterator, "namedParams");
        Preconditions.checkArgument(!this.namedParams.isPresent(), namedSet);
        Preconditions.checkArgument(!this.params.isPresent(), positionalSet);
        this.namedParams = Optional.of(iterator);
        return this;
    }

    @Override
    public BatchQuery namedParams(Iterable<Map<String, ?>> iterable) {
        return this.namedParams(iterable.iterator());
    }

    @Override
    public BatchQuery namedParams(Stream<Map<String, ?>> stream) {
        return this.namedParams(stream.iterator());
    }

    @Override
    public BatchQuery batchSize(Integer n) {
        Preconditions.checkNotNull(n, "batch size");
        Preconditions.checkArgument(n > 0, "batch size must be greater than 0");
        this.batchSize = Optional.of(n);
        return this;
    }

    @Override
    public BatchQuery errorHandler(SqlErrorHandler sqlErrorHandler) {
        this.sqlErrorHandler = () -> sqlErrorHandler;
        return this;
    }

    @Override
    public List<UpdateResult> run() {
        return this.run(FetchGenKey.no());
    }

    @Override
    public <T> List<UpdateResultGenKeys<T>> runFetchGenKeys(Mapper<T> mapper) {
        return Collections.unmodifiableList(this.run(FetchGenKey.yes(mapper)).stream().map(updateResult -> (UpdateResultGenKeys)updateResult).collect(Collectors.toList()));
    }

    private <T> List<UpdateResult> run(FetchGenKey<T> fetchGenKey) {
        Preconditions.checkArgument(this.params.isPresent() || this.namedParams.isPresent(), "Parameters must be set to run a batch query");
        return this.query.query(connection -> this.params.isPresent() ? this.positional(connection, fetchGenKey) : this.named(connection, fetchGenKey), Optional.of(this.sql), this.sqlErrorHandler.get());
    }

    private <T> List<UpdateResult> positional(Connection connection, FetchGenKey<T> fetchGenKey) throws SQLException {
        try (PreparedStatement preparedStatement = this.query.preparedStatementFactory.createBatch(connection, fetchGenKey.fetch(), this.sql);){
            BatchExecution<T> batchExecution = new BatchExecution<T>(preparedStatement, fetchGenKey);
            Iterables.stream(this.params.get()).forEachOrdered(Sneaky.consumer(batchExecution::add));
            List list = ((BatchExecution)batchExecution).results();
            return list;
        }
    }

    private <T> List<UpdateResult> named(Connection connection, FetchGenKey<T> fetchGenKey) throws SQLException {
        Iterator<Map<String, ?>> iterator = this.namedParams.get();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        Map<String, ?> map = iterator.next();
        this.noCollectionsAllowed(map);
        NamedTransformedSql namedTransformedSql = this.query.config.namedTransformedSqlFactory.create(this.sql, map);
        try (PreparedStatement preparedStatement = this.query.preparedStatementFactory.createBatch(connection, fetchGenKey.fetch(), namedTransformedSql.sql());){
            BatchExecution<T> batchExecution = new BatchExecution<T>(preparedStatement, fetchGenKey);
            batchExecution.add(SqlAndParamsForNamed.params(namedTransformedSql.parsedSql(), map));
            while (iterator.hasNext()) {
                map = iterator.next();
                this.noCollectionsAllowed(map);
                batchExecution.add(SqlAndParamsForNamed.params(namedTransformedSql.parsedSql(), map));
            }
            List list = ((BatchExecution)batchExecution).results();
            return list;
        }
    }

    private void noCollectionsAllowed(Map<String, ?> map) {
        if (NamedTransformedSqlFactory.hasCollection(map)) {
            throw new FluentJdbcException("Batch updates should not contain collections as parameters");
        }
    }

    private class BatchExecution<T> {
        private final PreparedStatement ps;
        private final FetchGenKey<T> fetchGen;
        private final List<UpdateResult> updateResults = new ArrayList<UpdateResult>(0);
        private long totalBatchesAdded = 0L;
        private boolean newAdded = false;

        public BatchExecution(PreparedStatement preparedStatement, FetchGenKey<T> fetchGenKey) {
            this.ps = preparedStatement;
            this.fetchGen = fetchGenKey;
        }

        public void add(List<?> list) throws SQLException {
            this.addParamsToBatch(list);
            if (BatchQueryInternal.this.batchSize.isPresent() && this.totalBatchesAdded % (long)((Integer)BatchQueryInternal.this.batchSize.get()).intValue() == 0L) {
                this.runBatch();
            }
        }

        private void addParamsToBatch(List<?> list) throws SQLException {
            BatchQueryInternal.this.query.assignParams(this.ps, list);
            this.ps.addBatch();
            ++this.totalBatchesAdded;
            this.newAdded = true;
        }

        private void runBatch() throws SQLException {
            this.updateResults.addAll(this.fetchGen.fetch() ? this.executeFetch() : this.executeNoFetch());
        }

        private List<UpdateResultGenKeys<T>> executeFetch() throws SQLException {
            List<Integer> list = Ints.asList(this.ps.executeBatch());
            Integer n2 = list.stream().mapToInt(n -> n).sum();
            UpdateResultGenKeys<T> updateResultGenKeys = this.fetchGen.genKeys(this.ps, n2);
            Iterator<T> iterator = updateResultGenKeys.generatedKeys().iterator();
            return Collections.unmodifiableList(list.stream().map(n -> new UpdateResultGenKeysInternal<T>((long)n, this.iterate(iterator, (Integer)n))).collect(Collectors.toList()));
        }

        private List<UpdateResultInternal> executeNoFetch() throws SQLException {
            return Ints.asList(this.ps.executeBatch()).stream().map(n -> (long)n).map(UpdateResultInternal::new).collect(Collectors.toList());
        }

        private List<UpdateResult> results() throws SQLException {
            if (this.newAdded) {
                this.runBatch();
            }
            return Collections.unmodifiableList(this.updateResults);
        }

        private List<T> iterate(Iterator<T> iterator, Integer n2) {
            ArrayList arrayList = new ArrayList(n2);
            IntStream.range(0, n2).forEach(n -> arrayList.add(iterator.next()));
            return arrayList;
        }
    }
}

