/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.mappers;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.codejargon.fluentjdbc.api.mapper.ObjectMapperRsExtractor;

public class DefaultObjectMapperRsExtractors {
    private static boolean attemptBlobFree = true;
    private static final Map<Class, ObjectMapperRsExtractor> extractors;

    private static void javaDate(Map<Class, ObjectMapperRsExtractor<?>> map) {
        DefaultObjectMapperRsExtractors.reg(map, java.util.Date.class, ResultSet::getTimestamp);
    }

    private static void javaTimeTypes(Map<Class, ObjectMapperRsExtractor<?>> map) {
        DefaultObjectMapperRsExtractors.reg(map, LocalDate.class, (resultSet, n) -> {
            Date date = resultSet.getDate(n);
            return date != null ? date.toLocalDate() : null;
        });
        DefaultObjectMapperRsExtractors.reg(map, LocalDateTime.class, (resultSet, n) -> {
            Timestamp timestamp = resultSet.getTimestamp(n);
            return timestamp != null ? timestamp.toLocalDateTime() : null;
        });
        DefaultObjectMapperRsExtractors.reg(map, LocalTime.class, (resultSet, n) -> {
            Time time = resultSet.getTime(n);
            return time != null ? time.toLocalTime() : null;
        });
        DefaultObjectMapperRsExtractors.reg(map, Year.class, (resultSet, n) -> {
            Date date = resultSet.getDate(n);
            return date != null ? Year.from(date.toLocalDate()) : null;
        });
        DefaultObjectMapperRsExtractors.reg(map, YearMonth.class, (resultSet, n) -> {
            Date date = resultSet.getDate(n);
            return date != null ? YearMonth.from(date.toLocalDate()) : null;
        });
        DefaultObjectMapperRsExtractors.reg(map, Instant.class, (resultSet, n) -> {
            Timestamp timestamp = resultSet.getTimestamp(n);
            return timestamp != null ? timestamp.toInstant() : null;
        });
    }

    private static void basicTypes(Map<Class, ObjectMapperRsExtractor<?>> map) {
        DefaultObjectMapperRsExtractors.reg(map, Boolean.class, ResultSet::getBoolean);
        DefaultObjectMapperRsExtractors.reg(map, Boolean.TYPE, ResultSet::getBoolean);
        DefaultObjectMapperRsExtractors.reg(map, Short.class, ResultSet::getShort);
        DefaultObjectMapperRsExtractors.reg(map, Short.TYPE, ResultSet::getShort);
        DefaultObjectMapperRsExtractors.reg(map, Integer.class, ResultSet::getInt);
        DefaultObjectMapperRsExtractors.reg(map, Integer.TYPE, ResultSet::getInt);
        DefaultObjectMapperRsExtractors.reg(map, Long.class, ResultSet::getLong);
        DefaultObjectMapperRsExtractors.reg(map, Long.TYPE, ResultSet::getLong);
        DefaultObjectMapperRsExtractors.reg(map, Float.class, ResultSet::getFloat);
        DefaultObjectMapperRsExtractors.reg(map, Float.TYPE, ResultSet::getFloat);
        DefaultObjectMapperRsExtractors.reg(map, Double.class, ResultSet::getDouble);
        DefaultObjectMapperRsExtractors.reg(map, Double.TYPE, ResultSet::getDouble);
        DefaultObjectMapperRsExtractors.reg(map, BigDecimal.class, ResultSet::getBigDecimal);
        DefaultObjectMapperRsExtractors.reg(map, Timestamp.class, ResultSet::getTimestamp);
        DefaultObjectMapperRsExtractors.reg(map, Time.class, ResultSet::getTime);
        DefaultObjectMapperRsExtractors.reg(map, Date.class, ResultSet::getDate);
        DefaultObjectMapperRsExtractors.reg(map, String.class, ResultSet::getString);
    }

    private static void binaryTypes(Map<Class, ObjectMapperRsExtractor<?>> map) {
        DefaultObjectMapperRsExtractors.reg(map, byte[].class, (resultSet, n) -> {
            Blob blob = resultSet.getBlob(n);
            if (blob == null) {
                return null;
            }
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            DefaultObjectMapperRsExtractors.freeBlob(blob);
            return byArray;
        });
        DefaultObjectMapperRsExtractors.reg(map, ByteBuffer.class, (resultSet, n) -> {
            Blob blob = resultSet.getBlob(n);
            if (blob == null) {
                return null;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(blob.getBytes(1L, (int)blob.length()));
            DefaultObjectMapperRsExtractors.freeBlob(blob);
            return byteBuffer;
        });
    }

    private static void freeBlob(Blob blob) throws SQLException {
        if (attemptBlobFree) {
            try {
                blob.free();
            }
            catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
                attemptBlobFree = false;
            }
        }
    }

    public static Map<Class, ObjectMapperRsExtractor> extractors() {
        return extractors;
    }

    private static <T> void reg(Map<Class, ObjectMapperRsExtractor<?>> map, Class<T> clazz, ObjectMapperRsExtractor<T> objectMapperRsExtractor) {
        map.put(clazz, objectMapperRsExtractor);
    }

    static {
        HashMap hashMap = new HashMap();
        DefaultObjectMapperRsExtractors.basicTypes(hashMap);
        DefaultObjectMapperRsExtractors.javaDate(hashMap);
        DefaultObjectMapperRsExtractors.javaTimeTypes(hashMap);
        DefaultObjectMapperRsExtractors.binaryTypes(hashMap);
        extractors = Collections.unmodifiableMap(hashMap);
    }
}

