/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.codejargon.fluentjdbc.internal.query.QueryConfig;
import org.codejargon.fluentjdbc.internal.query.SingleQueryBase;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;

class PreparedStatementFactory {
    private final QueryConfig config;

    PreparedStatementFactory(QueryConfig queryConfig) {
        this.config = queryConfig;
    }

    PreparedStatement createSingle(Connection connection, SingleQueryBase singleQueryBase, boolean bl) throws SQLException {
        SqlAndParams sqlAndParams = singleQueryBase.sqlAndParams(this.config);
        PreparedStatement preparedStatement = this.prepareStatement(connection, sqlAndParams.sql(), bl);
        singleQueryBase.customizeQuery(preparedStatement, this.config);
        this.assignParams(preparedStatement, sqlAndParams.params());
        return preparedStatement;
    }

    PreparedStatement createBatch(Connection connection, String string) throws SQLException {
        return this.prepareStatement(connection, string, false);
    }

    void assignParams(PreparedStatement preparedStatement, List<?> list) throws SQLException {
        this.config.paramAssigner.assignParams(preparedStatement, list);
    }

    private PreparedStatement prepareStatement(Connection connection, String string, Boolean bl) throws SQLException {
        return bl != false ? connection.prepareStatement(string, 1) : connection.prepareStatement(string);
    }
}

