/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.mapper;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codejargon.fluentjdbc.api.mapper.ObjectMapperRsExtractor;
import org.codejargon.fluentjdbc.api.query.Mapper;
import org.codejargon.fluentjdbc.internal.mappers.DefaultObjectMapperRsExtractors;
import org.codejargon.fluentjdbc.internal.mappers.ObjectMapper;
import org.codejargon.fluentjdbc.internal.support.Maps;

public class ObjectMappers {
    private final Map<Class, ObjectMapperRsExtractor> extractors;
    private final Map<Class, Mapper<?>> mappers;

    private ObjectMappers(Map<Class, ObjectMapperRsExtractor> extractors) {
        this.extractors = Maps.merge(DefaultObjectMapperRsExtractors.extractors(), extractors);
        this.mappers = new ConcurrentHashMap();
    }

    public <T> Mapper<T> forClass(Class<T> clazz) {
        if (!this.mappers.containsKey(clazz)) {
            this.mappers.put(clazz, new ObjectMapper<T>(clazz, this.extractors));
        }
        return this.mappers.get(clazz);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<Class, ObjectMapperRsExtractor> extractors = Maps.copyOf(new HashMap());

        private Builder() {
        }

        public Builder extractors(Map<Class, ObjectMapperRsExtractor> extractors) {
            this.extractors = Maps.copyOf(extractors);
            return this;
        }

        public ObjectMappers build() {
            return new ObjectMappers(Maps.copyOf(this.extractors));
        }
    }
}

