/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.codejargon.fluentjdbc.api.ParamSetter;
import org.codejargon.fluentjdbc.internal.query.DefaultParamSetters;
import org.codejargon.fluentjdbc.internal.query.ParamAssigner;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;
import org.codejargon.fluentjdbc.internal.support.Maps;

public class QueryConfig {
    final ParamAssigner paramAssigner;
    final Map<String, NamedTransformedSql> namedParamSqlCache;
    final Optional<Integer> defaultFetchSize;

    public QueryConfig(Optional<Integer> defaultFetchSize, Map<Class, ParamSetter> paramSetters) {
        this.paramAssigner = new ParamAssigner(Maps.merge(DefaultParamSetters.setters(), paramSetters));
        this.namedParamSqlCache = new ConcurrentHashMap<String, NamedTransformedSql>();
        this.defaultFetchSize = defaultFetchSize;
    }

    NamedTransformedSql namedTransformedSql(String sql) {
        if (!this.namedParamSqlCache.containsKey(sql)) {
            this.namedParamSqlCache.put(sql, NamedTransformedSql.forSql(sql));
        }
        return this.namedParamSqlCache.get(sql);
    }

    Optional<Integer> fetchSize(Optional<Integer> selectFetchSize) {
        return selectFetchSize.isPresent() ? selectFetchSize : this.defaultFetchSize;
    }
}

