/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.support;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FindFirst<T> {
    private static final Predicate notNull = e -> e != null;
    private static final Predicate<Optional> isPresent = Optional::isPresent;
    private Optional<Iterable<T>> elements;
    private Optional<Iterable<Supplier<T>>> elementsLazy;

    public FindFirst(Optional<Iterable<T>> elements, Optional<Iterable<Supplier<T>>> elementsLazy) {
        this.elements = elements;
        this.elementsLazy = elementsLazy;
    }

    @SafeVarargs
    public static <T> FindFirst<T> from(T ... elements) {
        return FindFirst.from(Arrays.asList(elements));
    }

    public static <T> FindFirst<T> from(Iterable<T> elements) {
        return new FindFirst<T>(Optional.of(elements), Optional.empty());
    }

    @SafeVarargs
    public static <T> FindFirst<T> fromLazy(Supplier<T> ... suppliers) {
        return FindFirst.fromLazy(Arrays.asList(suppliers));
    }

    public static <T> FindFirst<T> fromLazy(Iterable<Supplier<T>> suppliers) {
        return new FindFirst<T>(Optional.empty(), Optional.of(suppliers));
    }

    public Optional<T> which(Predicate<T> predicate) {
        return this.stream().filter(predicate).findFirst();
    }

    public Optional<T> whichIsNotNull() {
        return this.which(notNull);
    }

    public Optional<T> whichIsPresent() {
        return this.which(isPresent);
    }

    private Stream<T> stream() {
        return this.elements.isPresent() ? FindFirst.iterableLazy(this.elements.get()) : FindFirst.iterableLazy(this.elementsLazy.get()).map(Supplier::get);
    }

    private static <T> Stream<T> iterableLazy(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

