/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codejargon.fluentjdbc.api.query.BatchQuery;
import org.codejargon.fluentjdbc.api.query.UpdateResult;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;
import org.codejargon.fluentjdbc.internal.query.UpdateResultInternal;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedSqlAndParams;
import org.codejargon.fluentjdbc.internal.query.namedparameter.TransformedSql;
import org.codejargon.fluentjdbc.internal.support.Ints;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

class BatchQueryInternal
implements BatchQuery {
    private final String sql;
    private final QueryInternal query;
    private Optional<Iterator<List<Object>>> params = Optional.empty();
    private Optional<Iterator<Map<String, Object>>> namedParams = Optional.empty();
    private Optional<Integer> batchSize = Optional.empty();

    public BatchQueryInternal(String sql, QueryInternal query) {
        this.sql = sql;
        this.query = query;
    }

    @Override
    public BatchQuery params(Iterator<List<Object>> params) {
        Preconditions.checkNotNull(params, "params");
        Preconditions.checkArgument(!this.namedParams.isPresent(), "Positional parameters can't be set if named parameters are already set.");
        this.params = Optional.of(params);
        return this;
    }

    @Override
    public BatchQuery namedParams(Iterator<Map<String, Object>> namedParams) {
        Preconditions.checkNotNull(namedParams, "namedParams");
        Preconditions.checkArgument(!this.params.isPresent(), "Named parameters can't be set if positional parameters are already set.");
        this.namedParams = Optional.of(namedParams);
        return this;
    }

    @Override
    public BatchQuery batchSize(Integer batchSize) {
        Preconditions.checkNotNull(batchSize, "batch size");
        Preconditions.checkArgument(batchSize > 0, "batch size must be greater than 0");
        this.batchSize = Optional.of(batchSize);
        return this;
    }

    @Override
    public List<UpdateResult> run() {
        Preconditions.checkArgument(this.params.isPresent() || this.namedParams.isPresent(), "Parameters must be set to run a batch query");
        return this.query.query(connection -> this.params.isPresent() ? this.positional(connection) : this.named(connection), this.sql);
    }

    private List<UpdateResult> positional(Connection connection) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.sql);){
            Batch batch = new Batch();
            while (this.params.get().hasNext()) {
                this.assignParamAndRunBatchWhenNeeded(statement, batch, this.params.get().next());
            }
            this.runBatch(statement, batch);
            List list = batch.results();
            return list;
        }
    }

    private List<UpdateResult> named(Connection connection) throws SQLException {
        TransformedSql transformedSql = this.query.config.transformedSql(this.sql);
        try (PreparedStatement statement = connection.prepareStatement(transformedSql.sql());){
            Batch batch = new Batch();
            while (this.namedParams.get().hasNext()) {
                SqlAndParams sqlAndParams = NamedSqlAndParams.sqlAndParams(transformedSql, this.namedParams.get().next());
                this.assignParamAndRunBatchWhenNeeded(statement, batch, sqlAndParams.params());
            }
            this.runBatch(statement, batch);
            List list = batch.results();
            return list;
        }
    }

    private void assignParamAndRunBatchWhenNeeded(PreparedStatement statement, Batch batch, List<Object> params) throws SQLException {
        this.query.assignParams(statement, params);
        statement.addBatch();
        batch.added();
        if (this.batchSize.isPresent() && batch.batchesAdded % this.batchSize.get() == 0) {
            this.runBatch(statement, batch);
        }
    }

    private void runBatch(PreparedStatement statement, Batch batch) throws SQLException {
        List<Integer> updateds = Ints.asList(statement.executeBatch());
        batch.newResults(updateds.stream().map(i -> (long)i).map(UpdateResultInternal::new).collect(Collectors.toList()));
    }

    private static class Batch {
        private int batchesAdded = 0;
        private final List<UpdateResult> updateResults = new ArrayList<UpdateResult>();

        private Batch() {
        }

        private void added() {
            ++this.batchesAdded;
        }

        private void newResults(List<UpdateResult> newResults) {
            this.updateResults.addAll(newResults);
        }

        private List<UpdateResult> results() {
            return Collections.unmodifiableList(this.updateResults);
        }
    }
}

