/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.codejargon.fluentjdbc.api.query.Mapper;
import org.codejargon.fluentjdbc.api.query.SelectQuery;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.SingleQueryBase;
import org.codejargon.fluentjdbc.internal.support.Predicates;

class SelectQueryInternal
extends SingleQueryBase
implements SelectQuery {
    private final QueryInternal query;
    private final String sql;
    private Predicate filter = Predicates.alwaysTrue();

    SelectQueryInternal(String sql, QueryInternal query) {
        this.sql = sql;
        this.query = query;
    }

    @Override
    public <T> SelectQuery filter(Predicate<T> filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public SelectQuery params(List<Object> params) {
        this.addParameters(params);
        return this;
    }

    @Override
    public SelectQuery params(Object ... params) {
        this.addParameters(params);
        return this;
    }

    @Override
    public SelectQuery namedParams(Map<String, Object> namedParams) {
        this.addNamedParameters(namedParams);
        return this;
    }

    @Override
    public <T> Optional<T> firstResult(Mapper<T> mapper) {
        return this.query.query(connection -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, this.sql);
    }

    @Override
    public <T> T singleResult(Mapper<T> mapper) {
        Optional<T> firstResult = this.firstResult(mapper);
        if (!firstResult.isPresent()) {
            throw this.query.queryException(this.sql, Optional.of("At least one result expected"), Optional.empty());
        }
        return firstResult.get();
    }

    @Override
    public <T> List<T> listResult(Mapper<T> mapper) {
        ArrayList results = new ArrayList();
        this.iterateResult(mapper, results::add);
        return Collections.unmodifiableList(results);
    }

    @Override
    public <T> Set<T> setResult(Mapper<T> mapper) {
        HashSet results = new HashSet();
        this.iterateResult(mapper, results::add);
        return Collections.unmodifiableSet(results);
    }

    @Override
    public <T> void iterateResult(Mapper<T> mapper, Consumer<T> consumer) {
        this.query.query(connection -> {
            try (PreparedStatement ps = this.query.preparedStatement(connection, this.sql, this.params, this.namedParams);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Object candidate = mapper.map(rs);
                    if (!this.filter.test(candidate)) continue;
                    consumer.accept(candidate);
                }
            }
            return null;
        }, this.sql);
    }
}

