/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools.project;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.codehaus.tycho.osgitools.project.BuildOutputJar;
import org.codehaus.tycho.osgitools.project.EclipsePluginProject;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipsePluginProjectImpl
implements EclipsePluginProject {
    private final MavenProject project;
    private final BundleDescription bundleDescription;
    private final Properties buildProperties;
    private final LinkedHashMap<String, BuildOutputJar> outputJars = new LinkedHashMap();
    private final BuildOutputJar dotOutputJar;

    public EclipsePluginProjectImpl(MavenProject project, BundleDescription desc) throws IOException {
        this.project = project;
        this.bundleDescription = desc;
        this.buildProperties = EclipsePluginProjectImpl.loadProperties(project);
        LinkedHashMap<String, BuildOutputJar> jars = new LinkedHashMap<String, BuildOutputJar>();
        String jarsOrder = this.buildProperties.getProperty("jars.compile.order");
        if (jarsOrder != null) {
            for (String jarName : jarsOrder.split(",")) {
                jars.put(jarName, null);
            }
        }
        for (Map.Entry<Object, Object> entry : this.buildProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith("source.")) continue;
            String jarName = key.substring(7);
            File outputDirectory = ".".equals(jarName) ? new File(project.getBuild().getOutputDirectory()) : new File(project.getBuild().getDirectory(), jarName + "-classes");
            List<File> sourceFolders = this.toFileList(project.getBasedir(), value.split(","));
            jars.put(jarName, new BuildOutputJar(jarName, outputDirectory, sourceFolders));
        }
        this.dotOutputJar = (BuildOutputJar)jars.get(".");
        for (BuildOutputJar jar : jars.values()) {
            if (jar == null) continue;
            this.outputJars.put(jar.getName(), jar);
        }
    }

    private List<File> toFileList(File parent, String[] names) throws IOException {
        ArrayList<File> result = new ArrayList<File>();
        for (String name : names) {
            result.add(new File(parent, name).getCanonicalFile());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(MavenProject project) throws IOException {
        File file = new File(project.getBasedir(), "build.properties");
        Properties buildProperties = new Properties();
        if (file.canRead()) {
            FileInputStream is = new FileInputStream(file);
            try {
                buildProperties.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        return buildProperties;
    }

    @Override
    public Properties getBuildProperties() {
        return this.buildProperties;
    }

    @Override
    public BundleDescription getBundleDescription() {
        return this.bundleDescription;
    }

    @Override
    public MavenProject getMavenProject() {
        return this.project;
    }

    @Override
    public List<BuildOutputJar> getOutputJars() {
        return new ArrayList<BuildOutputJar>(this.outputJars.values());
    }

    @Override
    public BuildOutputJar getDotOutputJar() {
        return this.dotOutputJar;
    }

    @Override
    public Map<String, BuildOutputJar> getOutputJarMap() {
        return this.outputJars;
    }
}

