/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools.targetplatform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=EclipseInstallationLayout.class, instantiationStrategy="per-lookup")
public class EclipseInstallationLayout
extends AbstractLogEnabled {
    public static final String PLUGINS = "plugins";
    public static final String FEATURES = "features";
    private File location;
    private File dropinsLocation;
    private static final String PLATFORM_BASE_PREFIX = "platform:/base/";
    private static final String FILE_PREFIX = "file:";

    public void setLocation(File location) {
        this.location = location;
        this.dropinsLocation = new File(location, "dropins");
    }

    public Set<File> getFeatures(File site) {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        File[] plugins = new File(site, FEATURES).listFiles();
        if (plugins != null) {
            result.addAll(Arrays.asList(plugins));
        }
        return result;
    }

    public Set<File> getInstalledPlugins() {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        try {
            result.addAll(this.readBundlesTxt(this.location));
        }
        catch (IOException e) {
            this.getLogger().warn("Exception reading P2 bundles list", (Throwable)e);
        }
        return result;
    }

    public Set<File> getPlugins(File site) {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        this.addPlugins(result, new File(site, PLUGINS).listFiles());
        if (this.dropinsLocation.equals(site)) {
            this.addPlugins(result, site.listFiles());
        }
        return result;
    }

    private void addPlugins(Set<File> result, File[] plugins) {
        if (plugins != null) {
            for (File plugin : plugins) {
                if (plugin.isDirectory() && this.isDIrectoryPlugin(plugin)) {
                    result.add(plugin);
                    continue;
                }
                if (!plugin.isFile() || !plugin.getName().endsWith(".jar")) continue;
                result.add(plugin);
            }
        }
    }

    private boolean isDIrectoryPlugin(File plugin) {
        return new File(plugin, "META-INF/MANIFEST.MF").canRead() || new File(plugin, "plugin.xml").canRead() || new File(plugin, "fragment.xml").canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getSites() {
        File platform;
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        if (this.location == null) {
            return result;
        }
        if (new File(this.location, PLUGINS).isDirectory()) {
            result.add(this.location);
        }
        if ((platform = new File(this.location, "configuration/org.eclipse.update/platform.xml")).canRead()) {
            try {
                FileInputStream is = new FileInputStream(platform);
                try {
                    Xpp3Dom[] sites;
                    XmlStreamReader reader = new XmlStreamReader((InputStream)is);
                    Xpp3Dom dom = Xpp3DomBuilder.build((Reader)reader);
                    for (Xpp3Dom site : sites = dom.getChildren("site")) {
                        File dir;
                        String enabled = site.getAttribute("enabled");
                        if (enabled != null && !Boolean.parseBoolean(enabled) || (dir = this.parsePlatformURL(this.location, site.getAttribute("url"))) == null) continue;
                        result.add(dir);
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                this.getLogger().warn("Exception parsing " + this.toString(platform), (Throwable)e);
            }
        }
        this.addLinks(result, this.location, new File(this.location, "links"));
        result.add(this.dropinsLocation);
        File[] dropinsFiles = this.dropinsLocation.listFiles();
        if (dropinsFiles != null) {
            for (File dropinsFile : dropinsFiles) {
                File plugins = new File(dropinsFile, PLUGINS);
                if (plugins.isDirectory()) {
                    result.add(plugins.getParentFile());
                    continue;
                }
                plugins = new File(dropinsFile, "eclipse/plugins");
                if (!plugins.isDirectory()) continue;
                result.add(plugins.getParentFile());
            }
        }
        this.addLinks(result, this.location, this.dropinsLocation);
        return result;
    }

    private String toString(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLinks(Set<File> result, File targetPlatform, File linksFolder) {
        File[] links = linksFolder.listFiles();
        if (links != null) {
            for (File link : links) {
                if (!link.isFile() || !link.canRead() || !link.getName().endsWith(".link")) continue;
                Properties props = new Properties();
                try {
                    FileInputStream is = new FileInputStream(link);
                    try {
                        props.load(is);
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                    String path = props.getProperty("path");
                    if (path == null) continue;
                    File dir = new File(path);
                    if (!dir.isAbsolute() && targetPlatform.getParentFile() != null) {
                        dir = new File(targetPlatform.getParentFile(), path);
                    }
                    if (!(dir = dir.getCanonicalFile()).isDirectory()) continue;
                    result.add(dir);
                }
                catch (Exception e) {
                    this.getLogger().warn("Exception parsing " + this.toString(link), (Throwable)e);
                }
            }
        }
    }

    private File parsePlatformURL(File platformBase, String url) {
        if (url == null) {
            return null;
        }
        url = url.replace('\\', '/');
        String relPath = null;
        if (url.startsWith(PLATFORM_BASE_PREFIX)) {
            relPath = url.substring(PLATFORM_BASE_PREFIX.length());
        } else if (url.startsWith(FILE_PREFIX)) {
            relPath = url.substring(FILE_PREFIX.length());
        }
        if (relPath == null) {
            return null;
        }
        if (relPath.length() > 0 && relPath.charAt(0) == '/') {
            return new File(relPath);
        }
        return new File(platformBase, relPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> readBundlesTxt(File platformBase) throws IOException {
        this.getLogger().debug("Reading P2 bundles list");
        File eclipseIni = new File(platformBase, "eclipse.ini");
        File pool = platformBase;
        if (eclipseIni.isFile() && eclipseIni.canRead()) {
            BufferedReader in = new BufferedReader(new FileReader(eclipseIni));
            try {
                String str = null;
                while ((str = in.readLine()) != null) {
                    if (!"-startup".equals(str.trim())) continue;
                    str = in.readLine();
                    if (str != null) {
                        File file = new File(str);
                        if (!file.isAbsolute()) {
                            file = new File(platformBase, str).getCanonicalFile();
                        }
                        pool = file.getParentFile().getParentFile().getCanonicalFile();
                    }
                    break;
                }
            }
            finally {
                in.close();
            }
        }
        this.getLogger().debug("Bundle pool location " + this.toString(pool));
        File bundlesInfo = new File(platformBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
        if (!bundlesInfo.isFile() || !bundlesInfo.canRead()) {
            this.getLogger().info("Could not read P2 bundles list " + this.toString(bundlesInfo));
            return null;
        }
        ArrayList<File> plugins = new ArrayList<File>();
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(bundlesInfo)));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (line.startsWith("#") || (line = line.trim()).length() == 0 || line.startsWith("org.eclipse.equinox.simpleconfigurator.baseUrl=")) continue;
                StringTokenizer tok = new StringTokenizer(line, ",");
                tok.nextToken();
                tok.nextToken();
                String location = tok.nextToken();
                plugins.add(this.parsePlatformURL(pool, location));
            }
        }
        finally {
            r.close();
        }
        return plugins;
    }
}

