/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Version;

public class ExecutionEnvironmentUtils {
    private static String J2SE = "J2SE-";
    private static String JAVASE = "JavaSE-";
    private static String PROFILE_EXT = ".profile";

    public static void loadVMProfile(Properties properties) {
        String ee;
        Properties profileProps = ExecutionEnvironmentUtils.findVMProfile(properties);
        String systemExports = properties.getProperty("org.osgi.framework.system.packages");
        if (systemExports == null && (systemExports = profileProps.getProperty("org.osgi.framework.system.packages")) != null) {
            properties.put("org.osgi.framework.system.packages", systemExports);
        }
        String type = properties.getProperty("osgi.java.profile.bootdelegation");
        String profileBootDelegation = profileProps.getProperty("org.osgi.framework.bootdelegation");
        if ("override".equals(type)) {
            if (profileBootDelegation == null) {
                properties.remove("org.osgi.framework.bootdelegation");
            } else {
                properties.put("org.osgi.framework.bootdelegation", profileBootDelegation);
            }
        } else if ("none".equals(type)) {
            properties.remove("org.osgi.framework.bootdelegation");
        }
        if (properties.getProperty("org.osgi.framework.executionenvironment") == null && (ee = profileProps.getProperty("org.osgi.framework.executionenvironment", profileProps.getProperty("osgi.java.profile.name"))) != null) {
            properties.put("org.osgi.framework.executionenvironment", ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties findVMProfile(Properties properties) {
        String javaProfile;
        Properties result = new Properties();
        String j2meConfig = properties.getProperty("microedition.configuration");
        String j2meProfiles = properties.getProperty("microedition.profiles");
        String vmProfile = null;
        String javaEdition = null;
        Version javaVersion = null;
        if (j2meConfig != null && j2meConfig.length() > 0 && j2meProfiles != null && j2meProfiles.length() > 0) {
            String[] j2meProfileList = ManifestElement.getArrayFromList((String)j2meProfiles, (String)" ");
            if (j2meProfileList != null && j2meProfileList.length > 0) {
                vmProfile = j2meConfig + '_' + j2meProfileList[j2meProfileList.length - 1];
            }
        } else {
            String javaSpecVersion = properties.getProperty("java.specification.version");
            if (javaSpecVersion != null) {
                StringTokenizer st = new StringTokenizer(javaSpecVersion, " _-");
                javaSpecVersion = st.nextToken();
                String javaSpecName = properties.getProperty("java.specification.name");
                if ("J2ME Foundation Specification".equals(javaSpecName)) {
                    vmProfile = "CDC-" + javaSpecVersion + "_Foundation-" + javaSpecVersion;
                } else {
                    Version v16 = new Version("1.6");
                    javaEdition = J2SE;
                    try {
                        javaVersion = new Version(javaSpecVersion);
                        if (v16.compareTo((Object)javaVersion) <= 0) {
                            javaEdition = JAVASE;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                    vmProfile = javaEdition + javaSpecVersion;
                }
            }
        }
        URL url = null;
        String propJavaProfile = FrameworkProperties.getProperty((String)"osgi.java.profile");
        if (propJavaProfile != null) {
            try {
                url = new URL(propJavaProfile);
            }
            catch (MalformedURLException e1) {
                url = ExecutionEnvironmentUtils.findInSystemBundle(propJavaProfile);
            }
        }
        if (url == null && vmProfile != null && (url = ExecutionEnvironmentUtils.findInSystemBundle(javaProfile = vmProfile + PROFILE_EXT)) == null) {
            url = ExecutionEnvironmentUtils.getNextBestProfile(javaEdition, javaVersion);
        }
        if (url == null) {
            url = ExecutionEnvironmentUtils.findInSystemBundle("OSGi_Minimum-1.1.profile");
        }
        if (url != null) {
            InputStream in = null;
            try {
                in = url.openStream();
                result.load(new BufferedInputStream(in));
            }
            catch (IOException e) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ee) {}
                }
            }
        }
        if (result.getProperty("osgi.java.profile.name") == null) {
            if (vmProfile != null) {
                result.put("osgi.java.profile.name", vmProfile.replace('_', '/'));
            } else {
                result.put("osgi.java.profile.name", "OSGi/Minimum-1.1");
            }
        }
        return result;
    }

    private static URL getNextBestProfile(String javaEdition, Version javaVersion) {
        if (javaVersion == null || javaEdition != J2SE && javaEdition != JAVASE) {
            return null;
        }
        URL bestProfile = ExecutionEnvironmentUtils.findNextBestProfile(javaEdition, javaVersion);
        if (bestProfile == null && javaEdition == JAVASE) {
            bestProfile = ExecutionEnvironmentUtils.findNextBestProfile(J2SE, javaVersion);
        }
        return bestProfile;
    }

    private static URL findNextBestProfile(String javaEdition, Version javaVersion) {
        URL result = null;
        int minor = javaVersion.getMinor();
        while ((result = ExecutionEnvironmentUtils.findInSystemBundle(javaEdition + javaVersion.getMajor() + "." + minor + PROFILE_EXT)) == null && --minor > 0) {
        }
        return result;
    }

    private static URL findInSystemBundle(String entry) {
        ClassLoader loader = ExecutionEnvironmentUtils.class.getClassLoader();
        return loader == null ? ClassLoader.getSystemResource(entry) : loader.getResource(entry);
    }
}

