/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools.targetplatform;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.PluginRef;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.targetplatform.EclipseInstallationLayout;
import org.codehaus.tycho.osgitools.targetplatform.TargetPlatformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=EclipseTargetPlatformFactory.class)
public class EclipseTargetPlatformFactory
extends AbstractLogEnabled {
    public static final String PACKAGING_ECLIPSE_INSTALLATION = "eclipse-installation";
    public static final String PACKAGING_ECLIPSE_EXTENSION_LOCATION = "eclipse-extension-location";
    public static final String PACKAGING_ECLIPSE_PLUGIN = "eclipse-plugin";
    public static final String PACKAGING_ECLIPSE_FEATURE = "eclipse-feature";
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactFactory artifactFactory;

    public void createTargetPlatform(List<MavenProject> projects, ArtifactRepository localRepository, OsgiState state) {
        File installation = this.getEclipseInstallation(projects);
        if (installation != null) {
            this.createTargetPlatform(state, installation);
        }
        Set<File> extensionLocations = this.getEclipseLocations(projects, PACKAGING_ECLIPSE_EXTENSION_LOCATION, false);
        for (File extensionLocation : extensionLocations) {
            this.addExtensionLocation(state, extensionLocation);
        }
        LinkedHashSet<File> features = new LinkedHashSet<File>();
        LinkedHashSet<File> bundles = new LinkedHashSet<File>();
        HashMap<Artifact, Exception> exceptions = new HashMap<Artifact, Exception>();
        for (MavenProject mavenProject : projects) {
            Map versionMap = mavenProject.getManagedVersionMap();
            if (versionMap == null) continue;
            for (Artifact artifact : versionMap.values()) {
                try {
                    if (PACKAGING_ECLIPSE_FEATURE.equals(artifact.getType())) {
                        this.resolveFeature(artifact, features, bundles, mavenProject.getRemoteArtifactRepositories(), localRepository);
                        continue;
                    }
                    if (!PACKAGING_ECLIPSE_PLUGIN.equals(artifact.getType())) continue;
                    this.resolvePlugin(artifact, bundles, mavenProject.getRemoteArtifactRepositories(), localRepository);
                }
                catch (Exception e) {
                    exceptions.put(artifact, e);
                }
            }
        }
        if (!exceptions.isEmpty()) {
            this.getLogger().warn("There were exceptions resolving build target platform");
            for (Map.Entry entry : exceptions.entrySet()) {
                this.getLogger().warn(entry.getKey() + " " + ((Exception)entry.getValue()).getMessage());
            }
        }
        state.addSite(new File(localRepository.getBasedir()), features, bundles);
    }

    public void createTargetPlatform(OsgiState state, File installation) {
        state.setTargetPlatform(installation);
        EclipseInstallationLayout finder = new EclipseInstallationLayout(this.getLogger(), installation);
        Set<File> sites = finder.getSites();
        for (File site : sites) {
            Set<File> features = finder.getFeatures(site);
            Set<File> bundles = finder.getPlugins(site);
            state.addSite(site, features, bundles);
        }
    }

    private void addExtensionLocation(OsgiState state, File location) {
        EclipseInstallationLayout finder = new EclipseInstallationLayout(this.getLogger(), location);
        Set<File> features = finder.getFeatures(location);
        Set<File> bundles = finder.getPlugins(location);
        state.addSite(location, features, bundles);
    }

    private void resolveFeature(Artifact artifact, Set<File> features, Set<File> bundles, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws AbstractArtifactResolutionException, IOException, XmlPullParserException {
        this.resolveArtifact(artifact, remoteRepositories, localRepository);
        Feature feature = Feature.readJar(artifact.getFile());
        if (features.add(artifact.getFile())) {
            Artifact includedArtifact;
            for (PluginRef pluginRef : feature.getPlugins()) {
                try {
                    includedArtifact = this.artifactFactory.createArtifact(pluginRef.getMavenGroupId(), pluginRef.getId(), pluginRef.getMavenVersion(), null, PACKAGING_ECLIPSE_PLUGIN);
                    this.resolvePlugin(includedArtifact, bundles, remoteRepositories, localRepository);
                }
                catch (Exception e) {
                    this.getLogger().warn(e.getMessage());
                }
            }
            for (Feature.FeatureRef featureRef : feature.getIncludedFeatures()) {
                try {
                    includedArtifact = this.artifactFactory.createArtifact(featureRef.getMavenGroupId(), featureRef.getId(), featureRef.getMavenVersion(), null, PACKAGING_ECLIPSE_FEATURE);
                    this.resolveFeature(includedArtifact, features, bundles, remoteRepositories, localRepository);
                }
                catch (Exception e) {
                    this.getLogger().warn(e.getMessage());
                }
            }
        }
    }

    private void assertResolved(Artifact artifact) throws ArtifactNotFoundException {
        if (!artifact.isResolved() || artifact.getFile() == null || !artifact.getFile().canRead()) {
            throw new ArtifactNotFoundException("Artifact is not resolved", artifact);
        }
    }

    private void resolvePlugin(Artifact artifact, Set<File> bundles, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws AbstractArtifactResolutionException {
        this.resolveArtifact(artifact, remoteRepositories, localRepository);
        bundles.add(artifact.getFile());
    }

    private void resolveArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws AbstractArtifactResolutionException {
        this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
        this.assertResolved(artifact);
    }

    private File getEclipseInstallation(List<MavenProject> projects) {
        Set<File> locations = this.getEclipseLocations(projects, PACKAGING_ECLIPSE_INSTALLATION, true);
        return !locations.isEmpty() ? locations.iterator().next() : null;
    }

    private Set<File> getEclipseLocations(List<MavenProject> projects, String packaging, boolean singleton) {
        LinkedHashSet<File> installations = new LinkedHashSet<File>();
        for (MavenProject project : projects) {
            Map versionMap = project.getManagedVersionMap();
            if (versionMap == null) continue;
            for (Artifact artifact : versionMap.values()) {
                if (!packaging.equals(artifact.getType())) continue;
                if (!singleton || installations.size() <= 0) {
                    installations.add(artifact.getFile());
                    continue;
                }
                if (installations.contains(artifact.getFile())) continue;
                throw new TargetPlatformException("No more than one eclipse-installation and/or eclipse-distributions");
            }
        }
        return installations;
    }
}

