/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools.features;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.osgi.framework.Version;

public class FeatureDescriptionImpl
implements FeatureDescription {
    private final String name;
    private final Version version;
    private final File location;
    private final Feature feature;
    private final Map<String, Object> userProperties = new HashMap<String, Object>();

    public FeatureDescriptionImpl(Feature feature, File location) {
        this.feature = feature;
        this.name = feature.getId();
        this.location = location;
        this.version = new Version(feature.getVersion());
    }

    public File getLocation() {
        return this.location;
    }

    public String getId() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FeatureDescription)) {
            return false;
        }
        FeatureDescription other = (FeatureDescription)obj;
        if (this.name == null ? other.getId() != null : !this.name.equals(other.getId())) {
            return false;
        }
        return !(this.version == null ? other.getVersion() != null : !this.version.equals((Object)other.getVersion()));
    }

    public Feature getFeature() {
        return this.feature;
    }

    public String toString() {
        return this.name + "_" + this.version.toString();
    }

    public void setUserProperty(String key, Object value) {
        this.userProperties.put(key, value);
    }

    public Object getUserProperty(String key) {
        return this.userProperties.get(key);
    }
}

