/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GroupMapper {
    private HashMap groupMap;
    private Pattern group2Pattern = Pattern.compile("^(\\w*\\.\\w*)(\\..*)?$");
    private Pattern group3Pattern = Pattern.compile("^(\\w*\\.\\w*\\.\\w*)(\\..*)?$");
    public static String[] group3 = new String[]{"net.sf", "org.apache", "org.codehaus", "org.tigris"};

    public GroupMapper(File configuration) throws IOException {
        this.groupMap = new HashMap();
        if (configuration != null && configuration.exists()) {
            Properties p = new Properties();
            p.load(new FileInputStream(configuration));
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String groupPattern = (String)entry.getKey();
                String groupId = (String)entry.getValue();
                Pattern pattern = Pattern.compile(groupPattern);
                this.groupMap.put(pattern, groupId);
            }
        }
    }

    public String getGroupId(String symbolicName) {
        for (Map.Entry entry : this.groupMap.entrySet()) {
            Pattern key = (Pattern)entry.getKey();
            if (!key.matcher(symbolicName).matches()) continue;
            return (String)entry.getValue();
        }
        Matcher m = null;
        for (int i = 0; i < group3.length; ++i) {
            if (!symbolicName.startsWith(group3[i])) continue;
            m = this.group3Pattern.matcher(symbolicName);
        }
        if (m == null) {
            m = this.group2Pattern.matcher(symbolicName);
        }
        if (m.matches()) {
            return m.group(1);
        }
        if (!symbolicName.contains(".")) {
            return symbolicName;
        }
        throw new IllegalArgumentException("artifactId " + symbolicName + " does not match any pattern");
    }
}

