/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.tycho.model.ProductConfiguration;
import org.codehaus.tycho.osgitools.AbstractDependenciesReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseApplicationDependenciesReader
extends AbstractDependenciesReader {
    @Override
    public List<Dependency> getDependencies(MavenProject project) throws MavenExecutionException {
        ProductConfiguration product;
        String productFilename = project.getArtifactId() + ".product";
        File productFile = new File(project.getBasedir(), productFilename);
        if (!productFile.exists()) {
            this.getLogger().warn("product file not found at " + productFile.getAbsolutePath());
            return NO_DEPENDENCIES;
        }
        try {
            product = ProductConfiguration.read(productFile);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (null == m) {
                m = e.getClass().getName();
            }
            MavenExecutionException me = new MavenExecutionException(m, project.getFile());
            me.initCause((Throwable)e);
            throw me;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.getPluginsDependencies(product.getPlugins()));
        result.addAll(this.getFeaturesDependencies(product.getFeatures()));
        return new ArrayList<Dependency>(result);
    }
}

