/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class BundleFile {
    private Manifest manifest;
    private Properties p;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleFile(Manifest manifest, File file) {
        block9: {
            this.p = new Properties();
            this.manifest = manifest;
            String localization = manifest.getMainAttributes().getValue("Bundle-Localization");
            if (!file.getName().equalsIgnoreCase("manifest.mf") && localization != null) {
                try {
                    if (file.isDirectory()) {
                        File localizationFile = new File(file, localization + ".properties");
                        if (localizationFile.exists()) {
                            FileInputStream fis = new FileInputStream(localizationFile);
                            this.p.load(fis);
                            fis.close();
                        }
                        break block9;
                    }
                    JarFile jar = new JarFile(file, false);
                    try {
                        JarEntry je = jar.getJarEntry(localization + ".properties");
                        if (je != null) {
                            this.p.load(jar.getInputStream(je));
                        }
                    }
                    finally {
                        jar.close();
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public boolean isBundle() {
        return this.manifest != null && this.manifest.getMainAttributes().getValue("Bundle-SymbolicName") != null;
    }

    public String getSymbolicName() {
        String symbolicName = this.manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        return symbolicName != null ? symbolicName.split(";")[0] : null;
    }

    public String getVersion() {
        return this.manifest.getMainAttributes().getValue("Bundle-Version");
    }

    public String getName() {
        return this.getAttribute("Bundle-Name");
    }

    public String getDescription() {
        return this.getAttribute("Bundle-Description");
    }

    public String getCopyright() {
        return this.getAttribute("Bundle-Copyright");
    }

    public String getURL() {
        return this.getAttribute("Bundle-DocUrl");
    }

    public String getOrganization() {
        return this.getAttribute("Bundle-Vendor");
    }

    public String getAttribute(String attribute) {
        String v;
        String result = this.manifest.getMainAttributes().getValue(attribute);
        if (result == null) {
            return null;
        }
        if (result.startsWith("%") && (v = this.p.getProperty(result.substring(1))) != null) {
            result = v;
        }
        return result;
    }

    public String getContactAddress() {
        return this.getAttribute("Bundle-ContactAddress");
    }
}

