/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.tycho.mapfile.MapEntry;
import org.codehaus.tycho.mapfile.MapfileUtils;

public class ImportMapfileMojo
extends AbstractMojo
implements Contextualizable {
    private PlexusContainer plexus;
    private File mapfile;
    private String scmSystem;
    private File baseFolder;
    private ScmManager scmManager;

    public void contextualize(Context ctx) throws ContextException {
        this.plexus = (PlexusContainer)ctx.get((Object)"plexus");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List lines;
        if (this.mapfile == null) {
            throw new MojoExecutionException("Mapfile not defined!");
        }
        if (!this.mapfile.exists()) {
            throw new MojoExecutionException("Mapfile not found " + this.mapfile.getAbsolutePath());
        }
        try {
            this.scmManager = (ScmManager)this.plexus.lookup(ScmManager.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new MojoFailureException("Unable to access scm manager", (Throwable)e);
        }
        this.baseFolder = new File(this.mapfile.getParentFile(), FilenameUtils.getBaseName((String)this.mapfile.getName()) + ".src");
        try {
            lines = FileUtils.readLines((File)this.mapfile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading mapfile", (Exception)e);
        }
        for (String line : lines) {
            MapEntry entry = MapfileUtils.parse(line);
            if (entry == null) continue;
            try {
                this.checkout(entry);
            }
            catch (ScmException e) {
                throw new MojoExecutionException("Error fetching SCM ", (Exception)((Object)e));
            }
        }
    }

    private void checkout(MapEntry entry) throws ScmException, MojoExecutionException {
        UpdateScmResult result;
        String scmModule = entry.getScmPath();
        if (scmModule == null) {
            scmModule = entry.getName();
        }
        String childName = scmModule.contains("/") ? scmModule.substring(scmModule.lastIndexOf(47) + 1) : scmModule;
        File workingDirectory = new File(this.baseFolder, childName);
        char separator = entry.getScmUrl().indexOf(124) != -1 ? (char)'|' : ':';
        ScmRepository scmRepository = this.scmManager.makeScmRepository("scm:" + this.scmSystem + entry.getScmUrl() + separator + scmModule);
        ScmTag version = new ScmTag(entry.getVersion());
        if (workingDirectory.exists()) {
            result = this.scmManager.update(scmRepository, new ScmFileSet(workingDirectory), (ScmVersion)version);
        } else if (workingDirectory.mkdirs()) {
            result = this.scmManager.checkOut(scmRepository, new ScmFileSet(workingDirectory), (ScmVersion)version);
        } else {
            throw new MojoExecutionException("Unable to create output folder for " + workingDirectory.getAbsolutePath());
        }
        if (!result.isSuccess()) {
            throw new MojoExecutionException("Command failed." + StringUtils.defaultString((String)result.getProviderMessage()));
        }
    }
}

