/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.plugin.artifactfilter;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.tycho.plugin.artifactfilter.ArtifactsFilter;

public class TransitivityFilter
implements ArtifactsFilter {
    private boolean excludeTransitive;
    private Set directDependencies;

    public TransitivityFilter(Set directDependencies, boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
        this.directDependencies = directDependencies;
    }

    public Set filter(Set artifacts, Log log) {
        HashSet<Artifact> result = artifacts;
        if (this.excludeTransitive) {
            log.debug((CharSequence)"Excluding Transitive Dependencies.");
            result = new HashSet<Artifact>();
            for (Artifact artifact : artifacts) {
                if (!this.artifactIsADirectDependency(artifact)) continue;
                result.add(artifact);
                log.debug((CharSequence)("Added: " + artifact));
            }
            log.debug((CharSequence)("Added " + result.size()));
        } else {
            log.debug((CharSequence)"Including Transitive Dependencies.");
        }
        return result;
    }

    public boolean artifactIsADirectDependency(Artifact artifact) {
        boolean result = false;
        for (Artifact dependency : this.directDependencies) {
            if (!dependency.getGroupId().equals(artifact.getGroupId()) || !dependency.getArtifactId().equals(artifact.getArtifactId())) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isExcludeTransitive() {
        return this.excludeTransitive;
    }

    public void setExcludeTransitive(boolean excludeTransitive) {
        this.excludeTransitive = excludeTransitive;
    }
}

