/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitest;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.tycho.BundleResolutionState;
import org.codehaus.tycho.MavenSessionUtils;
import org.codehaus.tycho.TargetPlatform;
import org.codehaus.tycho.TargetPlatformResolver;
import org.codehaus.tycho.TychoConstants;
import org.codehaus.tycho.maven.TychoMavenLifecycleParticipant;
import org.codehaus.tycho.osgitest.TestEclipseRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMojo
extends AbstractMojo {
    private static final String TEST_JUNIT = "org.junit";
    private static final String TEST_JUNIT4 = "org.junit4";
    private File work;
    private MavenProject project;
    private int debugPort;
    private List includes;
    private List excludes;
    private String test;
    private boolean skipExec;
    private boolean skip;
    private File testClassesDirectory;
    private boolean showEclipseLog;
    private File reportsDirectory;
    private File surefireProperties;
    private File devProperties;
    private Dependency[] dependencies;
    private BundleResolutionState bundleResolutionState;
    private MavenSession session;
    private boolean useUIHarness;
    private List<Artifact> pluginArtifacts;
    private String argLine;
    private int forkedProcessTimeoutInSeconds;
    private String testSuite;
    private String testClass;
    private PlexusContainer plexus;
    private Logger logger;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipExec) {
            this.getLog().info((CharSequence)"Skipping tests");
            return;
        }
        if (!"eclipse-test-plugin".equals(this.project.getPackaging())) {
            this.getLog().warn((CharSequence)("Unsupported packaging type " + this.project.getPackaging()));
            return;
        }
        this.bundleResolutionState = (BundleResolutionState)this.project.getContextValue(TychoConstants.CTX_BUNDLE_RESOLUTION_STATE);
        if (this.testSuite != null || this.testClass != null) {
            if (this.testSuite == null || this.testClass == null) {
                throw new MojoExecutionException("Both testSuite and testClass must be provided or both should be null");
            }
            BundleDescription desc = this.bundleResolutionState.getBundle(this.testSuite, "highest version");
            MavenProject suite = MavenSessionUtils.getMavenProject((MavenSession)this.session, (String)desc.getLocation());
            if (suite == null) {
                throw new MojoExecutionException("Cannot find test suite project with Bundle-SymbolicName " + this.testSuite);
            }
            if (!suite.equals((Object)this.project)) {
                this.getLog().info((CharSequence)("Not executing tests, testSuite=" + this.testSuite + " and project is not the testSuite"));
                return;
            }
        }
        TargetPlatformResolver platformResolver = TychoMavenLifecycleParticipant.lookupPlatformResolver((PlexusContainer)this.plexus, (MavenProject)this.project);
        platformResolver.setMavenProjects(this.session.getProjects());
        platformResolver.setLocalRepository(this.session.getLocalRepository());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (this.dependencies != null) {
            dependencies.addAll(Arrays.asList(this.dependencies));
        }
        dependencies.addAll(this.getTestDependencies());
        TargetPlatform targetPlatform = platformResolver.resolvePlatform(this.project, dependencies);
        if (targetPlatform == null) {
            throw new MojoExecutionException("Cannot determinate build target platform location -- not executing tests");
        }
        this.work.mkdirs();
        TestEclipseRuntime testRuntime = new TestEclipseRuntime();
        testRuntime.enableLogging(this.logger);
        testRuntime.setSourcePlatform(targetPlatform);
        testRuntime.setLocation(this.work);
        testRuntime.setPlexusContainer(this.plexus);
        testRuntime.initialize();
        BundleDescription bundle = this.bundleResolutionState.getBundleByLocation(this.project.getBasedir());
        String testFramework = this.getTestFramework(bundle);
        Set<File> surefireBundles = this.getSurefirePlugins(testFramework);
        for (File file : surefireBundles) {
            testRuntime.addBundle(file);
        }
        Set<File> testBundles = this.getTestBundles();
        for (File file : testBundles) {
            testRuntime.addBundle(file);
        }
        testRuntime.create();
        this.createDevProperties();
        this.createSurefireProperties(bundle, testFramework);
        this.reportsDirectory.mkdirs();
        String testBundle = null;
        boolean succeeded = this.runTest(testRuntime, testBundle, this.test);
        if (!succeeded) {
            throw new MojoFailureException("There are test failures.\n\nPlease refer to " + this.reportsDirectory + " for the individual test results.");
        }
        this.getLog().info((CharSequence)"All tests passed!");
    }

    private List<Dependency> getTestDependencies() {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        Dependency equinox = new Dependency();
        equinox.setArtifactId("org.eclipse.osgi");
        equinox.setType("eclipse-plugin");
        result.add(equinox);
        Dependency launcher = new Dependency();
        launcher.setArtifactId("org.eclipse.equinox.launcher");
        launcher.setType("eclipse-plugin");
        result.add(launcher);
        if (this.useUIHarness) {
            Dependency ideapp = new Dependency();
            ideapp.setArtifactId("org.eclipse.ui.ide.application");
            ideapp.setType("eclipse-plugin");
            result.add(ideapp);
        }
        return result;
    }

    private Set<File> getTestBundles() throws MojoExecutionException {
        LinkedHashSet<File> testBundles = new LinkedHashSet<File>();
        for (BundleDescription bundle : this.getReactorBundles()) {
            this.addBundle(testBundles, bundle);
            for (BundleDescription fragment : bundle.getFragments()) {
                this.addBundle(testBundles, fragment);
            }
        }
        return testBundles;
    }

    private void addBundle(Set<File> testBundles, BundleDescription bundle) {
        MavenProject project = MavenSessionUtils.getMavenProject((MavenSession)this.session, (String)bundle.getLocation());
        if ("eclipse-test-plugin".equals(project.getPackaging())) {
            testBundles.add(project.getBasedir());
        } else if (project.getArtifact().getFile() != null) {
            testBundles.add(project.getArtifact().getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSurefireProperties(BundleDescription bundle, String testFramework) throws MojoExecutionException {
        Properties p = new Properties();
        p.put("testpluginname", bundle.getSymbolicName());
        p.put("testclassesdirectory", this.testClassesDirectory.getAbsolutePath());
        p.put("reportsdirectory", this.reportsDirectory.getAbsolutePath());
        p.put("testrunner", this.getTestRunner(testFramework));
        if (this.testClass != null) {
            p.put("includes", this.testClass.replace('.', '/') + ".class");
        } else {
            p.put("includes", this.includes != null ? this.getIncludesExcludes(this.includes) : "**/Test*.class,**/*Test.class,**/*TestCase.class");
            p.put("excludes", this.excludes != null ? this.getIncludesExcludes(this.excludes) : "**/Abstract*Test.class,**/Abstract*TestCase.class,**/*$*");
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.surefireProperties));
            try {
                p.store(out, null);
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write test launcher properties file", (Exception)e);
        }
    }

    private String getTestRunner(String testFramework) {
        if (TEST_JUNIT.equals(testFramework)) {
            return "org.codehaus.tycho.surefire.junit.JUnitDirectoryTestSuite";
        }
        if (TEST_JUNIT4.equals(testFramework)) {
            return "org.apache.maven.surefire.junit4.JUnit4DirectoryTestSuite";
        }
        throw new IllegalArgumentException();
    }

    private String getTestFramework(BundleDescription bundle) throws MojoExecutionException {
        for (BundleDescription dependency : this.bundleResolutionState.getDependencies(bundle)) {
            if (TEST_JUNIT.equals(dependency.getSymbolicName())) {
                return TEST_JUNIT;
            }
            if (!TEST_JUNIT4.equals(dependency.getSymbolicName())) continue;
            return TEST_JUNIT4;
        }
        throw new MojoExecutionException("Could not determine test framework used by test bundle " + bundle.toString());
    }

    private String getIncludesExcludes(List<String> patterns) {
        StringBuilder sb = new StringBuilder();
        for (String pattern : patterns) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(pattern);
        }
        return sb.toString();
    }

    private boolean runTest(TestEclipseRuntime testRuntime, String testBundle, String className) throws MojoExecutionException {
        int result;
        try {
            String workspace = new File(this.work, "data").getAbsolutePath();
            FileUtils.deleteDirectory((String)workspace);
            Commandline cli = new Commandline();
            cli.setWorkingDirectory(this.project.getBasedir());
            String executable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            if (File.separatorChar == '\\') {
                executable = executable + ".exe";
            }
            cli.setExecutable(executable);
            if (this.debugPort > 0) {
                cli.addArguments(new String[]{"-Xdebug", "-Xrunjdwp:transport=dt_socket,address=" + this.debugPort + ",server=y,suspend=y"});
            }
            cli.addArguments(new String[]{"-Dosgi.noShutdown=false"});
            if (this.argLine != null) {
                Arg arg = cli.createArg();
                arg.setLine(this.argLine);
            }
            cli.addArguments(new String[]{"-jar", this.getEclipseLauncher(testRuntime).getAbsolutePath()});
            if (this.getLog().isDebugEnabled() || this.showEclipseLog) {
                cli.addArguments(new String[]{"-debug", "-consolelog"});
            }
            cli.addArguments(new String[]{"-data", workspace, "-dev", this.devProperties.toURI().toURL().toExternalForm(), "-install", testRuntime.getLocation().getAbsolutePath(), "-configuration", new File(this.work, "configuration").getAbsolutePath(), "-application", this.getTestApplication(testRuntime), "-testproperties", this.surefireProperties.getAbsolutePath()});
            this.getLog().info((CharSequence)("Expected eclipse log file: " + new File(workspace, ".metadata/.log").getCanonicalPath()));
            this.getLog().info((CharSequence)("Command line:\n\t" + cli.toString()));
            StreamConsumer out = new StreamConsumer(){

                public void consumeLine(String line) {
                    System.out.println(line);
                }
            };
            StreamConsumer err = new StreamConsumer(){

                public void consumeLine(String line) {
                    System.err.println(line);
                }
            };
            result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err, (int)this.forkedProcessTimeoutInSeconds);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while executing platform", e);
        }
        return result == 0;
    }

    private String getTestApplication(TestEclipseRuntime testRuntime) {
        if (this.useUIHarness) {
            BundleDescription systemBundle = testRuntime.getSystemBundle();
            Version osgiVersion = systemBundle.getVersion();
            if (osgiVersion.getMajor() == 3 && osgiVersion.getMinor() == 2) {
                return "org.codehaus.tycho.surefire.osgibooter.uitest32";
            }
            return "org.codehaus.tycho.surefire.osgibooter.uitest";
        }
        return "org.codehaus.tycho.surefire.osgibooter.headlesstest";
    }

    private File getEclipseLauncher(TestEclipseRuntime testRuntime) throws IOException {
        BundleDescription systemBundle = testRuntime.getSystemBundle();
        Version osgiVersion = systemBundle.getVersion();
        if (osgiVersion.getMajor() == 3 && osgiVersion.getMinor() == 2) {
            throw new UnsupportedOperationException();
        }
        BundleDescription launcher = testRuntime.getBundle("org.eclipse.equinox.launcher", "highest version");
        return new File(launcher.getLocation()).getCanonicalFile();
    }

    private Set<File> getSurefirePlugins(String testFramework) throws MojoExecutionException {
        String fragment;
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        if (TEST_JUNIT.equals(testFramework)) {
            fragment = "tycho-surefire-junit";
        } else if (TEST_JUNIT4.equals(testFramework)) {
            fragment = "tycho-surefire-junit4";
        } else {
            throw new IllegalArgumentException();
        }
        for (Artifact artifact : this.pluginArtifacts) {
            if (!"org.codehaus.tycho".equals(artifact.getGroupId()) || !"tycho-surefire-osgi-booter".equals(artifact.getArtifactId()) && !fragment.equals(artifact.getArtifactId())) continue;
            result.add(artifact.getFile());
        }
        if (result.size() != 2) {
            throw new MojoExecutionException("Unable to locate org.codehaus.tycho:tycho-surefire-osgi-booter and/or its fragments");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDevProperties() throws MojoExecutionException {
        Properties dev = new Properties();
        for (BundleDescription bundle : this.getReactorBundles()) {
            File file;
            MavenProject project = MavenSessionUtils.getMavenProject((MavenSession)this.session, (String)bundle.getLocation());
            if ("eclipse-test-plugin".equals(project.getPackaging())) {
                dev.put(bundle.getSymbolicName(), this.getBuildOutputDirectories(project));
                continue;
            }
            if (!"eclipse-plugin".equals(project.getPackaging()) || (file = project.getArtifact().getFile()) != null && !file.isDirectory()) continue;
            dev.put(bundle.getSymbolicName(), this.getBuildOutputDirectories(project));
        }
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.devProperties));
            try {
                dev.store(os, null);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't create osgi dev properties file", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBuildOutputDirectories(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        Build build = project.getBuild();
        sb.append(build.getOutputDirectory());
        sb.append(',').append(build.getTestOutputDirectory());
        Properties buildProperties = new Properties();
        File file = new File(project.getBasedir(), "build.properties");
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                buildProperties.load(is);
            }
            finally {
                is.close();
            }
            String OUTPUT = "output.";
            String SOURCE = "source.";
            for (String string : buildProperties.keySet()) {
                String[] classesDir = null;
                if (string.startsWith("output.") && !string.equals("output..")) {
                    classesDir = buildProperties.getProperty(string).split(",");
                } else if (string.startsWith("source.") && !string.equals("source..")) {
                    String fileName = string.substring("source.".length());
                    classesDir = new String[]{new File(project.getBuild().getDirectory()).getName() + "/" + fileName.substring(0, fileName.length() - 4) + "-classes"};
                }
                if (classesDir == null) continue;
                for (String dir : classesDir) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(dir);
                }
            }
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("Exception reading build.properties of " + project.getId()), (Throwable)e);
        }
        return sb.toString();
    }

    private Set<BundleDescription> getReactorBundles() {
        LinkedHashSet<BundleDescription> reactorBundles = new LinkedHashSet<BundleDescription>();
        reactorBundles.add(this.bundleResolutionState.getBundleByLocation(this.project.getBasedir()));
        Map basedirMap = MavenSessionUtils.getBasedirMap((MavenSession)this.session);
        for (BundleDescription desc : this.bundleResolutionState.getBundles()) {
            MavenProject project = (MavenProject)basedirMap.get(new File(desc.getLocation()));
            if (project == null) continue;
            reactorBundles.add(desc);
        }
        return reactorBundles;
    }
}

