/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.MavenSessionUtils;
import org.codehaus.tycho.TargetEnvironment;
import org.codehaus.tycho.TargetPlatformConfiguration;
import org.codehaus.tycho.TychoConstants;
import org.codehaus.tycho.eclipsepackaging.AbstractTychoPackagingMojo;
import org.codehaus.tycho.eclipsepackaging.VersioningHelper;
import org.codehaus.tycho.maven.DependenciesReader;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.PluginRef;
import org.codehaus.tycho.model.ProductConfiguration;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductExportMojo
extends AbstractTychoPackagingMojo {
    private File productConfigurationFile;
    private File p2inf;
    private File expandedProductFile;
    private ProductConfiguration productConfiguration;
    protected String qualifier;
    private TargetEnvironment[] environments;
    private DependenciesReader rcpDependencyReader;
    private boolean createProductArchive;
    private boolean includeSources;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File basedir;
        File productCfg;
        this.initializeProjectContext();
        if (this.productConfigurationFile == null && (productCfg = new File(basedir = this.project.getBasedir(), this.project.getArtifactId() + ".product")).exists()) {
            this.productConfigurationFile = productCfg;
        }
        if (this.productConfigurationFile == null) {
            throw new MojoExecutionException("Product configuration file not expecified");
        }
        if (!this.productConfigurationFile.exists()) {
            throw new MojoExecutionException("Product configuration file not found " + this.productConfigurationFile.getAbsolutePath());
        }
        try {
            this.getLog().debug((CharSequence)"Parsing productConfiguration");
            this.productConfiguration = ProductConfiguration.read((File)this.productConfigurationFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading product configuration file", (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing product configuration file", (Exception)((Object)e));
        }
        if (this.productConfiguration.includeLaunchers() && this.environments == null) {
            throw new MojoFailureException("Product includes native launcher but no target environment was specified");
        }
        for (TargetEnvironment environment : this.getEnvironments()) {
            File target = this.getTarget(environment);
            File targetEclipse = new File(target, "eclipse");
            targetEclipse.mkdirs();
            this.generateDotEclipseProduct(targetEclipse);
            this.generateConfigIni(environment, targetEclipse);
            this.includeRootFiles(environment, targetEclipse);
            if (this.productConfiguration.useFeatures()) {
                this.copyFeatures(environment, targetEclipse, this.productConfiguration.getFeatures());
            } else {
                this.copyPlugins(environment, targetEclipse, this.productConfiguration.getPlugins());
            }
            if (this.productConfiguration.includeLaunchers()) {
                this.copyExecutable(environment, targetEclipse);
            }
            if (!this.createProductArchive) continue;
            this.createProductArchive(environment, target);
        }
        Version productVersion = Version.parseVersion((String)this.productConfiguration.getVersion());
        productVersion = VersioningHelper.expandVersion(productVersion, this.qualifier);
        this.productConfiguration.setVersion(productVersion.toString());
        try {
            ProductConfiguration.write((ProductConfiguration)this.productConfiguration, (File)this.expandedProductFile);
            if (this.p2inf.canRead()) {
                FileUtils.copyFile((File)this.p2inf, (File)new File(this.expandedProductFile.getParentFile(), this.p2inf.getName()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing expanded product configuration file", (Exception)e);
        }
        if (!this.createProductArchive || this.environments != null) {
            this.project.getArtifact().setFile(this.expandedProductFile);
        }
    }

    private TargetEnvironment[] getEnvironments() {
        if (this.environments != null) {
            return this.environments;
        }
        TargetPlatformConfiguration configuration = (TargetPlatformConfiguration)this.project.getContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION);
        return new TargetEnvironment[]{configuration.getEnvironment()};
    }

    private File getTarget(TargetEnvironment environment) {
        File target = this.environments == null ? new File(this.project.getBuild().getDirectory(), "product") : new File(this.project.getBuild().getDirectory(), this.toString(environment));
        target.mkdirs();
        return target;
    }

    private String toString(TargetEnvironment environment) {
        StringBuilder sb = new StringBuilder();
        sb.append(environment.getOs()).append('.').append(environment.getWs()).append('.').append(environment.getArch());
        if (environment.getNl() != null) {
            sb.append('.').append(environment.getNl());
        }
        return sb.toString();
    }

    @Override
    protected void initializeProjectContext() {
        this.bundleResolutionState = this.rcpDependencyReader.getBundleResolutionState(this.session, this.project);
        this.featureResolutionState = this.rcpDependencyReader.getFeatureResolutionState(this.session, this.project);
    }

    private void includeRootFiles(TargetEnvironment environment, File target) throws MojoExecutionException {
        Properties properties = this.project.getProperties();
        String generatedBuildProperties = properties.getProperty("generatedBuildProperties");
        this.getLog().debug((CharSequence)("includeRootFiles from " + generatedBuildProperties));
        if (generatedBuildProperties != null) {
            Properties rootProperties = new Properties();
            try {
                rootProperties.load(new FileInputStream(new File(this.project.getBasedir(), generatedBuildProperties)));
                if (!rootProperties.isEmpty()) {
                    String config = this.getConfig(environment);
                    String root = "root";
                    String rootConfig = "root." + config;
                    String rootFolder = "root.folder.";
                    String rootConfigFolder = "root." + config + ".folder.";
                    Set<Map.Entry<Object, Object>> entrySet = rootProperties.entrySet();
                    for (Map.Entry<Object, Object> entry : entrySet) {
                        String subFolder;
                        String key = ((String)entry.getKey()).trim();
                        if (root.equals(key)) {
                            this.handleRootEntry(target, (String)entry.getValue(), null);
                            continue;
                        }
                        if (rootConfig.equals(key)) {
                            this.handleRootEntry(target, (String)entry.getValue(), null);
                            continue;
                        }
                        if (key.startsWith(rootFolder)) {
                            subFolder = ((String)entry.getKey()).substring(rootFolder.length());
                            this.handleRootEntry(target, (String)entry.getValue(), subFolder);
                            continue;
                        }
                        if (key.startsWith(rootConfigFolder)) {
                            subFolder = ((String)entry.getKey()).substring(rootConfigFolder.length());
                            this.handleRootEntry(target, (String)entry.getValue(), subFolder);
                            continue;
                        }
                        this.getLog().debug((CharSequence)("ignoring property " + (String)entry.getKey() + "=" + (String)entry.getValue()));
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Error including root files for product", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error including root files for product", (Exception)e);
            }
        }
    }

    private void handleRootEntry(File target, String rootFileEntries, String subFolder) {
        StringTokenizer t = new StringTokenizer(rootFileEntries, ",");
        File destination = target;
        if (subFolder != null) {
            destination = new File(target, subFolder);
        }
        while (t.hasMoreTokens()) {
            String rootFileEntry = t.nextToken();
            String fileName = rootFileEntry.trim();
            boolean isAbsolute = false;
            if (fileName.startsWith("absolute:")) {
                isAbsolute = true;
                fileName = fileName.substring("absolute:".length());
            }
            if (fileName.startsWith("file")) {
                fileName = fileName.substring("file:".length());
            }
            File source = null;
            source = !isAbsolute ? new File(this.project.getBasedir(), fileName) : new File(fileName);
            if (source.isFile()) {
                try {
                    FileUtils.copyFileToDirectory((File)source, (File)destination);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (source.isDirectory()) {
                try {
                    FileUtils.copyDirectoryToDirectory((File)source, (File)destination);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.getLog().warn((CharSequence)("Skipping root entry " + rootFileEntry));
        }
    }

    private String getConfig(TargetEnvironment environment) {
        String os = environment.getOs();
        String ws = environment.getWs();
        String arch = environment.getArch();
        StringBuffer config = new StringBuffer(ws).append(".").append(os).append(".").append(arch);
        return config.toString();
    }

    private void createProductArchive(TargetEnvironment environment, File target) throws MojoExecutionException {
        ZipArchiver zipper;
        try {
            zipper = (ZipArchiver)this.plexus.lookup(ZipArchiver.ROLE, "zip");
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to resolve ZipArchiver", (Exception)((Object)e));
        }
        String classifier = this.toString(environment);
        StringBuilder filename = new StringBuilder(this.project.getBuild().getFinalName());
        if (this.environments != null) {
            filename.append('-').append(classifier);
        }
        filename.append(".zip");
        File destFile = new File(this.project.getBuild().getDirectory(), filename.toString());
        try {
            zipper.addDirectory(target);
            zipper.setDestFile(destFile);
            zipper.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packing product", e);
        }
        if (this.environments == null) {
            this.project.getArtifact().setFile(destFile);
        } else {
            this.projectHelper.attachArtifact(this.project, destFile, classifier);
        }
    }

    private boolean isEclipse32Platform() throws MojoFailureException {
        BundleDescription runtime = this.bundleResolutionState.getSystemBundle();
        if (runtime == null) {
            throw new MojoFailureException("Could not obtain system bundle");
        }
        if (!"org.eclipse.osgi".equals(runtime.getSymbolicName())) {
            throw new MojoFailureException("Unsupported OSGi platform " + runtime.getSymbolicName());
        }
        Version osgiVersion = runtime.getVersion();
        return osgiVersion.getMajor() == 3 && osgiVersion.getMinor() == 2;
    }

    private void generateDotEclipseProduct(File target) throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Generating .eclipseproduct");
        Properties props = new Properties();
        this.setPropertyIfNotNull(props, "version", this.productConfiguration.getVersion());
        this.setPropertyIfNotNull(props, "name", this.productConfiguration.getName());
        this.setPropertyIfNotNull(props, "id", this.productConfiguration.getId());
        File eclipseproduct = new File(target, ".eclipseproduct");
        try {
            FileOutputStream fos = new FileOutputStream(eclipseproduct);
            props.store(fos, "Eclipse Product File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private void generateConfigIni(TargetEnvironment environment, File target) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Generating config.ini");
        Properties props = new Properties();
        String id = this.productConfiguration.getId();
        if (id != null) {
            String splash = id.split("\\.")[0];
            this.setPropertyIfNotNull(props, "osgi.splashPath", "platform:/base/plugins/" + splash);
        }
        this.setPropertyIfNotNull(props, "eclipse.product", id);
        this.setPropertyIfNotNull(props, "osgi.bundles.defaultStartLevel", "4");
        if (this.productConfiguration.useFeatures()) {
            this.setPropertyIfNotNull(props, "osgi.bundles", this.getFeaturesOsgiBundles());
        } else {
            this.setPropertyIfNotNull(props, "osgi.bundles", this.getPluginsOsgiBundles(environment));
        }
        File configsFolder = new File(target, "configuration");
        configsFolder.mkdirs();
        File configIni = new File(configsFolder, "config.ini");
        try {
            FileOutputStream fos = new FileOutputStream(configIni);
            props.store(fos, "Product Runtime Configuration File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private String getFeaturesOsgiBundles() {
        return "org.eclipse.equinox.common@2:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start";
    }

    private String getPluginsOsgiBundles(TargetEnvironment environment) throws MojoFailureException {
        List plugins = this.productConfiguration.getPlugins();
        StringBuilder buf = new StringBuilder(plugins.size() * 10);
        for (PluginRef plugin : plugins) {
            if ("org.eclipse.osgi".equals(plugin.getId())) continue;
            if (buf.length() != 0) {
                buf.append(',');
            }
            buf.append(plugin.getId());
            if ("org.eclipse.core.runtime".equals(plugin.getId())) {
                buf.append("@start");
            }
            if (!this.isEclipse32Platform() || !"org.eclipse.equinox.common".equals(plugin.getId())) continue;
            buf.append("@2:start");
        }
        if (!this.isEclipse32Platform()) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            String os = environment.getOs();
            String ws = environment.getWs();
            String arch = environment.getArch();
            buf.append("org.eclipse.equinox.launcher,");
            buf.append("org.eclipse.equinox.launcher." + ws + "." + os + "." + arch);
        }
        return buf.toString();
    }

    private void copyFeatures(TargetEnvironment environment, File target, List<Feature.FeatureRef> features) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("copying " + features.size() + " features "));
        for (Feature.FeatureRef feature : features) {
            this.copyFeature(environment, target, feature);
        }
    }

    private void copyFeature(TargetEnvironment environment, File target, Feature.FeatureRef feature) throws MojoExecutionException {
        de.schlichtherle.io.File source;
        String featureVersion;
        String featureId = feature.getId();
        FeatureDescription featureDescription = this.featureResolutionState.getFeature(featureId, featureVersion = feature.getVersion());
        if (featureDescription == null) {
            throw new MojoExecutionException("Unable to resolve feature " + featureId + "_" + featureVersion);
        }
        featureVersion = VersioningHelper.getExpandedVersion(this.session, featureDescription);
        Feature featureRef = featureDescription.getFeature();
        MavenProject project = MavenSessionUtils.getMavenProject((MavenSession)this.session, (File)featureDescription.getLocation());
        if (project == null) {
            this.getLog().debug((CharSequence)("feature = bundle: " + featureDescription.getLocation()));
            source = new de.schlichtherle.io.File(featureDescription.getLocation());
        } else {
            this.getLog().debug((CharSequence)("feature = project: " + project.getArtifact()));
            source = new de.schlichtherle.io.File(project.getArtifact().getFile());
        }
        File targetFolder = new File(target, "features/" + featureRef.getId() + "_" + featureVersion);
        targetFolder.mkdirs();
        source.copyAllTo(targetFolder);
        List featureRefs = featureRef.getIncludedFeatures();
        for (Feature.FeatureRef fRef : featureRefs) {
            this.copyFeature(environment, target, fRef);
        }
        List pluginRefs = featureRef.getPlugins();
        for (PluginRef pluginRef : pluginRefs) {
            if (!this.matchTargetEnvironment(environment, pluginRef)) continue;
            this.copyPlugin(target, pluginRef);
        }
    }

    private boolean matchTargetEnvironment(TargetEnvironment environment, PluginRef pluginRef) {
        String pluginOs = pluginRef.getOs();
        String pluginWs = pluginRef.getWs();
        String pluginArch = pluginRef.getArch();
        if (this.environments == null) {
            return pluginOs == null && pluginWs == null && pluginArch == null;
        }
        String os = environment.getOs();
        String ws = environment.getWs();
        String arch = environment.getArch();
        return !(pluginOs != null && !os.equals(pluginOs) || pluginWs != null && !ws.equals(pluginWs) || pluginArch != null && !arch.equals(pluginArch));
    }

    private void copyPlugins(TargetEnvironment environment, File pluginsFolder, Collection<PluginRef> plugins) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("copying " + plugins.size() + " plugins "));
        for (PluginRef plugin : plugins) {
            this.copyPlugin(pluginsFolder, plugin);
        }
        if (!this.isEclipse32Platform()) {
            this.copyPlugin(pluginsFolder, this.newPluginRef("org.eclipse.equinox.launcher", null, false));
            String os = environment.getOs();
            String ws = environment.getWs();
            String arch = environment.getArch();
            if ("macosx".equals(os)) {
                this.copyPlugin(pluginsFolder, this.newPluginRef("org.eclipse.equinox.launcher." + ws + "." + os, null, false));
            } else {
                this.copyPlugin(pluginsFolder, this.newPluginRef("org.eclipse.equinox.launcher." + ws + "." + os + "." + arch, null, false));
            }
        }
    }

    private PluginRef newPluginRef(String id, String version, boolean unpack) {
        PluginRef plugin = new PluginRef("plugin");
        plugin.setId(id);
        if (version != null) {
            plugin.setVersion(version);
        }
        plugin.setUnpack(unpack);
        return plugin;
    }

    private String copyPlugin(File target, PluginRef plugin) throws MojoExecutionException {
        BundleDescription bundle;
        String bundleId = plugin.getId();
        String bundleVersion = plugin.getVersion();
        this.getLog().debug((CharSequence)("Copying plugin " + bundleId + "_" + bundleVersion));
        if (bundleVersion == null || "0.0.0".equals(bundleVersion)) {
            bundleVersion = "highest version";
        }
        if ((bundle = this.bundleResolutionState.getBundle(bundleId, bundleVersion)) == null) {
            throw new MojoExecutionException("Plugin '" + bundleId + "_" + bundleVersion + "' not found!");
        }
        String sourceBundle = this.bundleResolutionState.getManifestAttribute(bundle, "Eclipse-SourceBundle");
        if (!this.includeSources && sourceBundle != null && sourceBundle.trim().length() > 0) {
            this.getLog().debug((CharSequence)("Ignoring source bundle " + bundleId + "_" + bundleVersion));
            return null;
        }
        MavenProject bundleProject = MavenSessionUtils.getMavenProject((MavenSession)this.session, (String)bundle.getLocation());
        File source = bundleProject != null ? bundleProject.getArtifact().getFile() : new File(bundle.getLocation());
        bundleVersion = VersioningHelper.getExpandedVersion(this.session, bundle);
        File pluginsFolder = new File(target, "plugins");
        File targetFolder = new File(pluginsFolder, bundleId + "_" + bundleVersion + ".jar");
        if (source.isDirectory()) {
            this.copyToDirectory(source, pluginsFolder);
        } else if (plugin.isUnpack()) {
            String path = targetFolder.getAbsolutePath();
            path = path.substring(0, path.length() - 4);
            targetFolder = new File(path);
            targetFolder.mkdirs();
            new de.schlichtherle.io.File(source).copyAllTo(targetFolder);
        } else {
            this.copyToFile(source, targetFolder);
        }
        return bundleVersion;
    }

    private void copyToFile(File source, File target) throws MojoExecutionException {
        try {
            target.getParentFile().mkdirs();
            if (source.isFile()) {
                FileUtils.copyFile((File)source, (File)target);
            } else if (source.isDirectory()) {
                FileUtils.copyDirectory((File)source, (File)target);
            } else {
                this.getLog().warn((CharSequence)("Skipping bundle " + source.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy " + source.getName(), (Exception)e);
        }
    }

    private void copyToDirectory(File source, File targetFolder) throws MojoExecutionException {
        try {
            if (source.isFile()) {
                FileUtils.copyFileToDirectory((File)source, (File)targetFolder);
            } else if (source.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)source, (File)targetFolder);
            } else {
                this.getLog().warn((CharSequence)("Skipping bundle " + source.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy " + source.getName(), (Exception)e);
        }
    }

    private void copyExecutable(TargetEnvironment environment, File target) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"Creating launcher");
        FeatureDescription feature = this.isEclipse32Platform() ? this.featureResolutionState.getFeature("org.eclipse.platform.launchers", null) : this.featureResolutionState.getFeature("org.eclipse.equinox.executable", null);
        if (feature == null) {
            throw new MojoExecutionException("RPC delta feature not found!");
        }
        File location = feature.getLocation();
        String os = environment.getOs();
        String ws = environment.getWs();
        String arch = environment.getArch();
        File osLauncher = new File(location, "bin/" + ws + "/" + os + "/" + arch);
        try {
            IOFileFilter eclipsecFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"eclipsec"));
            FileUtils.copyDirectory((File)osLauncher, (File)target, (FileFilter)eclipsecFilter);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy launcher executable", (Exception)e);
        }
        File launcher = this.getLauncher(environment, target);
        try {
            this.getLog().debug((CharSequence)"running chmod");
            ArchiveEntryUtils.chmod((File)launcher, (int)493, null);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to make launcher being executable", (Exception)((Object)e));
        }
        if (this.productConfiguration.getLauncher() != null && this.productConfiguration.getLauncher().getName() != null) {
            String launcherName;
            String newName = launcherName = this.productConfiguration.getLauncher().getName();
            if ("win32".equals(os)) {
                String extension = FilenameUtils.getExtension((String)launcher.getAbsolutePath());
                newName = launcherName + "." + extension;
            } else if ("macosx".equals(os)) {
                newName = "eclipse";
            }
            this.getLog().debug((CharSequence)("Renaming launcher to " + newName));
            launcher.renameTo(new File(launcher.getParentFile(), newName));
            if ("macosx".equals(os)) {
                newName = launcherName + ".app";
                this.getLog().debug((CharSequence)("Renaming Eclipse.app to " + newName));
                File eclipseApp = new File(target, "Eclipse.app");
                File renamedEclipseApp = new File(eclipseApp.getParentFile(), newName);
                eclipseApp.renameTo(renamedEclipseApp);
            }
        }
        if (this.isEclipse32Platform()) {
            File startUpJar = new File(location, "bin/startup.jar");
            try {
                FileUtils.copyFileToDirectory((File)startUpJar, (File)target);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy startup.jar executable", (Exception)e);
            }
        }
    }

    private File getLauncher(TargetEnvironment environment, File target) throws MojoExecutionException {
        String os = environment.getOs();
        if ("win32".equals(os)) {
            return new File(target, "launcher.exe");
        }
        if ("linux".equals(os) || "solaris".equals(os) || "hpux".equals(os) || "aix".equals(os)) {
            return new File(target, "launcher");
        }
        if ("macosx".equals(os)) {
            return new File(target, "Eclipse.app/Contents/MacOS/launcher");
        }
        throw new MojoExecutionException("Unexpected OS: " + os);
    }

    private void setPropertyIfNotNull(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }
}

