/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.tycho.MavenSessionUtils;
import org.codehaus.tycho.TychoConstants;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

public class VersioningHelper {
    private static final String QUALIFIER = "qualifier";

    public static boolean isSnapshotVersion(Version version) {
        return QUALIFIER.equals(version.getQualifier());
    }

    public static Version expandVersion(Version version, String qualifier) {
        if (VersioningHelper.isSnapshotVersion(version)) {
            return new Version(version.getMajor(), version.getMinor(), version.getMicro(), qualifier);
        }
        return version;
    }

    public static void setExpandedVersion(MavenSession session, File location, String version) {
        MavenProject project = MavenSessionUtils.getMavenProject((MavenSession)session, (File)location);
        if (project == null) {
            throw new IllegalArgumentException(location.getAbsolutePath() + " does not correspond to a reactor project basedir.");
        }
        project.setContextValue(TychoConstants.CTX_EXPANDED_VERSION, (Object)version);
    }

    public static void setExpandedVersion(MavenSession session, String location, String version) {
        VersioningHelper.setExpandedVersion(session, new File(location), version);
    }

    public static String getMavenBaseVersion(MavenSession session, BundleDescription bundle) {
        MavenProject mavenProject = MavenSessionUtils.getMavenProject((MavenSession)session, (String)bundle.getLocation());
        if (mavenProject != null) {
            return mavenProject.getVersion();
        }
        return null;
    }

    public static String getExpandedVersion(MavenSession session, BundleDescription bundle) {
        String version;
        MavenProject project = MavenSessionUtils.getMavenProject((MavenSession)session, (String)bundle.getLocation());
        if (project != null && (version = (String)project.getContextValue(TychoConstants.CTX_EXPANDED_VERSION)) != null) {
            return version;
        }
        return bundle.getVersion().toString();
    }

    public static String getExpandedVersion(MavenSession session, FeatureDescription feature) {
        String version;
        MavenProject project = MavenSessionUtils.getMavenProject((MavenSession)session, (File)feature.getLocation());
        if (project != null && (version = (String)project.getContextValue(TychoConstants.CTX_EXPANDED_VERSION)) != null) {
            return version;
        }
        return feature.getVersion().toString();
    }
}

