/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.tycho.eclipsepackaging.AbstractTychoPackagingMojo;
import org.codehaus.tycho.eclipsepackaging.Util;
import org.codehaus.tycho.eclipsepackaging.VersionExpander;
import org.codehaus.tycho.eclipsepackaging.product.Plugin;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.PluginRef;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageFeatureMojo
extends AbstractTychoPackagingMojo {
    private static final int KBYTE = 1024;
    private static final String GENERATE_FEATURE = "generate.feature@";
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File outputDirectory;
    private File basedir;
    private String finalName;
    protected String qualifier;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initializeProjectContext();
        Properties props = new Properties();
        try {
            FileInputStream is = new FileInputStream(new File(this.basedir, "build.properties"));
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading build properties", (Exception)e);
        }
        this.outputDirectory.mkdirs();
        File featureXml = new File(this.outputDirectory, "feature.xml");
        try {
            this.updateFeatureXml(featureXml);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error updating feature.xml", (Exception)e);
        }
        File outputJar = new File(this.outputDirectory, this.finalName + ".jar");
        outputJar.getParentFile().mkdirs();
        String[] binIncludes = props.getProperty("bin.includes").split(",");
        String[] files = Util.getIncludedFiles(this.basedir, binIncludes);
        MavenArchiver archiver = new MavenArchiver();
        JarArchiver jarArchiver = this.getJarArchiver();
        archiver.setArchiver(jarArchiver);
        archiver.setOutputFile(outputJar);
        jarArchiver.setDestFile(outputJar);
        try {
            for (int i = 0; i < files.length; ++i) {
                File f;
                String fileName = files[i];
                File file = f = "feature.xml".equals(fileName) ? featureXml : new File(this.basedir, fileName);
                if (f.isDirectory()) continue;
                jarArchiver.addFile(f, fileName);
            }
            archiver.createArchive(this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating feature package", e);
        }
        this.project.getArtifact().setFile(outputJar);
        this.attachP2Metadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFeatureXml(File featureXml) throws MojoExecutionException, IOException {
        FeatureDescription featureDesc = this.featureResolutionState.getFeatureByLocation(this.project.getBasedir());
        Feature feature = new Feature(featureDesc.getFeature());
        feature.setMavenGroupId(this.project.getGroupId());
        feature.setMavenBaseVersion(this.project.getVersion());
        if (VersionExpander.isSnapshotVersion(featureDesc.getVersion())) {
            Version version = VersionExpander.expandVersion(featureDesc.getVersion(), this.qualifier);
            feature.setVersion(version.toString());
            VersionExpander.setExpandedVersion(this.tychoSession, featureDesc.getLocation(), version.toString());
        }
        for (PluginRef pluginRef : feature.getPlugins()) {
            String pluginBaseVersion;
            BundleDescription bundle;
            String bundleId = pluginRef.getId();
            String bundleVersion = pluginRef.getVersion();
            if ("0.0.0".equals(bundleVersion)) {
                bundleVersion = "highest version";
            }
            if ((bundle = this.bundleResolutionState.getBundle(bundleId, bundleVersion)) == null) {
                this.getLog().warn((CharSequence)(this.project.getId() + " referenced uknown bundle " + bundleId + ":" + bundleVersion));
                continue;
            }
            MavenProject bundleProject = this.tychoSession.getMavenProject(bundle.getLocation());
            String pluginGroupId = null;
            pluginGroupId = bundleProject != null ? bundleProject.getGroupId() : this.bundleResolutionState.getManifestAttribute(bundle, "MavenArtifact-GroupId");
            if (pluginGroupId != null) {
                pluginRef.setMavenGroupId(pluginGroupId);
            }
            if ((pluginBaseVersion = VersionExpander.getMavenBaseVersion(this.tychoSession, bundle)) != null) {
                pluginRef.setMavenBaseVersion(pluginBaseVersion);
            }
            pluginRef.setVersion(VersionExpander.getExpandedVersion(this.tychoSession, bundle));
            File file = bundleProject != null ? bundleProject.getArtifact().getFile() : new File(bundle.getLocation());
            long downloadSize = 0L;
            long installSize = 0L;
            if (file.isFile()) {
                JarFile jar = new JarFile(file);
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        long entrySize = entry.getSize();
                        if (entrySize <= 0L) continue;
                        installSize += entrySize;
                    }
                }
                finally {
                    jar.close();
                }
                downloadSize = file.length();
            } else {
                this.getLog().info((CharSequence)("Download/install size is not calculated for directory based bundle " + bundleId));
            }
            pluginRef.setDownloadSide(downloadSize / 1024L);
            pluginRef.setInstallSize(installSize / 1024L);
        }
        for (Feature.FeatureRef ref : feature.getIncludedFeatures()) {
            String refBaseVersion;
            String refVersion = ref.getVersion();
            String refId = ref.getId();
            FeatureDescription refDescription = this.featureResolutionState.getFeature(refId, refVersion);
            if (refDescription == null) {
                this.getLog().warn((CharSequence)(this.project.getId() + " referenced uknown feature " + refId + ":" + refVersion));
                continue;
            }
            String refGroupId = refDescription.getMavenGroupId();
            if (refGroupId != null) {
                ref.setMavenGroupId(refGroupId);
            }
            if ((refBaseVersion = refDescription.getMavenBaseVersion()) == null) continue;
            ref.setMavenBaseVersion(refBaseVersion);
        }
        Feature.write((Feature)feature, (File)featureXml);
    }

    private void generateSources(Properties props) throws MojoExecutionException {
        boolean individualSourceBundle = Boolean.parseBoolean(props.getProperty("individualSourceBundles"));
        Set<Object> keys = props.keySet();
        for (Object keyObj : keys) {
            String key = keyObj.toString();
            if (!key.toString().startsWith(GENERATE_FEATURE)) continue;
            String baseFeature = props.getProperty(key);
            String sourceFeature = key.substring(GENERATE_FEATURE.length());
            if (individualSourceBundle) continue;
            this.generateSourceFeature(baseFeature, sourceFeature);
        }
    }

    private JarArchiver getJarArchiver() throws MojoExecutionException {
        try {
            JarArchiver jarArchiver = (JarArchiver)this.plexus.lookup(JarArchiver.ROLE, "jar");
            return jarArchiver;
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to get JarArchiver", (Exception)((Object)e));
        }
    }

    private void generateSourceFeature(String baseFeatureId, String sourceFeature) throws MojoExecutionException {
        FeatureDescription baseFeature = this.featureResolutionState.getFeature(baseFeatureId, "highest version");
        if (baseFeature == null) {
            this.getLog().warn((CharSequence)("Base feature not found: " + baseFeatureId));
            return;
        }
        String version = baseFeature.getVersion().toString();
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        plugins.add(new Plugin(sourceFeature, version));
        this.generateSourceFeature(sourceFeature, version, plugins);
    }

    private void generateSourceFeature(String featureId, String featureVersion, List<Plugin> plugins) throws MojoExecutionException {
        File target = new File(this.outputDirectory, featureId);
        target.mkdirs();
        File featureFile = new File(target, "feature.xml");
        try {
            FileWriter fw = new FileWriter(featureFile);
            fw.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n');
            fw.append("<feature id=\"" + featureId + "\" version=\"" + featureVersion + "\" primary=\"false\" >").append('\n');
            for (Plugin plugin : plugins) {
                fw.append("\t<plugin id=\"" + plugin.getId() + "\" version=\"" + plugin.getVersion() + "\" />").append('\n');
            }
            fw.append("</feature>").append('\n');
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating feature.xml for " + featureId + "_" + featureVersion, (Exception)e);
        }
        File outputJar = new File(this.outputDirectory, featureId + "-" + featureVersion + ".jar");
        JarArchiver jarArchiver = this.getJarArchiver();
        jarArchiver.setDestFile(outputJar);
        try {
            jarArchiver.addFile(featureFile, "feature.xml");
            jarArchiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packing source feature " + featureId + "_" + featureVersion, e);
        }
    }
}

