/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.jar.JarSignMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.gzip.GZipCompressor;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.tycho.eclipsepackaging.pack200.Pack200Archiver;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.IFeatureRef;
import org.codehaus.tycho.model.PluginRef;
import org.codehaus.tycho.model.UpdateSite;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSiteMojo
extends AbstractMojo
implements Contextualizable {
    private OsgiState state;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteRepositories;
    private File target;
    private File features;
    private File plugins;
    private File basedir;
    private PlexusContainer plexus;
    private boolean inlineArchives;
    protected MavenProject project;
    private boolean sign;
    private File keystore;
    private String storepass;
    private String alias;
    private String keypass;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.target.mkdirs();
        try {
            UpdateSite site = UpdateSite.read((File)new File(this.basedir, "site.xml"));
            Map archives = site.getArchives();
            for (UpdateSite.FeatureRef feature : site.getFeatures()) {
                this.packageFeature((IFeatureRef)feature, archives, site.isPack200());
            }
            if (this.inlineArchives) {
                site.removeArchives();
            }
            File file = new File(this.target, "site.xml");
            UpdateSite.write((UpdateSite)site, (File)file);
            this.project.getArtifact().setFile(file);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void packageFeature(IFeatureRef featureRef, Map<String, String> archives, boolean isPack200) throws Exception {
        FeatureDescription feature;
        String featureId = featureRef.getId();
        String featureVersion = featureRef.getVersion();
        if ("0.0.0".equals(featureVersion)) {
            featureVersion = "highest version";
        }
        if ((feature = this.state.getFeatureDescription(featureId, featureVersion)) == null) {
            throw new ArtifactResolutionException("Feature " + featureId + " not found", "", featureId, featureVersion, "eclipse-feature", null, null);
        }
        String artifactId = feature.getId();
        String version = this.state.getFinalVersion(feature).toString();
        String url = "features/" + artifactId + "_" + version + ".jar";
        File outputJar = new File(this.target, url);
        if (!outputJar.canRead()) {
            MavenProject featureProject = this.state.getMavenProject(feature);
            Properties props = new Properties();
            if (featureProject != null) {
                props.load(new FileInputStream(new File(featureProject.getBasedir(), "build.properties")));
                this.packageIncludedArtifacts(feature, props, archives, isPack200);
                FileUtils.copyFile((File)featureProject.getArtifact().getFile(), (File)outputJar);
                if (this.sign) {
                    this.signJar(outputJar);
                }
                if (isPack200) {
                    this.shipPack200(outputJar, url);
                }
            } else {
                this.packageIncludedArtifacts(feature, props, archives, isPack200);
                File src = feature.getLocation();
                if (src.isDirectory()) {
                    this.packDir(src, outputJar);
                } else {
                    FileUtils.copyFile((File)src, (File)outputJar);
                }
            }
        }
        if (featureRef instanceof UpdateSite.FeatureRef) {
            ((UpdateSite.FeatureRef)featureRef).setUrl(url);
        }
        featureRef.setVersion(version);
    }

    private void packageIncludedArtifacts(FeatureDescription feature, Properties buildProperties, Map<String, String> archives, boolean isPack200) throws Exception {
        List plugins = feature.getFeature().getPlugins();
        for (PluginRef plugin : plugins) {
            String pluginId = plugin.getId();
            String key = "generate.plugin@" + pluginId;
            if (buildProperties.containsKey(key)) {
                ArrayList<PluginRef> filteredPlugins = new ArrayList<PluginRef>(plugins);
                filteredPlugins.remove(plugin);
                this.generateSourcePlugin(pluginId, filteredPlugins, feature.getVersion().toString(), isPack200);
                continue;
            }
            this.packagePlugin(plugin, archives, isPack200);
        }
        for (Feature.FeatureRef includedRef : feature.getFeature().getIncludedFeatures()) {
            this.packageFeature((IFeatureRef)includedRef, archives, isPack200);
        }
    }

    private void packDir(File sourceDir, File targetZip) throws MojoExecutionException {
        ZipArchiver archiver;
        try {
            archiver = (ZipArchiver)this.plexus.lookup(ZipArchiver.ROLE, "zip");
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Unable to resolve ZipArchiver", (Exception)((Object)e));
        }
        archiver.setDestFile(targetZip);
        try {
            archiver.addDirectory(sourceDir);
            archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error packing zip", e);
        }
    }

    private void generateSourcePlugin(String artifactId, List<PluginRef> plugins, String version, boolean isPack200) throws Exception {
        File pluginFolder = new File(this.plugins, artifactId);
        pluginFolder.mkdirs();
        File pluginFile = new File(pluginFolder, "plugin.xml");
        FileWriter fw = new FileWriter(pluginFile);
        fw.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n');
        fw.append("<?eclipse version=\"3.0\"?>").append('\n');
        fw.append("<plugin>").append('\n');
        fw.append("\t<extension point = \"org.eclipse.pde.core.source\">").append('\n');
        fw.append("\t\t<location path=\"src\" />").append('\n');
        fw.append("\t</extension>").append('\n');
        fw.append("</plugin>").append('\n');
        fw.flush();
        fw.close();
        for (PluginRef pluginRef : plugins) {
            String bundleId = pluginRef.getId();
            String bundleVersion = this.getPluginVersion(pluginRef);
            Artifact bundleSourceArtifact = this.getSourceBundle(bundleId, bundleVersion);
            File pluginSrc = new File(pluginFolder, "src/" + bundleId + "_" + bundleSourceArtifact.getVersion() + "/src.zip");
            FileUtils.copyFile((File)bundleSourceArtifact.getFile(), (File)pluginSrc);
        }
        String url = "plugins/" + artifactId + "_" + version + ".jar";
        File outputJar = new File(this.target, url);
        JarArchiver jarArchiver = (JarArchiver)this.plexus.lookup(JarArchiver.ROLE, "jar");
        jarArchiver.setDestFile(outputJar);
        jarArchiver.addDirectory(pluginFolder);
        jarArchiver.createArchive();
        if (this.sign) {
            this.signJar(outputJar);
        }
        if (isPack200) {
            this.shipPack200(outputJar, url);
        }
    }

    private Artifact getSourceBundle(String bundleId, String bundleVersion) throws MojoExecutionException, ArtifactResolutionException, ArtifactNotFoundException {
        BundleDescription bundle = this.state.getBundleDescription(bundleId, bundleVersion);
        if (bundle == null) {
            throw new MojoExecutionException("Can't find bundle " + bundleId);
        }
        MavenProject bundleProject = this.state.getMavenProject(bundle);
        Artifact bundleSourceArtifact = this.artifactFactory.createArtifactWithClassifier(bundleProject.getGroupId(), bundleProject.getArtifactId(), bundleProject.getVersion(), "jar", "sources");
        this.resolver.resolve(bundleSourceArtifact, this.remoteRepositories, this.localRepository);
        return bundleSourceArtifact;
    }

    private String getPluginVersion(PluginRef pluginRef) throws MojoExecutionException {
        BundleDescription bundle;
        String bundleVersion = pluginRef.getVersion();
        if ("0.0.0".equals(bundleVersion)) {
            bundleVersion = "highest version";
        }
        if ((bundle = this.state.getBundleDescription(pluginRef.getId(), bundleVersion)) == null) {
            throw new MojoExecutionException("Can't find bundle " + pluginRef.getId());
        }
        MavenProject bundleProject = this.state.getMavenProject(bundle);
        return bundleProject.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packagePlugin(PluginRef plugin, Map<String, String> archives, boolean isPack200) throws Exception {
        File file;
        BundleDescription bundle;
        String bundleId = plugin.getId();
        String version = plugin.getVersion();
        String path = "plugins/" + bundleId + "_" + version + ".jar";
        if (archives.containsKey(path)) {
            if (this.inlineArchives) {
                URL url = new URL(archives.get(path));
                InputStream is = url.openStream();
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(new File(this.target, path)));
                    try {
                        IOUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    is.close();
                }
            }
            return;
        }
        if ("0.0.0".equals(version)) {
            version = "highest version";
        }
        if ((bundle = this.state.getBundleDescription(bundleId, version)) == null) {
            throw new MojoExecutionException("Can't find bundle " + bundleId);
        }
        MavenProject bundleProject = this.state.getMavenProject(bundle);
        if (bundleProject != null) {
            file = bundleProject.getArtifact().getFile();
            if (file.isDirectory()) {
                throw new MojoExecutionException("Bundle project " + bundleProject.getId() + " artifact is a directory. The build should at least run ``package'' phase.");
            }
        } else {
            file = new File(bundle.getLocation());
        }
        String bundleVersion = this.state.getFinalVersion(bundle).toString();
        String url = "plugins/" + bundleId + "_" + bundleVersion + ".jar";
        File outputJar = new File(this.target, url);
        outputJar.getParentFile().mkdirs();
        if (file.isDirectory()) {
            this.packDir(file, outputJar);
        } else {
            FileUtils.copyFile((File)file, (File)outputJar);
        }
        if (this.sign) {
            this.signJar(outputJar);
        }
        if (isPack200) {
            this.shipPack200(outputJar, url);
        }
    }

    private void shipPack200(File jar, String url) throws ArchiverException, IOException, ComponentLookupException {
        File outputPack = new File(jar.getParentFile(), jar.getName() + ".pack");
        Pack200Archiver packArchiver = new Pack200Archiver();
        packArchiver.setSourceJar(jar);
        packArchiver.setDestFile(outputPack);
        packArchiver.createArchive();
        GZipCompressor gzCompressor = new GZipCompressor();
        gzCompressor.setDestFile(new File(jar.getParentFile(), jar.getName() + ".pack.gz"));
        gzCompressor.setSourceFile(outputPack);
        gzCompressor.execute();
        outputPack.delete();
    }

    private void signJar(File outputJar) throws MojoExecutionException {
        if (this.keystore == null) {
            this.keystore = new File(System.getProperty("user.home"), ".keystore");
        }
        if (!this.keystore.exists()) {
            this.getLog().warn((CharSequence)("Unable to sign, keystore file not found: " + this.keystore.getAbsolutePath()));
            return;
        }
        if (this.storepass == null) {
            this.getLog().warn((CharSequence)"Unable to sign, keystore password must be specifyed.");
            return;
        }
        if (this.alias == null) {
            this.getLog().warn((CharSequence)"Unable to sign, alias must be specifyed.");
            return;
        }
        if (this.keypass == null) {
            this.getLog().warn((CharSequence)"Unable to sign, keypass must be specifyed.");
            return;
        }
        JarSignMojo sign = new JarSignMojo();
        sign.setKeystore(this.keystore.getAbsolutePath());
        sign.setStorepass(this.storepass);
        sign.setAlias(this.alias);
        sign.setKeypass(this.keypass);
        sign.setJarPath(outputJar);
        sign.setBasedir(this.basedir);
        sign.setWorkingDir(this.basedir);
        sign.setLog(this.getLog());
        sign.setVerbose(false);
        sign.setVerify(false);
        sign.execute();
    }

    public void contextualize(Context ctx) throws ContextException {
        this.plexus = (PlexusContainer)ctx.get((Object)"plexus");
    }
}

