/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reactor.MavenExecutionException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.tycho.p2.P2;

public class P2MetadataMojo
extends AbstractMojo {
    protected MavenProject project;
    private String metadataRepositoryName;
    private File target;
    private String artifactRepositoryName;
    private int forkedProcessTimeoutInSeconds;
    private String argLine;
    private P2 p2;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generateMetadata();
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot generate P2 metadata", e);
        }
    }

    private void generateMetadata() throws Exception {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.project.getBasedir());
        String executable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        if (File.separatorChar == '\\') {
            executable = executable + ".exe";
        }
        cli.setExecutable(executable);
        cli.addArguments(new String[]{"-jar", this.getEclipseLauncher().getAbsolutePath()});
        cli.addArguments(new String[]{"-nosplash", "-application", "org.eclipse.equinox.p2.metadata.generator.EclipseGenerator", "-updateSite", this.getUpdateSiteLocation().getCanonicalPath(), "-site", new File(this.getUpdateSiteLocation(), "site.xml").toURL().toExternalForm(), "-metadataRepository", this.getUpdateSiteLocation().toURL().toExternalForm(), "-metadataRepositoryName", this.metadataRepositoryName, "-artifactRepository", this.getUpdateSiteLocation().toURL().toExternalForm(), "-artifactRepositoryName", this.artifactRepositoryName, "-noDefaultIUs", "-vmargs", this.argLine});
        this.getLog().info((CharSequence)("Command line:\n\t" + cli.toString()));
        StreamConsumer out = new StreamConsumer(){

            public void consumeLine(String line) {
                System.out.println(line);
            }
        };
        StreamConsumer err = new StreamConsumer(){

            public void consumeLine(String line) {
                System.err.println(line);
            }
        };
        int result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err, (int)this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 return code was " + result);
        }
    }

    private File getUpdateSiteLocation() {
        return this.target;
    }

    private File getEclipseLauncher() throws MojoFailureException {
        try {
            return new File(this.p2.getP2RuntimeLocation(), "plugins/org.eclipse.equinox.launcher_1.0.101.R34x_v20080819.jar");
        }
        catch (MavenExecutionException e) {
            throw new MojoFailureException("Can't locate P2 runtime", (Throwable)e);
        }
    }
}

