/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.eclipsepackaging;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.tycho.eclipsepackaging.product.Plugin;
import org.codehaus.tycho.eclipsepackaging.product.ProductConfiguration;
import org.codehaus.tycho.osgitools.OsgiState;
import org.codehaus.tycho.osgitools.features.FeatureDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class ProductExportMojo
extends AbstractMojo {
    private OsgiState state;
    protected MavenProject project;
    private File target;
    private File productConfigurationFile;
    private ProductConfiguration productConfiguration;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File basedir;
        File productCfg;
        if (this.productConfigurationFile == null && (productCfg = new File(basedir = this.project.getBasedir(), this.project.getArtifactId() + ".product")).exists()) {
            this.productConfigurationFile = productCfg;
        }
        if (this.productConfigurationFile == null) {
            throw new MojoExecutionException("Product configuration file not expecified");
        }
        if (!this.productConfigurationFile.exists()) {
            throw new MojoExecutionException("Product configuration file not found " + this.productConfigurationFile.getAbsolutePath());
        }
        XStream xs = new XStream();
        xs.processAnnotations(ProductConfiguration.class);
        try {
            this.productConfiguration = (ProductConfiguration)xs.fromXML((InputStream)new FileInputStream(this.productConfigurationFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading product configuration file", (Exception)e);
        }
        catch (XStreamException e) {
            throw new MojoExecutionException("Error parsing product configuration file", (Exception)((Object)e));
        }
        this.addOsgiLauncherPlugins();
        this.generateEclipseProduct();
        this.generateConfigIni();
        this.copyPlugins();
        this.copyExecutable();
    }

    private void addOsgiLauncherPlugins() {
        String ws = this.state.getPlatformProperty("osgi.ws");
        String os = this.state.getPlatformProperty("osgi.os");
        String arch = this.state.getPlatformProperty("osgi.arch");
        this.productConfiguration.getPlugins().add(new Plugin("org.eclipse.equinox.launcher", null));
        this.productConfiguration.getPlugins().add(new Plugin("org.eclipse.equinox.launcher." + ws + "." + os + "." + arch, null));
    }

    private void generateEclipseProduct() throws MojoExecutionException {
        Properties props = new Properties();
        this.setPropertyIfNotNull(props, "version", this.productConfiguration.getVersion());
        this.setPropertyIfNotNull(props, "name", this.productConfiguration.getName());
        this.setPropertyIfNotNull(props, "id", this.productConfiguration.getId());
        this.target.mkdirs();
        File eclipseproduct = new File(this.target, ".eclipseproduct");
        try {
            FileOutputStream fos = new FileOutputStream(eclipseproduct);
            props.store(fos, "Eclipse Product File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private void generateConfigIni() throws MojoExecutionException {
        Properties props = new Properties();
        this.setPropertyIfNotNull(props, "osgi.splashPath", "platform:/base/plugins/" + this.productConfiguration.getPlugins().get(0).getId());
        this.setPropertyIfNotNull(props, "eclipse.product", this.productConfiguration.getId());
        this.setPropertyIfNotNull(props, "osgi.bundles.defaultStartLevel", "4");
        this.setPropertyIfNotNull(props, "osgi.bundles", this.getPluginsIdsAsString());
        File configsFolder = new File(this.target, "configuration");
        configsFolder.mkdirs();
        File configIni = new File(configsFolder, "config.ini");
        try {
            FileOutputStream fos = new FileOutputStream(configIni);
            props.store(fos, "Product Runtime Configuration File");
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating .eclipseproduct file.", (Exception)e);
        }
    }

    private String getPluginsIdsAsString() {
        List<Plugin> plugins = this.productConfiguration.getPlugins();
        StringBuilder buf = new StringBuilder(plugins.size() * 10);
        for (Plugin plugin : plugins) {
            if (buf.length() != 0) {
                buf.append(',');
            }
            if ("org.eclipse.osgi".equals(plugin.getId())) continue;
            buf.append(plugin.getId());
            if (!"org.eclipse.core.runtime".equals(plugin.getId())) continue;
            buf.append("@start");
        }
        return buf.toString();
    }

    private void copyPlugins() throws MojoExecutionException {
        List<Plugin> plugins = this.productConfiguration.getPlugins();
        File pluginsFolder = new File(this.target, "plugins");
        pluginsFolder.mkdirs();
        for (Plugin plugin : plugins) {
            BundleDescription bundle;
            String bundleId = plugin.getId();
            String bundleVersion = plugin.getVersion();
            if (bundleVersion == null || "0.0.0".equals(bundleVersion)) {
                bundleVersion = "highest version";
            }
            if ((bundle = this.state.getBundleDescription(bundleId, bundleVersion)) == null) {
                throw new MojoExecutionException("Plugin " + bundleId + " not found!");
            }
            MavenProject bundleProject = this.state.getMavenProject(bundle);
            File file = bundleProject != null ? bundleProject.getArtifact().getFile() : new File(bundle.getLocation());
            try {
                if (file.isFile()) {
                    FileUtils.copyFileToDirectory((File)file, (File)pluginsFolder);
                    continue;
                }
                if (file.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)file, (File)pluginsFolder);
                    continue;
                }
                this.getLog().warn((CharSequence)("Skipping plugin " + bundleId + "\n" + file.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to copy plugin " + bundleId, (Exception)e);
            }
        }
    }

    private void copyExecutable() throws MojoExecutionException {
        FeatureDescription feature = this.state.getFeatureDescription("org.eclipse.equinox.executable", null);
        if (feature == null) {
            String msg = "RPC delta feature not found!";
            throw new MojoExecutionException(msg, (Exception)new ArtifactResolutionException(msg, "", "org.eclipse.equinox.executable", "", "eclipse-feature", null, null));
        }
        String ws = this.state.getPlatformProperty("osgi.ws");
        String os = this.state.getPlatformProperty("osgi.os");
        String arch = this.state.getPlatformProperty("osgi.arch");
        File location = feature.getLocation();
        File osLauncher = new File(location, "bin/" + ws + "/" + os + "/" + arch);
        try {
            FileUtils.copyDirectory((File)osLauncher, (File)this.target);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy launcher executable", (Exception)e);
        }
    }

    private void setPropertyIfNotNull(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }
}

