/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgicompiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.codehaus.tycho.BundleResolutionState;
import org.codehaus.tycho.TychoConstants;
import org.codehaus.tycho.osgitools.DependencyComputer;
import org.codehaus.tycho.osgitools.project.BuildOutputJar;
import org.codehaus.tycho.osgitools.project.EclipsePluginProject;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathComputer {
    public static final String ACCESS_RULE_SEPARATOR = File.pathSeparator;
    public static final String EXCLUDE_ALL_RULE = "-**/*";
    private final BundleResolutionState bundleResolutionState;
    private final DependencyComputer dependencyComputer;
    private final File storage;
    private final MavenProject project;
    private final BundleDescription bundle;
    private final Map<File, MavenProject> sessionProjects = new HashMap<File, MavenProject>();

    public ClasspathComputer(MavenSession session, DependencyComputer dependencyComputer, MavenProject project, File storage) {
        this.bundleResolutionState = (BundleResolutionState)project.getContextValue(TychoConstants.CTX_BUNDLE_RESOLUTION_STATE);
        this.dependencyComputer = dependencyComputer;
        this.project = project;
        this.storage = storage;
        this.bundle = this.bundleResolutionState.getBundleByLocation(project.getBasedir());
        for (MavenProject sessionProject : session.getProjects()) {
            this.sessionProjects.put(sessionProject.getBasedir(), sessionProject);
        }
    }

    public void addOutputDirectory(File outputDirectory) {
    }

    public List<String> computeClasspath() {
        LinkedHashSet<String> classpath = new LinkedHashSet<String>();
        classpath.addAll(this.getProjectEntries(this.bundle, this.project));
        for (DependencyComputer.DependencyEntry entry : this.dependencyComputer.computeDependencies(this.bundleResolutionState, this.bundle)) {
            this.addBundle(classpath, entry);
        }
        return new ArrayList<String>(classpath);
    }

    private void addBundle(Set<String> classpath, DependencyComputer.DependencyEntry dependency) {
        MavenProject project = this.sessionProjects.get(new File(dependency.desc.getLocation()));
        List<String> entries = project != null ? this.getProjectEntries(dependency.desc, project) : this.getBundleEntries(dependency.desc);
        StringBuilder rules = new StringBuilder();
        if (dependency.rules != null) {
            rules.append("[");
            for (DependencyComputer.AccessRule rule : dependency.rules) {
                if (rules.length() > 1) {
                    rules.append(ACCESS_RULE_SEPARATOR);
                }
                rules.append(rule.discouraged ? "~" : "+");
                rules.append(rule.path);
            }
            if (rules.length() > 1) {
                rules.append(ACCESS_RULE_SEPARATOR);
            }
            rules.append(EXCLUDE_ALL_RULE);
            rules.append("]");
        }
        for (String entry : entries) {
            classpath.add(entry + rules);
        }
    }

    private List<String> getBundleEntries(BundleDescription bundle) {
        ArrayList<String> classpath = new ArrayList<String>();
        for (String cp : this.getBundleClasspath(bundle)) {
            File entry = ".".equals(cp) ? new File(bundle.getLocation()) : this.getNestedJar(bundle, cp);
            if (entry == null) continue;
            classpath.add(entry.getAbsolutePath());
        }
        return classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getNestedJar(BundleDescription bundle, String cp) {
        File bundleLocation = new File(bundle.getLocation());
        if (bundleLocation.isDirectory()) {
            return new File(bundleLocation, cp);
        }
        File file = new File(this.storage, bundle.getName() + "_" + bundle.getVersion() + "/" + cp);
        try {
            ZipFile zip = new ZipFile(bundleLocation);
            try {
                ZipEntry ze = zip.getEntry(cp);
                if (ze != null) {
                    InputStream is = zip.getInputStream(ze);
                    FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(is), (File)file);
                }
            }
            finally {
                zip.close();
            }
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }

    private List<String> getProjectEntries(BundleDescription bundle, MavenProject project) {
        ArrayList<String> classpath = new ArrayList<String>();
        EclipsePluginProject pdeProject = (EclipsePluginProject)project.getContextValue(TychoConstants.CTX_ECLIPSE_PLUGIN_PROJECT);
        Map outputJars = pdeProject.getOutputJarMap();
        for (String cp : this.getBundleClasspath(bundle)) {
            if (outputJars.containsKey(cp)) {
                classpath.add(((BuildOutputJar)outputJars.get(cp)).getOutputDirectory().getAbsolutePath());
                continue;
            }
            File jar = new File(project.getBasedir(), cp);
            if (!jar.exists()) continue;
            classpath.add(jar.getAbsolutePath());
        }
        return classpath;
    }

    private String[] getBundleClasspath(BundleDescription bundle) {
        String[] result = new String[]{"."};
        String classpath = this.bundleResolutionState.getManifestAttribute(bundle, "Bundle-ClassPath");
        if (classpath != null) {
            try {
                ManifestElement[] classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
                result = new String[classpathEntries.length];
                for (int i = 0; i < classpathEntries.length; ++i) {
                    result[i] = classpathEntries[i].getValue();
                }
            }
            catch (BundleException e) {
                // empty catch block
            }
        }
        return result;
    }
}

