/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgicompiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.tycho.osgicompiler.ClasspathComputer3_0;
import org.codehaus.tycho.osgicompiler.copied.AbstractCompilerMojo;
import org.codehaus.tycho.osgicompiler.copied.CompilationFailureException;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOsgiCompilerMojo
extends AbstractCompilerMojo {
    private File storage;
    private MavenProject project;
    private boolean usePdeSourceRoots;
    private OsgiState state;
    private ArrayList<String> classpathElements;
    private Artifact projectArtifact;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private Properties buildProperties;
    private String libraryName = ".";

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.usePdeSourceRoots) {
            this.getLog().info((CharSequence)"Using compile source roots from build.properties");
        }
        List<String> libraries = this.getLibraries();
        Iterator<String> i$ = libraries.iterator();
        while (i$.hasNext()) {
            String library;
            this.libraryName = library = i$.next();
            super.execute();
            this.classpathElements.add(this.getOutputDirectory().getAbsolutePath());
        }
        this.projectArtifact.setFile(this.getOutputDirectory());
    }

    private List<String> getLibraries() throws MojoExecutionException {
        Properties props = this.getBuildProperties();
        ArrayList<String> availableSources = new ArrayList<String>();
        for (Object objKey : props.keySet()) {
            String key = objKey.toString();
            if (!key.startsWith("source.")) continue;
            String libraryName = key.substring(7);
            availableSources.add(libraryName);
        }
        ArrayList<String> libraries = new ArrayList<String>();
        String jarsOrder = props.getProperty("jars.compile.order");
        if (jarsOrder != null && !"".equals(jarsOrder)) {
            String[] jars = jarsOrder.split(",");
            libraries.addAll(Arrays.asList(jars));
        }
        for (String source : availableSources) {
            if (libraries.contains(source)) continue;
            libraries.add(source);
        }
        return libraries;
    }

    @Override
    public List<String> getClasspathElements() {
        if (this.classpathElements == null) {
            BundleDescription thisBundle = this.state.getBundleDescription(this.project);
            ClasspathComputer3_0 cc = new ClasspathComputer3_0(thisBundle, this.state, this.storage);
            List<ClasspathComputer3_0.ClasspathElement> classpath = cc.getClasspath();
            this.classpathElements = new ArrayList(classpath.size());
            for (ClasspathComputer3_0.ClasspathElement cp : classpath) {
                this.classpathElements.add(cp.getPath() + cp.getAccessRules());
            }
        }
        return this.classpathElements;
    }

    @Override
    protected final List<String> getCompileSourceRoots() throws MojoExecutionException {
        return this.usePdeSourceRoots ? this.getPdeCompileSourceRoots() : this.getConfiguredCompileSourceRoots();
    }

    protected abstract List<String> getConfiguredCompileSourceRoots();

    @Override
    protected final File getOutputDirectory() {
        return ".".equals(this.libraryName) ? this.getConfiguredOutputDirectory() : new File(this.getConfiguredOutputDirectory().getParentFile(), this.libraryName.substring(0, this.libraryName.length() - 4) + "-classes");
    }

    protected abstract File getConfiguredOutputDirectory();

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.includes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(this.includes, Collections.EMPTY_SET);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        }
        return scanner;
    }

    protected List<String> getPdeCompileSourceRoots() throws MojoExecutionException {
        Properties bp = this.getBuildProperties();
        ArrayList<String> sources = new ArrayList<String>();
        String sourcesRaw = bp.getProperty("source." + this.libraryName);
        if (sourcesRaw != null && sourcesRaw.length() > 0) {
            StringTokenizer st = new StringTokenizer(sourcesRaw, ",");
            while (st.hasMoreTokens()) {
                String sourcePath = st.nextToken();
                try {
                    sources.add(new File(this.project.getBasedir(), sourcePath).getCanonicalPath());
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable to resolve source path " + sourcePath, (Exception)e);
                }
            }
        }
        return sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getBuildProperties() throws MojoExecutionException {
        if (this.buildProperties == null) {
            File file = new File(this.project.getBasedir(), "build.properties");
            if (!file.canRead()) {
                throw new MojoExecutionException("Unable to read build.properties file");
            }
            this.buildProperties = new Properties();
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    this.buildProperties.load(is);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception reading build.properties file", (Exception)e);
            }
        }
        return this.buildProperties;
    }

    @Override
    protected CompilerConfiguration getCompilerConfiguration(List<String> compileSourceRoots) throws MojoExecutionException {
        Properties props;
        String encoding;
        CompilerConfiguration compilerConfiguration = super.getCompilerConfiguration(compileSourceRoots);
        if (this.usePdeSourceRoots && (encoding = (props = this.getBuildProperties()).getProperty("javacDefaultEncoding." + this.libraryName)) != null) {
            compilerConfiguration.setSourceEncoding(encoding);
        }
        return compilerConfiguration;
    }
}

