/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgicompiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.tycho.osgicompiler.ClasspathComputer3_0;
import org.codehaus.tycho.osgicompiler.copied.AbstractCompilerMojo;
import org.codehaus.tycho.osgicompiler.copied.CompilationFailureException;
import org.codehaus.tycho.osgitools.OsgiState;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOsgiCompilerMojo
extends AbstractCompilerMojo {
    private File storage;
    private MavenProject project;
    private boolean usePdeSourceRoots;
    private OsgiState state;
    private Artifact projectArtifact;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        List compileSourceRoots;
        if (this.usePdeSourceRoots) {
            this.getLog().info((CharSequence)"Using compile source roots from build.properties");
        }
        if ((compileSourceRoots = AbstractOsgiCompilerMojo.removeEmptyCompileSourceRoots(this.getCompileSourceRoots())).isEmpty()) {
            this.getLog().info((CharSequence)"No sources to compile");
            return;
        }
        super.execute();
        this.projectArtifact.setFile(this.getOutputDirectory());
    }

    @Override
    public List<String> getClasspathElements() {
        BundleDescription thisBundle = this.state.getBundleDescription(this.project);
        ClasspathComputer3_0 cc = new ClasspathComputer3_0(thisBundle, this.state, this.storage);
        List<ClasspathComputer3_0.ClasspathElement> classpath = cc.getClasspath();
        ArrayList<String> result = new ArrayList<String>(classpath.size());
        for (ClasspathComputer3_0.ClasspathElement cp : classpath) {
            result.add(cp.getPath() + cp.getAccessRules());
        }
        return result;
    }

    @Override
    protected final List<String> getCompileSourceRoots() throws MojoExecutionException {
        return this.usePdeSourceRoots ? this.getPdeCompileSourceRoots() : this.getConfiguredCompileSourceRoots();
    }

    protected abstract List<String> getConfiguredCompileSourceRoots();

    @Override
    protected abstract File getOutputDirectory();

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.includes, this.excludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner = null;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            this.includes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(this.includes, Collections.EMPTY_SET);
        } else {
            if (this.includes.isEmpty()) {
                this.includes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(this.includes, this.excludes);
        }
        return scanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getPdeCompileSourceRoots() throws MojoExecutionException {
        ArrayList<String> arrayList;
        File file = new File(this.project.getBasedir(), "build.properties");
        if (!file.canRead()) {
            throw new MojoExecutionException("Unable to read build.properties file");
        }
        Properties bp = new Properties();
        FileInputStream is = new FileInputStream(file);
        try {
            bp.load(is);
            ArrayList<String> sources = new ArrayList<String>();
            String sourcesRaw = bp.getProperty("source..");
            if (sourcesRaw != null && sourcesRaw.length() > 0) {
                StringTokenizer st = new StringTokenizer(sourcesRaw, ",");
                while (st.hasMoreTokens()) {
                    sources.add(new File(this.project.getBasedir(), st.nextToken()).getCanonicalPath());
                }
            }
            arrayList = sources;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception reading build.properties file", (Exception)e);
            }
        }
        ((InputStream)is).close();
        return arrayList;
    }
}

