/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle;

import java.io.DataInputStream;
import java.io.InputStream;

public class StreamLexer {
    final int BEGIN = 0;
    final int END = 1;
    DataInputStream in;
    String[][] token;
    int tokenCount;
    String line;
    int pos;
    int[] buffer = new int[20];
    boolean off;
    int depth = 0;

    public StreamLexer(InputStream input, String[][] token) {
        this(new DataInputStream(input), token);
    }

    public StreamLexer(DataInputStream in, String[][] token) {
        this.in = in;
        this.token = token;
    }

    public int read() throws Exception {
        int b = this.in.read();
        if (b == 60) {
            this.readToken();
            b = this.read();
        }
        return b;
    }

    private void readToken() throws Exception {
        StringBuffer token = new StringBuffer();
        int b = this.in.read();
        while (b != 62 || --this.depth >= 1) {
            if (b == 60) {
                ++this.depth;
                token.append((char)b);
            } else {
                token.append((char)b);
            }
            b = this.in.read();
        }
        System.out.println(token.toString());
    }

    public String _nextToken() throws Exception {
        int pos;
        if (this.tokenCount >= this.token.length) {
            this.tokenCount = 0;
        }
        String begin = this.token[this.tokenCount][0];
        String end = this.token[this.tokenCount][1];
        if (this.line != null && (pos = this.line.indexOf(begin)) != -1) {
            this.line = this.line.substring(pos + begin.length());
            pos = this.line.indexOf(end);
            if (pos != -1) {
                ++this.tokenCount;
                return this.line.substring(0, pos);
            }
        }
        while ((this.line = this.in.readLine()) != null) {
            System.out.println(this.line);
            pos = this.line.indexOf(begin);
            if (pos == -1) continue;
            this.line = this.line.substring(pos + begin.length());
            pos = this.line.indexOf(end);
            if (pos == -1) continue;
            return this.line.substring(0, pos);
        }
        return null;
    }
}

