/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import java.util.Date;
import org.sonar.wsclient.services.Event;
import org.sonar.wsclient.services.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventQuery
extends Query<Event> {
    public static final String BASE_URL = "/api/events";
    private String resourceKey;
    private String[] categories;
    private Date fromDate;
    private boolean includeFromTime;
    private Date toDate;
    private boolean includeToTime;

    public EventQuery() {
    }

    public EventQuery(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public Date getFrom() {
        return this.fromDate;
    }

    public EventQuery setFrom(Date fromDate, boolean includeTime) {
        this.fromDate = fromDate;
        this.includeFromTime = includeTime;
        return this;
    }

    public boolean isIncludeFromTime() {
        return this.includeFromTime;
    }

    public Date getTo() {
        return this.toDate;
    }

    public EventQuery setTo(Date toDate, boolean includeTime) {
        this.toDate = toDate;
        this.includeToTime = includeTime;
        return this;
    }

    public boolean isIncludeToTime() {
        return this.includeToTime;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public EventQuery setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public EventQuery setCategories(String[] categories) {
        this.categories = categories;
        return this;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        EventQuery.appendUrlParameter(url, "resource", this.resourceKey);
        EventQuery.appendUrlParameter(url, "categories", this.categories);
        if (this.fromDate != null) {
            if (this.includeFromTime) {
                EventQuery.appendUrlParameter(url, "fromDateTime", this.fromDate, true);
            } else {
                EventQuery.appendUrlParameter(url, "fromDate", this.fromDate, false);
            }
        }
        if (this.toDate != null) {
            if (this.includeToTime) {
                EventQuery.appendUrlParameter(url, "toDateTime", this.toDate, true);
            } else {
                EventQuery.appendUrlParameter(url, "toDate", this.toDate, false);
            }
        }
        return url.toString();
    }

    @Override
    public Class<Event> getModelClass() {
        return Event.class;
    }
}

