/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.ISourceFileCoverage;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.runtime.WildcardMatcher;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.JaCoCoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalyzer {
    public final void analyse(Project project, SensorContext context) {
        File buildOutputDir = project.getFileSystem().getBuildOutputDir();
        if (!buildOutputDir.exists()) {
            JaCoCoUtils.LOG.info("Project coverage is set to 0% as build output directory doesn't exists: {}", (Object)buildOutputDir);
            return;
        }
        String path = this.getReportPath(project);
        File jacocoExecutionData = project.getFileSystem().resolvePath(path);
        WildcardMatcher excludes = new WildcardMatcher(Strings.nullToEmpty((String)this.getExcludes(project)));
        try {
            this.readExecutionData(jacocoExecutionData, buildOutputDir, context, excludes);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
    }

    public final void readExecutionData(File jacocoExecutionData, File buildOutputDir, SensorContext context, WildcardMatcher excludes) throws IOException {
        SessionInfoStore sessionInfoStore = new SessionInfoStore();
        ExecutionDataStore executionDataStore = new ExecutionDataStore();
        if (jacocoExecutionData == null || !jacocoExecutionData.exists() || !jacocoExecutionData.isFile()) {
            JaCoCoUtils.LOG.info("Project coverage is set to 0% as no JaCoCo execution data has been dumped: {}", (Object)jacocoExecutionData);
        } else {
            JaCoCoUtils.LOG.info("Analysing {}", (Object)jacocoExecutionData);
            ExecutionDataReader reader = new ExecutionDataReader((InputStream)new FileInputStream(jacocoExecutionData));
            reader.setSessionInfoVisitor((ISessionInfoVisitor)sessionInfoStore);
            reader.setExecutionDataVisitor((IExecutionDataVisitor)executionDataStore);
            reader.read();
        }
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
        this.analyzeAll(analyzer, buildOutputDir);
        int analyzedResources = 0;
        for (ISourceFileCoverage coverage : coverageBuilder.getSourceFiles()) {
            JavaFile resource = AbstractAnalyzer.getResource(coverage, context);
            if (resource == null) continue;
            if (!AbstractAnalyzer.isExcluded(coverage, excludes)) {
                this.analyzeFile(resource, coverage, context);
            }
            ++analyzedResources;
        }
        if (analyzedResources == 0) {
            JaCoCoUtils.LOG.warn("Coverage information was not collected. Perhaps you forget to include debug information into compiled classes?");
        }
    }

    private static boolean isExcluded(ISourceFileCoverage coverage, WildcardMatcher excludesMatcher) {
        String name = coverage.getPackageName() + "/" + coverage.getName();
        return excludesMatcher.matches(name);
    }

    @VisibleForTesting
    static JavaFile getResource(ISourceFileCoverage coverage, SensorContext context) {
        String fileName;
        String packageName = StringUtils.replaceChars((String)coverage.getPackageName(), (char)'/', (char)'.');
        JavaFile resource = new JavaFile(packageName, fileName = StringUtils.substringBeforeLast((String)coverage.getName(), (String)"."));
        JavaFile resourceInContext = (JavaFile)context.getResource((Resource)resource);
        if (null == resourceInContext) {
            return null;
        }
        if (ResourceUtils.isUnitTestClass((Resource)resourceInContext)) {
            return null;
        }
        return resourceInContext;
    }

    private void analyzeAll(Analyzer analyzer, File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.analyzeAll(analyzer, f);
            }
        } else {
            try {
                analyzer.analyzeAll(file);
            }
            catch (Exception e) {
                JaCoCoUtils.LOG.warn("Exception during analysis of file " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private void analyzeFile(JavaFile resource, ISourceFileCoverage coverage, SensorContext context) {
        CoverageMeasuresBuilder builder = CoverageMeasuresBuilder.create();
        block5: for (int lineId = coverage.getFirstLine(); lineId <= coverage.getLastLine(); ++lineId) {
            int hits;
            ILine line = coverage.getLine(lineId);
            switch (line.getInstructionCounter().getStatus()) {
                case 2: 
                case 3: {
                    hits = 1;
                    break;
                }
                case 1: {
                    hits = 0;
                    break;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    JaCoCoUtils.LOG.warn("Unknown status for line {} in {}", (Object)lineId, (Object)resource);
                    continue block5;
                }
            }
            builder.setHits(lineId, hits);
            ICounter branchCounter = line.getBranchCounter();
            int conditions = branchCounter.getTotalCount();
            if (conditions <= 0) continue;
            int coveredConditions = branchCounter.getCoveredCount();
            builder.setConditions(lineId, conditions, coveredConditions);
        }
        this.saveMeasures(context, resource, builder.createMeasures());
    }

    protected abstract void saveMeasures(SensorContext var1, JavaFile var2, Collection<Measure> var3);

    protected abstract String getReportPath(Project var1);

    protected abstract String getExcludes(Project var1);
}

