/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.secdispatcher.internal;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.components.cipher.PlexusCipher;
import org.codehaus.plexus.components.cipher.PlexusCipherException;
import org.codehaus.plexus.components.secdispatcher.SecDispatcher;
import org.codehaus.plexus.components.secdispatcher.SecDispatcherException;
import org.codehaus.plexus.components.secdispatcher.internal.Dispatcher;
import org.codehaus.plexus.components.secdispatcher.internal.MasterPasswordSource;
import org.codehaus.plexus.components.secdispatcher.internal.SecUtil;
import org.codehaus.plexus.components.secdispatcher.model.SettingsSecurity;

@Singleton
@Named
public class DefaultSecDispatcher
implements SecDispatcher {
    public static final String ATTR_START = "[";
    public static final String ATTR_STOP = "]";
    protected final PlexusCipher cipher;
    protected final Map<String, MasterPasswordSource> masterPasswordSources;
    protected final Map<String, Dispatcher> dispatchers;
    protected final String configurationFile;

    @Inject
    public DefaultSecDispatcher(PlexusCipher cipher, Map<String, MasterPasswordSource> masterPasswordSources, Map<String, Dispatcher> dispatchers, @Named(value="${configurationFile:-~/.m2/settings-security.xml}") String configurationFile) {
        this.cipher = Objects.requireNonNull(cipher);
        this.masterPasswordSources = Objects.requireNonNull(masterPasswordSources);
        this.dispatchers = Objects.requireNonNull(dispatchers);
        this.configurationFile = Objects.requireNonNull(configurationFile);
    }

    @Override
    public Set<String> availableDispatchers() {
        return Set.copyOf(this.dispatchers.keySet());
    }

    @Override
    public Set<String> availableCiphers() {
        return this.cipher.availableCiphers();
    }

    @Override
    public String encrypt(String str, Map<String, String> attr) throws SecDispatcherException {
        if (this.isEncryptedString(str)) {
            return str;
        }
        try {
            Object res;
            if (attr == null || attr.get("name") == null) {
                SettingsSecurity sec = this.getConfiguration(true);
                String master = this.getMasterPassword(sec, true);
                res = this.cipher.encrypt(this.getMasterCipher(sec), str, master);
            } else {
                String type = attr.get("name");
                Dispatcher dispatcher = this.dispatchers.get(type);
                if (dispatcher == null) {
                    throw new SecDispatcherException("no dispatcher for name " + type);
                }
                res = ATTR_START + attr.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")) + ATTR_STOP;
                res = (String)res + dispatcher.encrypt(str, attr, this.prepareDispatcherConfig(type));
            }
            return this.cipher.decorate((String)res);
        }
        catch (PlexusCipherException e2) {
            throw new SecDispatcherException(e2.getMessage(), e2);
        }
    }

    @Override
    public String decrypt(String str) throws SecDispatcherException {
        if (!this.isEncryptedString(str)) {
            return str;
        }
        try {
            String bare = this.cipher.unDecorate(str);
            Map<String, String> attr = this.stripAttributes(bare);
            if (attr == null || attr.get("name") == null) {
                SettingsSecurity sec = this.getConfiguration(true);
                String master = this.getMasterPassword(sec, true);
                return this.cipher.decrypt(this.getMasterCipher(sec), bare, master);
            }
            String type = attr.get("name");
            Dispatcher dispatcher = this.dispatchers.get(type);
            if (dispatcher == null) {
                throw new SecDispatcherException("no dispatcher for name " + type);
            }
            return dispatcher.decrypt(this.strip(bare), attr, this.prepareDispatcherConfig(type));
        }
        catch (PlexusCipherException e) {
            throw new SecDispatcherException(e.getMessage(), e);
        }
    }

    @Override
    public SettingsSecurity readConfiguration(boolean createIfMissing) throws IOException {
        SettingsSecurity configuration = SecUtil.read(this.getConfigurationPath());
        if (configuration == null && createIfMissing) {
            configuration = new SettingsSecurity();
        }
        return configuration;
    }

    @Override
    public void writeConfiguration(SettingsSecurity configuration) throws IOException {
        Objects.requireNonNull(configuration, "configuration is null");
        SecUtil.write(this.getConfigurationPath(), configuration, true);
    }

    private Map<String, String> prepareDispatcherConfig(String type) {
        Map<String, String> conf;
        HashMap<String, String> dispatcherConf = new HashMap<String, String>();
        SettingsSecurity sec = this.getConfiguration(false);
        String master = this.getMasterPassword(sec, false);
        if (master != null) {
            dispatcherConf.put("masterPassword", master);
        }
        if ((conf = SecUtil.getConfig(sec, type)) != null) {
            dispatcherConf.putAll(conf);
        }
        return dispatcherConf;
    }

    private String strip(String str) {
        int start = str.indexOf(ATTR_START);
        int stop = str.indexOf(ATTR_STOP);
        if (start != -1 && stop != -1 && stop > start) {
            return str.substring(stop + 1);
        }
        return str;
    }

    private Map<String, String> stripAttributes(String str) {
        int start = str.indexOf(ATTR_START);
        int stop = str.indexOf(ATTR_STOP);
        if (start != -1 && stop != -1 && stop > start) {
            if (start != 0) {
                throw new SecDispatcherException("Attributes can be prefix only");
            }
            if (stop == start + 1) {
                return null;
            }
            String attrs = str.substring(start + 1, stop).trim();
            if (attrs.isEmpty()) {
                return null;
            }
            HashMap<String, String> res = null;
            StringTokenizer st = new StringTokenizer(attrs, ",");
            while (st.hasMoreTokens()) {
                String pair;
                int pos;
                if (res == null) {
                    res = new HashMap<String, String>(st.countTokens());
                }
                if ((pos = (pair = st.nextToken()).indexOf(61)) == -1) {
                    throw new SecDispatcherException("Attribute malformed: " + pair);
                }
                String key = pair.substring(0, pos).trim();
                String val = pair.substring(pos + 1).trim();
                res.put(key, val);
            }
            return res;
        }
        return null;
    }

    private boolean isEncryptedString(String str) {
        if (str == null) {
            return false;
        }
        return this.cipher.isEncryptedString(str);
    }

    private Path getConfigurationPath() {
        String location = System.getProperty("settings.security", this.getConfigurationFile());
        location = location.charAt(0) == '~' ? System.getProperty("user.home") + location.substring(1) : location;
        return Paths.get(location, new String[0]);
    }

    private SettingsSecurity getConfiguration(boolean mandatory) throws SecDispatcherException {
        Path path = this.getConfigurationPath();
        try {
            SettingsSecurity sec = SecUtil.read(path);
            if (mandatory && sec == null) {
                throw new SecDispatcherException("Please check that configuration file on path " + String.valueOf(path) + " exists");
            }
            return sec;
        }
        catch (IOException e) {
            throw new SecDispatcherException(e.getMessage(), e);
        }
    }

    private String getMasterPassword(SettingsSecurity sec, boolean mandatory) throws SecDispatcherException {
        if (sec == null && !mandatory) {
            return null;
        }
        Objects.requireNonNull(sec, "configuration is null");
        String masterSource = Objects.requireNonNull(sec.getMasterSource(), "masterSource is null");
        for (MasterPasswordSource masterPasswordSource : this.masterPasswordSources.values()) {
            String masterPassword = masterPasswordSource.handle(masterSource);
            if (masterPassword == null) continue;
            return masterPassword;
        }
        if (mandatory) {
            throw new SecDispatcherException("master password could not be fetched");
        }
        return null;
    }

    private String getMasterCipher(SettingsSecurity sec) throws SecDispatcherException {
        Objects.requireNonNull(sec, "configuration is null");
        return Objects.requireNonNull(sec.getMasterCipher(), "masterCipher is null");
    }

    public String getConfigurationFile() {
        return this.configurationFile;
    }
}

