/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.attributes;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;

public class FileAttributes
implements PlexusIoResourceAttributes {
    public static final LinkOption[] FOLLOW_LINK_OPTIONS = new LinkOption[0];
    public static final LinkOption[] NOFOLLOW_LINK_OPTIONS = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    @Nullable
    private final Integer groupId;
    @Nullable
    private final String groupName;
    @Nullable
    private final Integer userId;
    private final String userName;
    private final boolean symbolicLink;
    private final boolean regularFile;
    private final boolean directory;
    private final boolean other;
    private final int octalMode;
    private final Set<PosixFilePermission> permissions;
    private final long size;
    private final FileTime lastModifiedTime;
    private static final Map<FileSystem, Map<Integer, String>> UIDS_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<FileSystem, Map<Integer, String>> GIDS_CACHE = Collections.synchronizedMap(new WeakHashMap());

    @Deprecated
    public FileAttributes(@Nonnull File file, @Nonnull Map<Integer, String> userCache, @Nonnull Map<Integer, String> groupCache) throws IOException {
        this(file);
    }

    public FileAttributes(@Nonnull File file) throws IOException {
        this(file.toPath(), false);
    }

    public FileAttributes(@Nonnull File file, boolean followLinks) throws IOException {
        this(file.toPath(), followLinks);
    }

    private static Map<Integer, String> getUserCache(FileSystem fs) {
        return UIDS_CACHE.computeIfAbsent(fs, f -> new ConcurrentHashMap());
    }

    private static Map<Integer, String> getGroupCache(FileSystem fs) {
        return GIDS_CACHE.computeIfAbsent(fs, f -> new ConcurrentHashMap());
    }

    public FileAttributes(@Nonnull Path path, boolean followLinks) throws IOException {
        String name;
        Map<Integer, String> cache;
        LinkOption[] options = followLinks ? FOLLOW_LINK_OPTIONS : NOFOLLOW_LINK_OPTIONS;
        Set<String> views = path.getFileSystem().supportedFileAttributeViews();
        String names = views.contains("unix") ? "unix:gid,uid,isSymbolicLink,isRegularFile,isDirectory,isOther,mode,permissions,size,lastModifiedTime" : (views.contains("posix") ? "posix:*" : "basic:*");
        Map<String, Object> attrs = Files.readAttributes(path, names, options);
        this.groupId = (Integer)attrs.get("gid");
        if (attrs.containsKey("group")) {
            this.groupName = ((Principal)attrs.get("group")).getName();
        } else if (this.groupId != null) {
            cache = FileAttributes.getGroupCache(path.getFileSystem());
            name = cache.get(this.groupId);
            if (name == null) {
                name = FileAttributes.getPrincipalName(path, "unix:group");
                cache.put(this.groupId, name);
            }
            this.groupName = name;
        } else {
            this.groupName = null;
        }
        this.userId = (Integer)attrs.get("uid");
        if (attrs.containsKey("owner")) {
            this.userName = ((Principal)attrs.get("owner")).getName();
        } else if (this.userId != null) {
            cache = FileAttributes.getUserCache(path.getFileSystem());
            name = cache.get(this.userId);
            if (name == null) {
                name = FileAttributes.getPrincipalName(path, "unix:owner");
                cache.put(this.userId, name);
            }
            this.userName = name;
        } else {
            this.userName = views.contains("owner") ? FileAttributes.getPrincipalName(path, "owner:owner") : null;
        }
        this.symbolicLink = (Boolean)attrs.get("isSymbolicLink");
        this.regularFile = (Boolean)attrs.get("isRegularFile");
        this.directory = (Boolean)attrs.get("isDirectory");
        this.other = (Boolean)attrs.get("isOther");
        this.octalMode = attrs.containsKey("mode") ? (Integer)attrs.get("mode") & 0xFFF : -1;
        this.permissions = attrs.containsKey("permissions") ? (Set)attrs.get("permissions") : Collections.emptySet();
        this.size = (Long)attrs.get("size");
        this.lastModifiedTime = (FileTime)attrs.get("lastModifiedTime");
    }

    @Nullable
    private static String getPrincipalName(Path path, String attribute) {
        try {
            Object owner = Files.getAttribute(path, attribute, LinkOption.NOFOLLOW_LINKS);
            return ((Principal)owner).getName();
        }
        catch (IOException e) {
            return null;
        }
    }

    public FileAttributes(@Nullable Integer userId, String userName, @Nullable Integer groupId, @Nullable String groupName, int octalMode, boolean symbolicLink, boolean regularFile, boolean directory, boolean other, Set<PosixFilePermission> permissions, long size, FileTime lastModifiedTime) {
        this.userId = userId;
        this.userName = userName;
        this.groupId = groupId;
        this.groupName = groupName;
        this.octalMode = octalMode;
        this.symbolicLink = symbolicLink;
        this.regularFile = regularFile;
        this.directory = directory;
        this.other = other;
        this.permissions = permissions;
        this.size = size;
        this.lastModifiedTime = lastModifiedTime;
    }

    @Nonnull
    public static PlexusIoResourceAttributes uncached(@Nonnull File file) throws IOException {
        return new FileAttributes(file);
    }

    @Override
    @Nullable
    public Integer getGroupId() {
        return this.groupId;
    }

    public boolean hasGroupId() {
        return false;
    }

    public boolean hasUserId() {
        return false;
    }

    @Override
    @Nullable
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Integer getUserId() {
        return this.userId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public boolean isGroupExecutable() {
        return this.containsPermission(PosixFilePermission.GROUP_EXECUTE);
    }

    private boolean containsPermission(PosixFilePermission groupExecute) {
        return this.permissions.contains((Object)groupExecute);
    }

    @Override
    public boolean isGroupReadable() {
        return this.containsPermission(PosixFilePermission.GROUP_READ);
    }

    @Override
    public boolean isGroupWritable() {
        return this.containsPermission(PosixFilePermission.GROUP_WRITE);
    }

    @Override
    public boolean isOwnerExecutable() {
        return this.containsPermission(PosixFilePermission.OWNER_EXECUTE);
    }

    @Override
    public boolean isOwnerReadable() {
        return this.containsPermission(PosixFilePermission.OWNER_READ);
    }

    @Override
    public boolean isOwnerWritable() {
        return this.containsPermission(PosixFilePermission.OWNER_WRITE);
    }

    @Override
    public boolean isWorldExecutable() {
        return this.containsPermission(PosixFilePermission.OTHERS_EXECUTE);
    }

    @Override
    public boolean isWorldReadable() {
        return this.containsPermission(PosixFilePermission.OTHERS_READ);
    }

    @Override
    public boolean isWorldWritable() {
        return this.containsPermission(PosixFilePermission.OTHERS_WRITE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append("File Attributes:");
        sb.append(System.lineSeparator());
        sb.append("------------------------------");
        sb.append(System.lineSeparator());
        sb.append("user: ");
        sb.append(this.userName == null ? "" : this.userName);
        sb.append(System.lineSeparator());
        sb.append("group: ");
        sb.append(this.groupName == null ? "" : this.groupName);
        sb.append(System.lineSeparator());
        sb.append("uid: ");
        sb.append(this.hasUserId() ? Integer.toString(this.userId) : "");
        sb.append(System.lineSeparator());
        sb.append("gid: ");
        sb.append(this.hasGroupId() ? Integer.toString(this.groupId) : "");
        return sb.toString();
    }

    @Override
    public int getOctalMode() {
        return this.octalMode;
    }

    public int calculatePosixOctalMode() {
        int result = 0;
        if (this.isOwnerReadable()) {
            result |= 0x100;
        }
        if (this.isOwnerWritable()) {
            result |= 0x80;
        }
        if (this.isOwnerExecutable()) {
            result |= 0x40;
        }
        if (this.isGroupReadable()) {
            result |= 0x20;
        }
        if (this.isGroupWritable()) {
            result |= 0x10;
        }
        if (this.isGroupExecutable()) {
            result |= 8;
        }
        if (this.isWorldReadable()) {
            result |= 4;
        }
        if (this.isWorldWritable()) {
            result |= 2;
        }
        if (this.isWorldExecutable()) {
            result |= 1;
        }
        return result;
    }

    public String getOctalModeString() {
        return Integer.toString(this.getOctalMode(), 8);
    }

    @Override
    public boolean isSymbolicLink() {
        return this.symbolicLink;
    }

    public boolean isRegularFile() {
        return this.regularFile;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isOther() {
        return this.other;
    }

    public long getSize() {
        return this.size;
    }

    public FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    protected Set<PosixFilePermission> getPermissions() {
        return this.permissions;
    }
}

