/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.recipe.AbstractRecipe;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.RecipeHelper;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.CastUtils;
import org.codehaus.plexus.component.MapOrientedComponent;
import org.codehaus.plexus.component.builder.ComponentBuildListener;
import org.codehaus.plexus.component.builder.ComponentBuilder;
import org.codehaus.plexus.component.collections.ComponentList;
import org.codehaus.plexus.component.collections.ComponentMap;
import org.codehaus.plexus.component.configurator.BasicComponentConfigurator;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.composite.MapConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.codehaus.plexus.component.configurator.converters.special.ClassRealmConverter;
import org.codehaus.plexus.component.configurator.expression.DefaultExpressionEvaluator;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.factory.java.JavaComponentFactory;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentRequirementList;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class XBeanComponentBuilder
implements ComponentBuilder {
    private ComponentManager componentManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public XBeanComponentBuilder() {
    }

    public XBeanComponentBuilder(ComponentManager componentManager) {
        this.setComponentManager(componentManager);
    }

    public ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    protected MutablePlexusContainer getContainer() {
        return this.componentManager.getContainer();
    }

    public Object build(ComponentDescriptor descriptor, ClassRealm realm, ComponentBuildListener listener) throws ComponentInstantiationException, ComponentLifecycleException {
        if (listener != null) {
            listener.beforeComponentCreate(descriptor, realm);
        }
        Object component = this.createComponentInstance(descriptor, realm);
        if (listener != null) {
            listener.componentCreated(descriptor, component, realm);
        }
        this.startComponentLifecycle(component, realm);
        if (listener != null) {
            listener.componentConfigured(descriptor, component, realm);
        }
        return component;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object createComponentInstance(ComponentDescriptor descriptor, ClassRealm realm) throws ComponentInstantiationException, ComponentLifecycleException {
        MutablePlexusContainer container = this.getContainer();
        if (realm == null) {
            realm = container.getComponentRealm(descriptor.getRealmId());
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
        try {
            Object object;
            ObjectRecipe recipe = this.createObjectRecipe(descriptor, realm);
            ComponentFactory componentFactory = container.getComponentFactoryManager().findComponentFactory(descriptor.getComponentFactory());
            if (JavaComponentFactory.class.equals(componentFactory.getClass())) {
                object = recipe.create();
            } else {
                object = componentFactory.newInstance(descriptor, realm, container);
                recipe.setProperties(object);
            }
            if (object instanceof MapOrientedComponent) {
                MapOrientedComponent mapOrientedComponent = (MapOrientedComponent)object;
                this.processMapOrientedComponent(descriptor, mapOrientedComponent, realm);
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception e) {
            throw new ComponentLifecycleException("Error constructing component " + descriptor.getHumanReadableKey(), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    public ObjectRecipe createObjectRecipe(ComponentDescriptor descriptor, ClassRealm realm) throws ComponentInstantiationException, PlexusConfigurationException {
        String typeName = descriptor.getImplementation();
        String factoryMethod = null;
        String[] constructorArgNames = null;
        Class[] constructorArgTypes = null;
        ObjectRecipe recipe = new ObjectRecipe(typeName, factoryMethod, constructorArgNames, constructorArgTypes);
        recipe.allow(Option.FIELD_INJECTION);
        recipe.allow(Option.PRIVATE_PROPERTIES);
        if (!this.isMapOrientedClass(typeName, realm)) {
            PlexusConfiguration configuration;
            for (ComponentRequirement requirement : CastUtils.cast(descriptor.getRequirements(), ComponentRequirement.class)) {
                String name = requirement.getFieldName();
                RequirementRecipe requirementRecipe = new RequirementRecipe(descriptor, requirement, this.getContainer(), name == null);
                if (name != null) {
                    recipe.setProperty(name, (Object)requirementRecipe);
                    continue;
                }
                recipe.setAutoMatchProperty(requirement.getRole(), (Object)requirementRecipe);
            }
            if (this.shouldConfigure(descriptor, realm) && (configuration = descriptor.getConfiguration()) != null) {
                Object[] objectArray = configuration.getAttributeNames();
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    String value;
                    String name = objectArray[n];
                    try {
                        value = configuration.getAttribute(name);
                    }
                    catch (PlexusConfigurationException e) {
                        throw new ComponentInstantiationException("Error getting value for attribute " + name, e);
                    }
                    name = this.fromXML(name);
                    recipe.setProperty(name, (Object)value);
                    ++n;
                }
                objectArray = configuration.getChildren();
                n = 0;
                n2 = objectArray.length;
                while (n < n2) {
                    Object child = objectArray[n];
                    String name = child.getName();
                    name = this.fromXML(name);
                    if (child.getChildCount() == 0) {
                        recipe.setProperty(name, (Object)child.getValue());
                    } else {
                        recipe.setProperty(name, (Object)new PlexusConfigurationRecipe((PlexusConfiguration)child));
                    }
                    ++n;
                }
            }
        }
        return recipe;
    }

    protected boolean shouldConfigure(ComponentDescriptor descriptor, ClassRealm realm) {
        String configuratorId = descriptor.getComponentConfigurator();
        if (StringUtils.isEmpty((String)configuratorId)) {
            return true;
        }
        try {
            ComponentConfigurator componentConfigurator = (ComponentConfigurator)this.getContainer().lookup(ComponentConfigurator.ROLE, configuratorId, realm);
            return componentConfigurator == null || componentConfigurator.getClass().equals(BasicComponentConfigurator.class);
        }
        catch (ComponentLookupException componentLookupException) {
            return true;
        }
    }

    protected String fromXML(String elementName) {
        return StringUtils.lowercaseFirstLetter((String)StringUtils.removeAndHump((String)elementName, (String)"-"));
    }

    protected void startComponentLifecycle(Object component, ClassRealm realm) throws ComponentLifecycleException {
        try {
            this.componentManager.getLifecycleHandler().start(component, this.componentManager, realm);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error starting component", e);
        }
    }

    private boolean isMapOrientedClass(String typeName, ClassRealm realm) {
        try {
            Class clazz = realm.loadClass(typeName);
            return MapOrientedComponent.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private void processMapOrientedComponent(ComponentDescriptor descriptor, MapOrientedComponent mapOrientedComponent, ClassRealm realm) throws ComponentConfigurationException, ComponentLookupException {
        MutablePlexusContainer container = this.getContainer();
        for (ComponentRequirement requirement : CastUtils.cast(descriptor.getRequirements(), ComponentRequirement.class)) {
            String role = requirement.getRole();
            String hint = requirement.getRoleHint();
            String mappingType = requirement.getFieldMappingType();
            Object value = StringUtils.isNotEmpty((String)hint) && !hint.equals("default") ? container.lookup(role, hint) : ("single".equals(mappingType) ? container.lookup(role, hint) : ("map".equals(mappingType) ? container.lookupMap(role) : ("set".equals(mappingType) ? new HashSet(CastUtils.cast(container.lookupList(role))) : container.lookup(role, hint))));
            mapOrientedComponent.addComponentRequirement(requirement, value);
        }
        MapConverter converter = new MapConverter();
        DefaultConverterLookup converterLookup = new DefaultConverterLookup();
        DefaultExpressionEvaluator expressionEvaluator = new DefaultExpressionEvaluator();
        PlexusConfiguration configuration = container.getConfigurationSource().getConfiguration(descriptor);
        if (configuration != null) {
            Map context = (Map)converter.fromConfiguration(converterLookup, configuration, null, null, (ClassLoader)realm, expressionEvaluator, null);
            mapOrientedComponent.setComponentConfiguration(context);
        }
    }

    public static class RequirementRecipe
    extends AbstractRecipe {
        private ComponentDescriptor componentDescriptor;
        private ComponentRequirement requirement;
        private PlexusContainer container;
        private boolean autoMatch;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;

        public RequirementRecipe(ComponentDescriptor componentDescriptor, ComponentRequirement requirement, PlexusContainer container, boolean autoMatch) {
            this.componentDescriptor = componentDescriptor;
            this.requirement = requirement;
            this.container = container;
            this.autoMatch = autoMatch;
        }

        public boolean canCreate(Type expectedType) {
            if (!this.autoMatch) {
                return true;
            }
            ClassRealm realm = (ClassRealm)Thread.currentThread().getContextClassLoader();
            Class propertyType = RecipeHelper.toClass((Type)expectedType);
            if (propertyType.isArray() || Map.class.isAssignableFrom(propertyType) || Collection.class.isAssignableFrom(propertyType) || this.requirement instanceof ComponentRequirementList) {
                return false;
            }
            try {
                ComponentDescriptor descriptor = ((MutablePlexusContainer)this.container).getComponentRepository().getComponentDescriptor(this.requirement.getRole(), this.requirement.getRoleHint(), realm);
                String typeName = descriptor.getImplementation();
                Class actualClass = realm.loadClass(typeName);
                if (RecipeHelper.isAssignable((Type)expectedType, (Type)actualClass)) {
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }

        protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
            ClassRealm realm = (ClassRealm)Thread.currentThread().getContextClassLoader();
            Class propertyType = RecipeHelper.toClass((Type)expectedType);
            try {
                Object assignment;
                String role = this.requirement.getRole();
                List roleHints = null;
                if (this.requirement instanceof ComponentRequirementList) {
                    roleHints = ((ComponentRequirementList)this.requirement).getRoleHints();
                }
                if (propertyType.isArray()) {
                    assignment = new ArrayList(CastUtils.cast(this.container.lookupList(role, roleHints, realm)));
                } else if (Map.class.equals((Object)propertyType)) {
                    assignment = new ComponentMap(this.container, realm, role, roleHints, this.componentDescriptor.getHumanReadableKey());
                } else if (List.class.equals((Object)propertyType)) {
                    assignment = new ComponentList(this.container, realm, role, roleHints, this.componentDescriptor.getHumanReadableKey());
                } else if (Set.class.equals((Object)propertyType) || Collection.class.isAssignableFrom(propertyType)) {
                    assignment = this.container.lookupMap(role, roleHints, realm);
                } else if (Logger.class.equals((Object)propertyType)) {
                    assignment = this.container.getLoggerManager().getLoggerForComponent(this.componentDescriptor.getRole());
                } else if (PlexusContainer.class.equals((Object)propertyType)) {
                    assignment = this.container;
                } else {
                    String roleHint = this.requirement.getRoleHint();
                    assignment = this.container.lookup(role, roleHint, realm);
                }
                return assignment;
            }
            catch (ComponentLookupException e) {
                throw new ConstructionException("Composition failed of field " + this.requirement.getFieldName() + " " + "in object of type " + this.componentDescriptor.getImplementation() + " because the requirement " + this.requirement + " was missing (lookup realm: " + realm.getId() + ")", (Throwable)e);
            }
        }

        public String toString() {
            return "RequirementRecipe[fieldName=" + this.requirement.getFieldName() + ", role=" + this.componentDescriptor.getRole() + "]";
        }
    }

    private class PlexusConfigurationRecipe
    extends AbstractRecipe {
        private final PlexusConfiguration child;

        public PlexusConfigurationRecipe(PlexusConfiguration child) {
            this.child = child;
        }

        public boolean canCreate(Type type) {
            try {
                ConverterLookup lookup = this.createConverterLookup();
                lookup.lookupConverterForType(RecipeHelper.toClass((Type)type));
                return true;
            }
            catch (ComponentConfigurationException componentConfigurationException) {
                return false;
            }
        }

        protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
            try {
                ConverterLookup lookup = this.createConverterLookup();
                ConfigurationConverter converter = lookup.lookupConverterForType(RecipeHelper.toClass((Type)expectedType));
                ObjectRecipe caller = (ObjectRecipe)RecipeHelper.getCaller();
                Class parentClass = RecipeHelper.toClass((Type)caller.getType());
                Object value = converter.fromConfiguration(lookup, this.child, RecipeHelper.toClass((Type)expectedType), parentClass, Thread.currentThread().getContextClassLoader(), new DefaultExpressionEvaluator());
                return value;
            }
            catch (ComponentConfigurationException componentConfigurationException) {
                throw new ConstructionException("Unable to convert configuration for property " + this.child.getName() + " to " + RecipeHelper.toClass((Type)expectedType).getName());
            }
        }

        private ConverterLookup createConverterLookup() {
            ClassRealm realm = (ClassRealm)Thread.currentThread().getContextClassLoader();
            DefaultConverterLookup lookup = new DefaultConverterLookup();
            lookup.registerConverter(new ClassRealmConverter(realm));
            return lookup;
        }
    }
}

