/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.metadata.ComponentDescriptorExtractorSupport;
import org.codehaus.plexus.metadata.MetadataGenerationRequest;
import org.codehaus.plexus.metadata.gleaner.QDoxComponentGleaner;
import org.codehaus.plexus.metadata.gleaner.SourceComponentGleaner;
import org.codehaus.plexus.util.StringUtils;

public class SourceComponentDescriptorExtractor
extends ComponentDescriptorExtractorSupport {
    private SourceComponentGleaner gleaner;
    private String encoding;

    public SourceComponentDescriptorExtractor() {
    }

    public SourceComponentDescriptorExtractor(String encoding) {
        this.encoding = encoding;
    }

    public SourceComponentDescriptorExtractor(SourceComponentGleaner gleaner) {
        this.gleaner = gleaner;
    }

    public SourceComponentDescriptorExtractor(SourceComponentGleaner gleaner, String encoding) {
        this.gleaner = gleaner;
        this.encoding = encoding;
    }

    public List extract(MetadataGenerationRequest configuration, ComponentDescriptor[] roleDefaults) throws Exception {
        if (this.gleaner == null) {
            this.gleaner = new QDoxComponentGleaner();
        }
        return this.extract(configuration.sourceDirectories, this.getDefaultsByRole(roleDefaults));
    }

    private List extract(List sourceDirectories, Map defaultsByRole) throws Exception {
        assert (sourceDirectories != null);
        assert (defaultsByRole != null);
        ArrayList<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>();
        JavaDocBuilder builder = new JavaDocBuilder();
        if (StringUtils.isNotEmpty((String)this.encoding)) {
            builder.setEncoding(this.encoding);
        }
        Iterator iter = sourceDirectories.iterator();
        while (iter.hasNext()) {
            File dir = new File((String)iter.next());
            builder.addSourceTree(dir);
        }
        JavaClass[] classes = builder.getClasses();
        for (int i = 0; i < classes.length; ++i) {
            ComponentDescriptor descriptor = this.gleaner.glean((JavaClassCache)builder, classes[i]);
            if (descriptor == null) continue;
            this.applyDefaults(descriptor, defaultsByRole);
            descriptors.add(descriptor);
        }
        return descriptors;
    }
}

