/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.ann;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.metadata.ann.Ann;
import org.codehaus.plexus.metadata.ann.AnnClass;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnMethod {
    private final AnnClass owner;
    private final int access;
    private final String name;
    private final String desc;
    private Map<String, Ann> anns = new LinkedHashMap<String, Ann>();
    private Map<Integer, Map<String, Ann>> paramAnns = new HashMap<Integer, Map<String, Ann>>();

    public AnnMethod(AnnClass owner, int access, String name, String desc) {
        this.owner = owner;
        this.access = access;
        this.name = name;
        this.desc = desc;
    }

    public int getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Map<String, Ann> getAnns() {
        return this.anns;
    }

    public Map<Integer, Map<String, Ann>> getParamAnns() {
        return this.paramAnns;
    }

    public void addAnn(Ann ann) {
        this.anns.put(ann.getDesc(), ann);
    }

    public void addParamAnn(int parameter, Ann ann) {
        Map<String, Ann> anns = this.paramAnns.get(parameter);
        if (anns == null) {
            anns = new LinkedHashMap<String, Ann>();
            this.paramAnns.put(parameter, anns);
        }
        anns.put(ann.getDesc(), ann);
    }

    public <T> T getAnnotation(Class<T> c) {
        Ann ann = this.anns.get(Type.getDescriptor(c));
        return ann == null ? null : (T)ann.getAnnotation(c, this.owner.getClassLoader());
    }

    public <T> T getParameterAnnotation(int parameter, Class<T> c) {
        Map<String, Ann> anns = this.paramAnns.get(parameter);
        if (anns == null) {
            return null;
        }
        Ann ann = anns.get(Type.getDescriptor(c));
        return ann == null ? null : (T)ann.getAnnotation(c, this.owner.getClassLoader());
    }
}

