/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata.merge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.codehaus.plexus.metadata.merge.MergeException;
import org.codehaus.plexus.metadata.merge.Merger;
import org.codehaus.plexus.util.IOUtil;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMerger
implements Merger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMergedDocument(Document mergedDocument, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        XMLOutputter out = new XMLOutputter();
        OutputStreamWriter fw = null;
        try {
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            out.output(mergedDocument, (Writer)fw);
        }
        catch (Throwable throwable) {
            IOUtil.close(fw);
            throw throwable;
        }
        IOUtil.close((Writer)fw);
    }

    @Override
    public void mergeDescriptors(File outputDescriptor, List<File> descriptors) throws IOException {
        SAXBuilder builder = new SAXBuilder();
        Document finalDoc = null;
        for (File f : descriptors) {
            try {
                Document doc = builder.build(f);
                if (finalDoc != null) {
                    finalDoc = this.merge(doc, finalDoc);
                    continue;
                }
                finalDoc = doc;
            }
            catch (JDOMException e) {
                throw new IOException("Invalid input descriptor for merge: " + f);
            }
            catch (MergeException e) {
                throw new IOException("Error merging descriptor: " + f);
            }
        }
        if (finalDoc != null) {
            try {
                this.writeMergedDocument(finalDoc, outputDescriptor);
            }
            catch (IOException e) {
                throw new IOException("Error writing merged descriptor: " + outputDescriptor);
            }
        }
    }
}

