/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.metadata;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassCache;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.metadata.ComponentDescriptorCreator;
import org.codehaus.plexus.metadata.ComponentDescriptorCreatorException;
import org.codehaus.plexus.metadata.ComponentDescriptorWriter;
import org.codehaus.plexus.metadata.ComponentGleaner;
import org.codehaus.plexus.metadata.merge.MergeException;
import org.codehaus.plexus.metadata.merge.Merger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DefaultComponentDescriptorCreator
extends AbstractLogEnabled
implements ComponentDescriptorCreator {
    private List gleaners;
    private Merger merger;
    private ComponentDescriptorWriter writer;

    public void processSources(File[] sourceDirectories, File outputFile) throws ComponentDescriptorCreatorException {
        this.processSources(sourceDirectories, outputFile, false, new ComponentDescriptor[0]);
    }

    public void processSources(File[] sourceDirectories, File outputFile, boolean containerDescriptor, ComponentDescriptor[] roleDefaults) throws ComponentDescriptorCreatorException {
        JavaDocBuilder builder = new JavaDocBuilder();
        this.getLogger().debug("Source directories: ");
        for (int it = 0; it < sourceDirectories.length; ++it) {
            File sourceDirectory = sourceDirectories[it];
            if (!sourceDirectory.isDirectory()) {
                this.getLogger().debug("Specified source directory isn't a directory: '" + sourceDirectory.getAbsolutePath() + "'.");
            }
            this.getLogger().debug(" - " + sourceDirectory.getAbsolutePath());
            builder.addSourceTree(sourceDirectory);
        }
        JavaSource[] javaSources = builder.getSources();
        HashMap<String, ComponentDescriptor> defaultsByRole = new HashMap<String, ComponentDescriptor>();
        if (roleDefaults != null) {
            for (int i = 0; i < roleDefaults.length; ++i) {
                defaultsByRole.put(roleDefaults[i].getRole(), roleDefaults[i]);
            }
        }
        ArrayList<ComponentDescriptor> componentDescriptors = new ArrayList<ComponentDescriptor>();
        HashMap<JavaClass, ComponentDescriptor> abstractComponentMap = new HashMap<JavaClass, ComponentDescriptor>();
        for (int i = 0; i < javaSources.length; ++i) {
            JavaClass javaClass;
            if ("package-info.java".equalsIgnoreCase(javaSources[i].getFile().getName()) || (javaClass = this.getJavaClass(javaSources[i])) == null) continue;
            for (ComponentGleaner gleaner : this.gleaners) {
                ComponentDescriptor abstractComponent;
                this.getLogger().debug("Trying gleaner: " + gleaner);
                ComponentDescriptor componentDescriptor = gleaner.glean((JavaClassCache)builder, javaClass);
                if (javaClass.isAbstract()) {
                    abstractComponentMap.put(javaClass, componentDescriptor);
                    continue;
                }
                if (componentDescriptor == null) continue;
                if (defaultsByRole.containsKey(componentDescriptor.getRole())) {
                    ComponentDescriptor desc = (ComponentDescriptor)defaultsByRole.get(componentDescriptor.getRole());
                    if (componentDescriptor.getInstantiationStrategy() == null) {
                        componentDescriptor.setInstantiationStrategy(desc.getInstantiationStrategy());
                    }
                }
                if ((abstractComponent = (ComponentDescriptor)abstractComponentMap.get(javaClass.getSuperJavaClass())) != null) {
                    Iterator k = abstractComponent.getRequirements().iterator();
                    while (k.hasNext()) {
                        componentDescriptor.addRequirement((ComponentRequirement)k.next());
                    }
                }
                componentDescriptors.add(componentDescriptor);
            }
        }
        ComponentSetDescriptor componentSetDescriptor = new ComponentSetDescriptor();
        componentSetDescriptor.setComponents(componentDescriptors);
        componentSetDescriptor.setDependencies(Collections.EMPTY_LIST);
        this.validateConfiguration(componentSetDescriptor);
        if (componentDescriptors.size() == 0 && componentSetDescriptor.getDependencies().size() == 0) {
            this.getLogger().debug("No components or dependencies found, not writing components.xml");
            return;
        }
        File parentFile = outputFile.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new ComponentDescriptorCreatorException("Could not make parent directory: '" + parentFile.getAbsolutePath() + "'.");
        }
        try {
            this.writer.writeDescriptorSet(new FileWriter(outputFile), componentSetDescriptor, containerDescriptor);
        }
        catch (Exception e) {
            throw new ComponentDescriptorCreatorException("Error while writing the component descriptor to: '" + outputFile.getAbsolutePath() + "'.", e);
        }
    }

    public void mergeDescriptors(File outputDescriptor, List descriptors) throws ComponentDescriptorCreatorException {
        SAXBuilder builder = new SAXBuilder();
        Document finalDoc = null;
        for (File f : descriptors) {
            try {
                Document doc = builder.build(f);
                if (finalDoc != null) {
                    finalDoc = this.merger.merge(doc, finalDoc);
                    continue;
                }
                finalDoc = doc;
            }
            catch (JDOMException e) {
                throw new ComponentDescriptorCreatorException("Invalid input descriptor for merge: " + f, e);
            }
            catch (IOException e) {
                throw new ComponentDescriptorCreatorException("Error reading input descriptor for merge: " + f, e);
            }
            catch (MergeException e) {
                throw new ComponentDescriptorCreatorException("Error merging descriptor: " + f, e);
            }
        }
        if (finalDoc != null) {
            try {
                this.merger.writeMergedDocument(finalDoc, outputDescriptor);
            }
            catch (IOException e) {
                throw new ComponentDescriptorCreatorException("Error writing merged descriptor: " + outputDescriptor, e);
            }
        }
    }

    private void validateConfiguration(ComponentSetDescriptor componentSetDescriptor) throws ComponentDescriptorCreatorException {
        List dependencies = componentSetDescriptor.getDependencies();
        if (dependencies == null) {
            return;
        }
        for (ComponentDependency dependency : dependencies) {
            if (StringUtils.isEmpty((String)dependency.getGroupId())) {
                throw new ComponentDescriptorCreatorException("Missing dependency element: 'groupId'.");
            }
            if (StringUtils.isEmpty((String)dependency.getArtifactId())) {
                throw new ComponentDescriptorCreatorException("Missing dependency element: 'artifactId'.");
            }
            if (StringUtils.isEmpty((String)dependency.getVersion())) {
                throw new ComponentDescriptorCreatorException("Missing dependency element: 'version'.");
            }
            if (!StringUtils.isEmpty((String)dependency.getType())) continue;
            throw new ComponentDescriptorCreatorException("Missing dependency element: 'type'.");
        }
    }

    public void writeDependencies(XMLWriter w, ComponentSetDescriptor componentSetDescriptor) {
        throw new UnsupportedOperationException("This operation is no longer supported");
    }

    private JavaClass getJavaClass(JavaSource javaSource) {
        if (javaSource.getClasses().length == 0) {
            return null;
        }
        return javaSource.getClasses()[0];
    }
}

